/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.validation;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xsl.ui.internal.validation.DelegatingSourceValidatorForXSL;
import org.eclipse.wst.xsl.ui.tests.UnzippedProjectTester;

public class TestDelegatingSourceValidatorForXSL
extends UnzippedProjectTester {
    DelegatingSourceValidatorForXSL sourceValidator = new DelegatingSourceValidatorForXSL();

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private String getxslTestFilesProjectName() {
        return "xsltestfiles";
    }

    public void testXSLT2XPath20Fails() {
        String projName = this.getxslTestFilesProjectName();
        String fileName1 = "ChangeRequestsByResponsibility.xsl";
        String validateFilePath = String.valueOf(projName) + File.separator + fileName1;
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(validateFilePath));
        if (file != null && !file.exists()) {
            TestDelegatingSourceValidatorForXSL.fail((String)("Unable to locate " + fileName1 + " stylesheet."));
        }
        WorkbenchContext context = new WorkbenchContext();
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(String.valueOf(File.separator) + validateFilePath);
        context.setValidationFileURIs(fileList);
        TestReporter reporter = new TestReporter();
        try {
            this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
        TestDelegatingSourceValidatorForXSL.assertTrue((String)"No Messages were reported on file with invalid XPath 1.0.", (boolean)reporter.isMessageReported());
    }

    public void testValidXSLT() {
        String projName = this.getxslTestFilesProjectName();
        String fileName1 = "ListAllChangeRequests.xsl";
        String validateFilePath = String.valueOf(projName) + File.separator + fileName1;
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(validateFilePath));
        if (file != null && !file.exists()) {
            TestDelegatingSourceValidatorForXSL.fail((String)("Unable to locate " + fileName1 + " stylesheet."));
        }
        WorkbenchContext context = new WorkbenchContext();
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(String.valueOf(File.separator) + validateFilePath);
        context.setValidationFileURIs(fileList);
        TestReporter reporter = new TestReporter();
        try {
            this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
        TestDelegatingSourceValidatorForXSL.assertFalse((String)("Messages were reported on " + fileName1 + "."), (boolean)reporter.isMessageReported());
    }

    private class TestReporter
    implements IReporter {
        protected boolean messageReported = false;

        public void addMessage(IValidator origin, IMessage message) {
            if (message.getSeverity() == 1) {
                this.messageReported = true;
            }
        }

        public boolean isMessageReported() {
            return this.messageReported;
        }

        public void displaySubtask(IValidator validator, IMessage message) {
        }

        public List getMessages() {
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public void removeAllMessages(IValidator origin, Object object) {
        }

        public void removeAllMessages(IValidator origin) {
        }

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        }
    }
}

