/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import java.util.Map;
import org.apache.xerces.util.XMLChar;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.viewers.ResourceFilter;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.SchemaLocationSection;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.wizards.XSDSelectIncludeFileWizard;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.w3c.dom.Element;

public class XSDImportSection
extends SchemaLocationSection {
    protected Text namespaceText;
    protected Text prefixText;
    protected String oldPrefixValue;

    public void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        CLabel namespaceLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_NAMESPACE"));
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        namespaceLabel.setLayoutData((Object)data);
        this.namespaceText = this.getWidgetFactory().createText(this.composite, "", 0);
        this.namespaceText.setEditable(false);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.applyAllListeners((Control)this.namespaceText);
        this.namespaceText.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.getWidgetFactory().createCLabel(this.composite, "");
        CLabel prefixLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_PREFIX"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        prefixLabel.setLayoutData((Object)data);
        this.prefixText = this.getWidgetFactory().createText(this.composite, "", 0);
        this.prefixText.setEditable(true);
        this.applyAllListeners((Control)this.prefixText);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.prefixText.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.getWidgetFactory().createCLabel(this.composite, "");
        CLabel schemaLocationLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_LOCATION"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        schemaLocationLabel.setLayoutData((Object)data);
        this.schemaLocationText = this.getWidgetFactory().createText(this.composite, "", 0);
        this.schemaLocationText.setEditable(true);
        this.applyAllListeners((Control)this.schemaLocationText);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.schemaLocationText.setLayoutData((Object)data);
        this.wizardButton = this.getWidgetFactory().createButton(this.composite, "", 0);
        this.wizardButton.setImage(XSDEditorPlugin.getXSDImage("icons/browsebutton.gif"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.wizardButton.setLayoutData((Object)data);
        this.wizardButton.addSelectionListener((SelectionListener)this);
        this.errorText = new StyledText(this.composite, 0x800000);
        this.errorText.setEditable(false);
        this.errorText.setEnabled(false);
        this.errorText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        this.errorText.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.schemaLocationText, "org.eclipse.wst.xsd.ui.xsdup0370");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.namespaceText, "org.eclipse.wst.xsd.ui.xsdup0380");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.prefixText, "org.eclipse.wst.xsd.ui.xsdup0390");
    }

    public void refresh() {
        this.setListenerEnabled(false);
        this.errorText.setText("");
        Element element = null;
        if (this.input instanceof XSDImport) {
            element = ((XSDImport)this.input).getElement();
            String namespace = element.getAttribute("namespace");
            String schemaLocation = element.getAttribute("schemaLocation");
            TypesHelper helper = new TypesHelper(this.xsdSchema);
            String prefix = helper.getPrefix(element.getAttribute("namespace"), false);
            if (namespace == null) {
                namespace = "";
            }
            if (prefix == null) {
                prefix = "";
            }
            if (schemaLocation == null) {
                schemaLocation = "";
            }
            this.namespaceText.setText(namespace);
            this.prefixText.setText(prefix);
            this.schemaLocationText.setText(schemaLocation);
            this.oldPrefixValue = this.prefixText.getText();
        }
        this.setListenerEnabled(true);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.wizardButton) {
            ResourceFilter filter;
            this.setListenerEnabled(false);
            Shell shell = Display.getCurrent().getActiveShell();
            IFile currentIFile = null;
            IEditorInput editorInput = this.getActiveEditor().getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                currentIFile = ((IFileEditorInput)editorInput).getFile();
                filter = new ResourceFilter(new String[]{".xsd"}, new IFile[]{currentIFile}, null);
            } else {
                filter = new ResourceFilter(new String[]{".xsd"}, null, null);
            }
            XSDSelectIncludeFileWizard fileSelectWizard = new XSDSelectIncludeFileWizard(this.xsdSchema, false, XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_SCHEMA"), XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_DESC"), (ViewerFilter)filter, (IStructuredSelection)this.getSelection());
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)fileSelectWizard);
            wizardDialog.create();
            wizardDialog.setBlockOnOpen(true);
            int result = wizardDialog.open();
            String value = this.schemaLocationText.getText();
            this.prefixText.removeListener(24, (Listener)this);
            if (result == 0) {
                this.errorText.setText("");
                IFile selectedIFile = fileSelectWizard.getResultFile();
                String schemaFileString = value;
                schemaFileString = selectedIFile != null && currentIFile != null ? URIHelper.getRelativeURI((IPath)selectedIFile.getLocation(), (IPath)currentIFile.getLocation()) : (selectedIFile != null && currentIFile == null ? selectedIFile.getLocationURI().toString() : fileSelectWizard.getURL());
                String namespace = fileSelectWizard.getNamespace();
                if (namespace == null) {
                    namespace = "";
                }
                XSDSchema externalSchema = fileSelectWizard.getExternalSchema();
                this.handleSchemaLocationChange(schemaFileString, namespace, externalSchema);
            }
            this.setListenerEnabled(true);
            this.prefixText.addListener(24, (Listener)this);
        }
    }

    protected void handleSchemaLocationChange(String schemaFileString, String namespace, XSDSchema externalSchema) {
        if (this.input instanceof XSDImport) {
            XSDImport xsdImport = (XSDImport)this.input;
            xsdImport.setNamespace(namespace);
            xsdImport.setSchemaLocation(schemaFileString);
            xsdImport.setResolvedSchema(externalSchema);
            Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
            Element schemaElement = this.xsdSchema.getElement();
            TypesHelper helper = new TypesHelper(externalSchema);
            String prefix = helper.getPrefix(namespace, false);
            if (map.containsKey(prefix)) {
                prefix = null;
            }
            if (prefix == null || prefix != null && prefix.length() == 0) {
                StringBuffer newPrefix = new StringBuffer("pref");
                int prefixExtension = 1;
                while (map.containsKey(newPrefix.toString()) && prefixExtension < 100) {
                    newPrefix = new StringBuffer("pref" + String.valueOf(prefixExtension));
                    ++prefixExtension;
                }
                prefix = newPrefix.toString();
            }
            if (namespace.length() > 0) {
                if (map.containsValue(namespace)) {
                    TypesHelper typesHelper = new TypesHelper(this.xsdSchema);
                    prefix = typesHelper.getPrefix(namespace, false);
                } else {
                    schemaElement.setAttribute("xmlns:" + prefix, namespace);
                }
                this.prefixText.setText(prefix);
            } else {
                this.prefixText.setText("");
                this.namespaceText.setText("");
            }
            if (this.input instanceof XSDImportImpl) {
                XSDImportImpl xsdImportImpl = (XSDImportImpl)this.input;
                xsdImportImpl.importSchema();
            }
        }
        this.refresh();
    }

    public void doHandleEvent(Event event) {
        this.setErrorMessage(null);
        super.doHandleEvent(event);
        if (event.widget == this.prefixText) {
            String newPrefix = this.prefixText.getText();
            if (this.oldPrefixValue.equals(newPrefix) || !this.isValidSchemaLocation) {
                return;
            }
            Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
            String key = this.prefixText.getText();
            if (key.length() == 0) {
                key = null;
            }
            if (this.validatePrefix(newPrefix) && this.schemaLocationText.getText().trim().length() > 0) {
                if (map.containsKey(key)) {
                    this.setErrorMessage(XSDEditorPlugin.getXSDString("_ERROR_LABEL_PREFIX_EXISTS"));
                } else {
                    Element schemaElement = this.xsdSchema.getElement();
                    if (key != null) {
                        if (this.oldPrefixValue.length() == 0) {
                            schemaElement.removeAttribute("xmlns");
                        } else {
                            schemaElement.removeAttribute("xmlns:" + this.oldPrefixValue);
                        }
                        schemaElement.setAttribute("xmlns:" + newPrefix, this.namespaceText.getText());
                    } else {
                        schemaElement.removeAttribute("xmlns:" + this.oldPrefixValue);
                        schemaElement.setAttribute("xmlns", this.namespaceText.getText());
                    }
                    this.xsdSchema.updateElement();
                    this.setErrorMessage(null);
                    this.oldPrefixValue = newPrefix;
                }
            } else {
                this.setErrorMessage(XSDEditorPlugin.getXSDString("_ERROR_LABEL_INVALID_PREFIX"));
            }
        }
    }

    public void aboutToBeHidden() {
        this.setErrorMessage(null);
        super.aboutToBeHidden();
    }

    protected boolean validatePrefix(String prefix) {
        if (prefix.length() == 0) {
            return true;
        }
        return XMLChar.isValidNCName((String)prefix);
    }
}

