/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.validation.IDependencyIndex;
import org.eclipse.wst.validation.MessageSeveritySetting;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.Deserializer;
import org.eclipse.wst.validation.internal.Serializer;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.tests.Misc;
import org.eclipse.wst.validation.tests.TestValidator;
import org.eclipse.wst.validation.tests.TestValidator2;
import org.eclipse.wst.validation.tests.TestValidator4;
import org.eclipse.wst.validation.tests.TestValidator5D;
import org.eclipse.wst.validation.tests.TestValidator6;
import org.eclipse.wst.validation.tests.TestValidator7;
import org.eclipse.wst.validation.tests.ValCounters;
import org.eclipse.wst.validation.tests.testcase.TestEnvironment;

public class TestSuite1
extends TestCase {
    private TestEnvironment _env;
    private IProject _testProject;
    private IFile _mapTest1;

    public static Test suite() {
        return new TestSuite(TestSuite1.class);
    }

    public TestSuite1(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._env = new TestEnvironment();
        this._testProject = this._env.findProject("TestProject");
        if (this._testProject != null) {
            return;
        }
        this._env.turnoffAutoBuild();
        TestSuite1.enableOnlyTestValidators();
        this._testProject = this._env.createProject("TestProject");
        IPath folder = this._env.addFolder(this._testProject.getFullPath(), "source");
        this._env.addFile(folder, "first.test1", "include map.test1\ninfo - information\nwarning - warning\nerror - error\n\nt1error - extra error\nt1warning - extra warning");
        this._env.addFile(folder, "second.test1", "info - information\nwarning - warning\nerror - error\n\nt1error - extra error\nt1warning - extra warning");
        this._mapTest1 = this._env.addFile(folder, "map.test1", "# will hold future mappings\n\n# syntax: map target replacement\n# for example map t1error error - would replace all t1error tokens with error");
        this._env.addFile(folder, "first.test2", "# sample file");
        this._env.addFile(folder, "third.test4", "# Doesn't really matter\n# We just want to make the build a bit slower.");
        this._env.addFile(folder, "fourth.test4", "# Doesn't really matter");
        this._env.addFile(folder, "fifth.test5", "# Doesn't really matter");
        this._env.addFile(folder, "forFun.xml", "<fun>times</fun>");
        this._env.addFile(this._testProject.getFullPath(), "file.specific", "# This should be validated by Test2");
        this._env.addFile(folder, "file.specific", "# This should be validated by Test2");
        this._env.addFile(this._testProject.getFullPath(), "full.specific", "# This should not be validated by Test2");
        this._env.addFile(folder, "full.specific", "# This should be validated by Test2");
    }

    private static void enableOnlyTestValidators() throws InvocationTargetException {
        Validator[] vals;
        Validator[] validatorArray = vals = ValManager.getDefault().getValidatorsCopy();
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            boolean enable = v.getValidatorClassname().startsWith("org.eclipse.wst.validation.tests.Test");
            v.setBuildValidation(enable);
            v.setManualValidation(enable);
            ++n2;
        }
        ValPrefManagerGlobal gp = ValPrefManagerGlobal.getDefault();
        gp.saveAsPrefs(vals);
        TestEnvironment.saveV1Preferences(vals);
    }

    protected void tearDown() throws Exception {
        this._env.dispose();
        super.tearDown();
    }

    public void testIndex() {
        ValidationFramework vf = ValidationFramework.getDefault();
        IDependencyIndex index = vf.getDependencyIndex();
        TestSuite1.assertNotNull((Object)index);
    }

    public void testIndex2() throws CoreException, InterruptedException {
        ValidationFramework vf = ValidationFramework.getDefault();
        IDependencyIndex index = vf.getDependencyIndex();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource r = root.findMember("TestProject/source/map.test1");
        IProject p = r.getProject();
        p.build(6, (IProgressMonitor)new NullProgressMonitor());
        ValidationFramework.getDefault().join(null);
        r = root.findMember("TestProject/source/first.test1");
        TestSuite1.assertFalse((boolean)index.isDependedOn(r));
    }

    public void testGetValidators() {
        IResource resource;
        ValidationFramework vf = ValidationFramework.getDefault();
        Validator[] validators = vf.getValidatorsFor(resource = this._env.getWorkspace().getRoot().findMember("TestProject/source/first.test1"), false, false);
        TestSuite1.assertTrue((validators.length > 0 ? 1 : 0) != 0);
        String id = TestValidator.id();
        int count = 0;
        int i = 0;
        while (i < validators.length) {
            if (validators[i].getId().equals(id)) {
                ++count;
            }
            ++i;
        }
        TestSuite1.assertEquals((int)1, (int)count);
    }

    public void testTest1() throws CoreException, UnsupportedEncodingException, InterruptedException {
        Tracing.log((String)"TestSuite-02: testTest1 starting");
        NullProgressMonitor monitor = new NullProgressMonitor();
        ValidationFramework vf = ValidationFramework.getDefault();
        IProject[] projects = new IProject[]{this._testProject};
        ValidationResults vr = vf.validate(projects, true, false, (IProgressMonitor)monitor);
        IResource resource = this._env.getWorkspace().getRoot().findMember("TestProject/source/first.test1");
        this.checkFirstPass(resource, vr);
        this._env.incrementalBuild();
        Thread.sleep(2000L);
        vf.join((IProgressMonitor)monitor);
        ByteArrayInputStream in = new ByteArrayInputStream("map t1error error\nmap t1warning warning".getBytes());
        this._mapTest1.setContents((InputStream)in, true, true, (IProgressMonitor)monitor);
        Thread.sleep(2000L);
        TestValidator4.getCounters().reset();
        TestValidator5D.getCounters().reset();
        this._env.incrementalBuild();
        Thread.sleep(2000L);
        vf.join((IProgressMonitor)monitor);
        ValCounters vc = TestValidator4.getCounters();
        Tracing.log((String)("TestSuite-03: testTest1: " + vc.toString()));
        TestSuite1.assertEquals((int)vc.startingCount, (int)vc.finishedCount);
        TestSuite1.assertEquals((int)vc.startingProjectCount, (int)vc.finishedProjectCount);
        TestSuite1.assertEquals((int)vc.startingCount, (int)1);
        TestSuite1.assertEquals((int)vc.finishedCount, (int)1);
        vc = TestValidator5D.getCounters();
        TestSuite1.assertEquals((int)vc.startingCount, (int)vc.finishedCount);
        TestSuite1.assertEquals((int)vc.startingProjectCount, (int)vc.finishedProjectCount);
        TestSuite1.assertEquals((int)vc.startingCount, (int)1);
        TestSuite1.assertEquals((int)vc.finishedCount, (int)1);
        TestSuite1.assertTrue((String)"We expect the delegating validator Test5D to be called at least once", (TestValidator5D.getCalledCount() > 0 ? 1 : 0) != 0);
        this.checkSecondPass(resource);
        Tracing.log((String)"TestSuite-04:testTest1 finished");
    }

    public void testTest2() {
        Validator[] vals;
        ValidationFramework vf = ValidationFramework.getDefault();
        IResource test2 = this._testProject.findMember("source/first.test2");
        TestSuite1.assertNotNull((Object)test2);
        Validator[] validatorArray = vals = vf.getValidatorsFor(test2, true, true);
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            String id = v.getId();
            if (id.equals(TestValidator.id())) {
                TestSuite1.fail((String)"first.test2 should not be validated by the test1 validator");
            }
            ++n2;
        }
        IResource test1 = this._testProject.findMember("source/first.test1");
        TestSuite1.assertNotNull((Object)test1);
        vals = vf.getValidatorsFor(test1, true, true);
        boolean found = false;
        Validator[] validatorArray2 = vals;
        int n3 = vals.length;
        int n4 = 0;
        while (n4 < n3) {
            Validator v = validatorArray2[n4];
            String id = v.getId();
            if (id.equals(TestValidator.id())) {
                found = true;
            }
            ++n4;
        }
        TestSuite1.assertTrue((boolean)found);
    }

    public void testCountValidators() {
        int count = 0;
        Validator[] validatorArray = ValManager.getDefault().getValidators();
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            int i = v.getId().indexOf(".Test");
            if (i != -1) {
                ++count;
            }
            ++n2;
        }
        TestSuite1.assertEquals((String)"Expected number of Test validators", (int)8, (int)count);
    }

    public void testMessages() {
        ValidationFramework vf = ValidationFramework.getDefault();
        Validator v = vf.getValidator(TestValidator2.id(), null);
        TestSuite1.assertNotNull((String)"We expected to find TestValidator2", (Object)v);
        MessageSeveritySetting ms = v.getMessage("bad");
        TestSuite1.assertNotNull((String)"We expected to find a message for 'bad'", (Object)ms);
        TestSuite1.assertEquals((Object)MessageSeveritySetting.Severity.Error, (Object)ms.getCurrent());
        TestSuite1.assertEquals((int)4, (int)v.getMessageSettings().size());
    }

    public void testSerialize() {
        Serializer s = new Serializer(20);
        s.put(true);
        s.put(false);
        s.put("Hi there");
        s.put(25);
        String test = s.toString();
        Deserializer d = new Deserializer(test);
        TestSuite1.assertTrue((boolean)d.getBoolean());
        TestSuite1.assertFalse((boolean)d.getBoolean());
        TestSuite1.assertEquals((String)"Hi there", (String)d.getString());
        TestSuite1.assertTrue((boolean)d.hasNext());
        TestSuite1.assertEquals((int)25, (int)d.getInt());
        TestSuite1.assertFalse((boolean)d.hasNext());
    }

    public void testSuspend() throws CoreException, InterruptedException {
        ValidationFramework vf = ValidationFramework.getDefault();
        Validator v = vf.getValidator(TestValidator6.id(), null);
        TestValidator6 t6 = (TestValidator6)v.asV2Validator().getValidator();
        v = vf.getValidator(TestValidator7.id(), null);
        TestValidator7 t7 = (TestValidator7)v.asV2Validator().getValidator();
        t7.reset();
        long start = System.currentTimeMillis();
        this._env.fullBuild2(null);
        Thread.sleep(1000L);
        vf.join(null);
        long first = System.currentTimeMillis();
        long valBuild = first - start;
        TestSuite1.assertTrue((String)("We expect the build to take longer than 3s, but it completed in " + valBuild + "ms"), (valBuild > 3000L ? 1 : 0) != 0);
        IResource projectFile = this._testProject.findMember(".project");
        TestSuite1.assertFalse((String)"We should not be validating the .product file", (boolean)t6.getSet().contains(projectFile));
        TestSuite1.assertEquals((String)"We expected the validation to be suspended after the first call", (int)1, (int)t7.getSet().size());
        vf.suspendAllValidation(true);
        this._env.fullBuild2(null);
        Thread.sleep(1000L);
        vf.join(null);
        long second = System.currentTimeMillis();
        vf.suspendAllValidation(false);
        long novalBuild = second - first;
        TestSuite1.assertTrue((String)("We except the build to go faster with validation turned off, but it was " + (novalBuild - valBuild) + " ms faster"), (novalBuild < valBuild ? 1 : 0) != 0);
        TestSuite1.assertEquals((String)"We expected the validation to be suspended after the first call", (int)1, (int)t7.getSet().size());
    }

    private void checkFirstPass(IResource resource, ValidationResults vr) throws CoreException {
        TestSuite1.assertEquals((String)"Expected number of error messages", (int)5, (int)vr.getSeverityError());
        TestSuite1.assertEquals((String)"Expected number of warning messages", (int)2, (int)vr.getSeverityWarning());
        TestSuite1.assertEquals((String)"Expected number of info messages", (int)2, (int)vr.getSeverityInfo());
        TestSuite1.assertEquals((String)"Expected number of messages", (int)9, (int)vr.getMessages().length);
        IMarker[] markers = resource.findMarkers("org.eclipse.wst.validation.problemmarker2", false, 0);
        int errors = 0;
        int warnings = 0;
        int info = 0;
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            int severity = marker.getAttribute("severity", -1);
            switch (severity) {
                case 2: {
                    ++errors;
                    break;
                }
                case 1: {
                    ++warnings;
                    break;
                }
                case 0: {
                    ++info;
                }
            }
            ++n2;
        }
        TestSuite1.assertTrue((String)("We expect there to be exactly one error message, but errors=" + errors), (errors == 1 ? 1 : 0) != 0);
        TestSuite1.assertTrue((String)("We expect there to be exactly one warning message, but warnings=" + warnings), (warnings == 1 ? 1 : 0) != 0);
        TestSuite1.assertTrue((String)("We expect there to be exactly one info message, but info=" + info), (info == 1 ? 1 : 0) != 0);
    }

    private void checkSecondPass(IResource resource) throws CoreException {
        IMarker[] markers = resource.findMarkers("org.eclipse.wst.validation.problemmarker2", false, 0);
        int errors = 0;
        int warnings = 0;
        int info = 0;
        int i = 0;
        while (i < markers.length) {
            int severity = markers[i].getAttribute("severity", -1);
            switch (severity) {
                case 2: {
                    ++errors;
                    break;
                }
                case 1: {
                    ++warnings;
                    break;
                }
                case 0: {
                    ++info;
                }
            }
            ++i;
        }
        if (Tracing.isLogging()) {
            Tracing.log((String)("TestSuite-01: checkSecondPass: " + Misc.listMarkers(resource)));
        }
        TestSuite1.assertTrue((String)("We expect there to be exactly two error messages, but errors=" + errors), (errors == 2 ? 1 : 0) != 0);
        TestSuite1.assertTrue((String)("We expect there to be exactly two warning messages, but warnings=" + warnings), (warnings == 2 ? 1 : 0) != 0);
        TestSuite1.assertTrue((String)("We expect there to be exactly one info message, but info=" + info), (info == 1 ? 1 : 0) != 0);
    }
}

