/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class BasicResolveTests
extends AbstractRegressionTest {
    public BasicResolveTests(String name) {
        super(name);
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(){\n\t  abc(); \n}\n"}, "----------\n1. ERROR in X.js (at line 2)\n\tabc(); \n\t^^^\nThe function abc() is undefined\n----------\n");
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(a){\n\t  foo(a); \n}\n"}, "");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.js", "var i;i=1;\n\n"}, "");
        this.runNegativeTest(new String[]{"X.js", "var i;\ni=j;\n"}, "----------\n1. ERROR in X.js (at line 2)\n\ti=j;\n\t  ^\nj cannot be resolved\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.js", "var win=debugger;\nObject();\n\n"}, "");
        this.runNegativeTest(new String[]{"X.js", "var i;\ni=j;\n"}, "----------\n1. ERROR in X.js (at line 2)\n\ti=j;\n\t  ^\nj cannot be resolved\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.js", "Object();\n\n"}, "");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.js", "MyClass.prototype.someMethod = MyClass_someMethod;function MyClass(){}function MyClass_someMethod(){}var myClassObj = new MyClass();\nmyClassObj.someMethod();\n"}, "");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.js", "function MyClass() {\n  this.url = \"\";\n  this.activate = function(){}\n}\nvar myClassObj = new MyClass();\nvar u=myClassObj.url;\n\n"}, "");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.js", "function Bob(firstname, lastname) {\n   this.Firstname = firstname;\n   this.Lastname = lastname;\n}\nBob.prototype.name = function () {return this.Firstname + this.Lastname;};\n"}, "");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.js", "var SingleQuote = {\n   Version: '1.1-beta2' \n}\n"}, "");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.js", "var o = {x:1, y: 2, name: \"print\" };\no.Z = 0; \n"}, "");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n\t\tvar t = new Test();\n}\n   function Test()\n{\n}\n"}, "");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n\tvar i=1;\n\tif (2>i )\n\t\tfoo();\n}\n"}, "");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n\tvar ff=function(p) \n\t{var c=p;};\n\tff(1);\n}\n"}, "");
    }

    public void test022b() {
        this.runNegativeTest(new String[]{"X.js", "\tvar ff=function(p) \n\t{var c=p;};\n\tff(1);\n"}, "");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"X.js", "\tvar ff=new String();\n"}, "");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.js", " function bar() {;\nreturn Test.x;\n}\nTest.prototype=new Object();\nTest.x=1;\n"}, "");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.js", " function g() {\nreturn null;\n}\nfunction foo() {\n\tg();\n}\n"}, "");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.js", "var i=[10];\n"}, "");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.js", " function bar(vv) {;\nreturn vv%4;\n}\n"}, "");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.js", "var c=false;\nvar d=!c;\n"}, "");
    }

    public void test029() {
        this.runNegativeTest(new String[]{"X.js", "var d=new Date(1);\n"}, "");
    }

    public void test030() {
        this.runNegativeTest(new String[]{"X.js", "function foo(e) {\nvar x= 10, z = null, i, j;\n}\n"}, "");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.js", "function OBJ(){}\nvar o = new OBJ();\n"}, "");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.js", "var foo;\n foo.onMouseDown = function () { return 1; };\n foo.onMouseDown();\n"}, "");
    }

    public void test032b() {
        this.runNegativeTest(new String[]{"X.js", "var foo;\n foo.level1=new Object();\n foo.level1.onMouseDown = function () { return 1; };\n foo.level1.onMouseDown();\n"}, "");
    }

    public void test033() {
        this.runNegativeTest(new String[]{"X.js", " if (typeof abc == \"undefined\") {}\n"}, "");
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.js", " if (true) {\n   var abc=1;}\n var d=abc;\n"}, "");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.js", " function foo() {\n   var vv=arguments;}\n"}, "");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.js", " function foo() {\n   function inner(){}\n   inner();\n   }\n"}, "");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.js", " var s = new String();\n var sub=s.substring(0,0);\n var i=sub.length;\n"}, "");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.js", " s = new String();\n sub=s.substring(0,0);\n i=sub.length;\n"}, "");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.js", " var s = \"\";\n with (s) {\n   var i=length;\n }\n"}, "");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.js", " var s = \"\";\n with (s) {\n   var i=charAt(0);\n }\n"}, "");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.js", "var x = {};\nvar b=x;\n;b.a=\"\";\n;x.a = \"\""}, "");
    }

    public void test042() {
        this.runNegativeTest(new String[]{"X.js", "var x = {};\nx.a.b = \"\""}, "----------\n1. WARNING in X.js (at line 2)\n\tx.a.b = \"\"\n\t  ^\na cannot be resolved or is not a field\n----------\n");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.js", "var x = null;\nx>3;var y;\ny=null;\ny>3"}, "");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.js", " if (typeof abc == \"undefined\") { abc=1;}\n var c= abc;\n"}, "");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.js", " var a,b=1;\n var c= b;\n function abc(){ var d= 1,e=4;\n var f=e;}\n"}, "");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.js", "function debug2() {\n var keyFunct = null;\n keyFunct = function () {};\n  keyFunct();\n  }\n"}, "");
    }

    public void test046b() {
        this.runNegativeTest(new String[]{"X.js", "function debug2() {\n var keyFunct = null;\n keyFunct = new function () {};\n  keyFunct();\n  }\n"}, "");
    }

    public void test047() {
        this.runNegativeTest(new String[]{"X.js", "function Config() {}\nConfig.printDocTypes = function() { throw new (\"doctype 1.\"); };\nConfig.prototype.toString = function () { return \"\"; };\nfunction main() {\n    Config.printDocTypes();\n}   \n"}, "");
    }

    public void test048() {
        this.runNegativeTest(new String[]{"X.js", "function Config2() {};\nConfig2.INPUT_DIR = \"\";\nConfig2.OUTPUT_DIR = Config2.INPUT_DIR  ;\nConfig2.getNum = function() { return 1; }\nfunction numberGen() { \n    return Config2.getNum(); \n}   \n"}, "");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.js", "var arr=[];\nvar ref=arr.length;\nvar o=arr.pop();\n"}, "");
    }

    public void test050() {
        this.runNegativeTest(new String[]{"X.js", "function getDateTime() {\n\t    this.ctime = new Object();\n\t    this.ctime.getDay = new function() { return \"Mon\"; };\n\t    return this;\n\t}\n\tfunction debug3() {\n\t    var newObj = getDateTime();\n\t    return newObj.ctime.getDay();\n\t}\n"}, "");
    }

    public void test050b() {
        this.runNegativeTest(new String[]{"X.js", "function getDateTime() {\n\t    this.ctime = new Object();\n\t    this.ctime.getDay = new function() { return \"Mon\"; };\n\t    return this;\n\t}\n\tfunction debug3() {\n\t    var newObj = new getDateTime();\n\t    return newObj.ctime.getDay();\n\t}\n"}, "");
    }

    public void test051() {
        this.runNegativeTest(new String[]{"X.js", "var ns = {};\nns.foo = function(){\n};\nns.foo.prototype.bar = \"\";\nns.foo.prototype.bar2 = function(){\n  return \"\";\n}\nc=new ns.foo();\nc.bar2();\ni=c.bar;\n"}, "");
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.js", "var myObject=new Object();\nmyObject.ctor=   function(){\n};\nmyObject.ctor.prototype.bar = \"\";\nmyObject.ctor.prototype.bar2 = function(){\n  return \"\";\n}\nc=new myObject.ctor();\nc.bar2();\ni=c.bar;\n"}, "");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.js", "function funccall(pp){}\nfunccall({\nmeth : function(){  \n  var c=this.i; },\n i : 1 \n});\n"}, "");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.js", "function func1(pp){}\nfunc1();\nfunction obj(){}\nvar o=new obj(1);\n"}, "----------\n1. WARNING in X.js (at line 2)\n\tfunc1();\n\t^^^^^^^\nWrong number of arguments for the function func1 (), expecting 1 argument(s), but there was 0 \n----------\n2. WARNING in X.js (at line 4)\n\tvar o=new obj(1);\n\t      ^^^^^^^^^^\nWrong number of arguments for the function obj (), expecting 0 argument(s), but there was 1 \n----------\n");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"X.js", "function func1(base,mixin){\nvar bp = (base||0).prototype;\n}\n"}, "");
    }

    public void test056() {
        this.runNegativeTest(new String[]{"X.js", "var arr=[];\narr.push(1);\n"}, "");
    }

    public void test057() {
        this.runNegativeTest(new String[]{"X.js", "var arr= {\n  func: function(){ \n       this.func();\n   } \n};\n"}, "");
    }

    public void test058() {
        this.runNegativeTest(new String[]{"X.js", "var cls= {};\ncls.arr={};\ncls.arr[\"ss\"]=1;\nvar dd=cls.arr[\"ssd\"];\n"}, "");
    }

    public void test059() {
        this.runNegativeTest(new String[]{"X.js", "/**\n * Valid class javadoc\n * @param {String | Number} p1 param def\n */\nfunction foo(p1){\np1.length;\np1.toPrecision(1);\n}\n"}, "");
    }

    public void test060() {
        this.runNegativeTest(new String[]{"X.js", "function foo(p1){\np1();\n}\n"}, "");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"X.js", "function foo(){\np1=1;\np1();\n}\n"}, "----------\n1. WARNING in X.js (at line 3)\n\tp1();\n\t^^\np1 is not a function \n----------\n");
    }

    public void test062() {
        this.runNegativeTest(new String[]{"X.js", "var cc=function(){\n  function inner(){}\n  var dd=inner;\n}\n"}, "");
    }

    public void test063() {
        this.runNegativeTest(new String[]{"X.js", "var cc=function(){\n  var ii;\n  function inner(){\n    var dd=ii;\n  }\n}\n"}, "");
    }

    public void test064() {
        this.runNegativeTest(new String[]{"X.js", "  function inner(){\n  var ii=0,i2=ii+1;\n}\n"}, "");
    }

    public void test065() {
        this.runNegativeTest(new String[]{"X.js", "  function inner(aArray){\n  var number = 0;\n  number -= aArray.length;\n  number += aArray.length;\n  return number;\n}\n"}, "");
    }

    public void test066() {
        this.runNegativeTest(new String[]{"X.js", "  TestClass = function() {\n  }\n  TestClass.prototype = new Object();\n  ns=new Object();\n  ns.TestClass = function() {\n  }\n  ns.TestClass.prototype = new Object();\n"}, "");
    }

    public void test067() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(a){\n\t  doo(a); \n}\n", "Y.js", "\tfunction doo(a){\n\t  foo(a); \n}\n"}, "");
    }

    public void test068() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(param1 , param2){\n\tif(\"\" || 0) {} \n\t var value = param1 || param2; \n\t if(param1 || param2) {} \n}\n"}, "");
    }

    public void test070() {
        this.runNegativeTest(new String[]{"X.js", "\tvar s=new String();\n\ts.length=1; \n\n"}, "");
    }

    public void testbug255428() {
        this.runNegativeTest(new String[]{"X.js", "\t function MyClass(){}\n MyClass.prototype = {\n    a : 0,\n     myfunc : function(){} \n };\nfunction test() { \n     var lObj = new MyClass();\n     lObj.a = 2;\n     lObj.myfunc();\n}\n"}, "");
    }

    public void testbug259187() {
        this.runNegativeTest(new String[]{"X.js", "var params = \"some?string\".split('?');\nvar base = params.shift();"}, "----------\n1. WARNING in X.js (at line 1)\n\tvar params = \"some?string\".split('?');\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^\nWrong number of arguments for the function split (), expecting 2 argument(s), but there was 1 \n----------\n");
        this.runNegativeTest(new String[]{"Y.js", "var substr = \"some?string\".substring('?');\n"}, "----------\n1. WARNING in Y.js (at line 1)\n\tvar substr = \"some?string\".substring('?');\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nWrong number of arguments for the function substring (), expecting 2 argument(s), but there was 1 \n----------\n");
    }
}

