/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import org.eclipse.wst.jsdt.core.infer.InferOptions;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class InferTypesTests
extends AbstractRegressionTest {
    public InferTypesTests(String name) {
        super(name);
    }

    private InferOptions getDefaultOptions() {
        InferOptions inferOptions = new InferOptions();
        inferOptions.setDefaultOptions();
        return inferOptions;
    }

    public void test001() {
        this.runInferTest("function MyClass() {\n  this.url = \"\";\n  this.activate = function(){}\n}\nvar myClassObj = new MyClass();\n\n", "X.js", "class MyClass extends Object{\n  String url;\n  MyClass()\n  void activate()\n}\n", this.getDefaultOptions());
    }

    public void test002() {
        this.runInferTest("Shape.prototype.GetArea = Shape_GetArea;function Shape(){}function Shape_GetArea(){ this.area=5;return this.area;}", "X.js", "class Shape extends Object{\n  Number area;\n  Number GetArea()\n  Shape()\n}\n", this.getDefaultOptions());
    }

    public void test003() {
        this.runInferTest("Shape.prototype.GetArea = function(a){};function Shape(){}\n", "X.js", "class Shape extends Object{\n  void GetArea(a)\n  Shape()\n}\n", this.getDefaultOptions());
    }

    public void test004() {
        this.runInferTest("Shape.prototype.GetArea = Shape_GetArea;function Shape(){}function Shape_GetArea(){return this.area;}Circle.prototype = new Shape();Circle.prototype.constructor = Circle;Circle.prototype.GetArea = Circle_GetArea;function Circle_GetArea(){}", "X.js", "class Shape extends Object{\n  ?? GetArea()\n  Shape()\n}\nclass Circle extends Shape{\n  ?? constructor;\n  void GetArea()\n}\n", this.getDefaultOptions());
    }

    public void test010() {
        this.runInferTest("function Bob(firstname, lastname) {\n   this.Firstname = firstname;\n   this.Lastname = lastname;\n}\nBob.prototype.name = function () {return this.Firstname + this.Lastname;};\n", "X.js", "class Bob extends Object{\n  ?? Firstname;\n  ?? Lastname;\n  ?? name()\n  Bob(firstname, lastname)\n}\n", this.getDefaultOptions());
    }

    public void test011() {
        this.runInferTest("function X() {\n  this.h=1;\n  this.i=[];\n}\nfunction X_foo() {\n}\nX.prototype.foo=X_foo;\n", "X.js", "class X extends Object{\n  Number h;\n  Array i;\n  void foo()\n  X()\n}\n", this.getDefaultOptions());
    }

    public void test011b() {
        this.runInferTest("P.prototype=new Object();\nP.prototype.f=1;\nfunction P(){}\nfunction a(){}\nfunction m() {\n                this.f++;\n                var p= new P();\n                    a();}\nP.prototype.mm=m;\n", "X.js", "class P extends Object{\n  Number f;\n  void mm()\n  P()\n}\n", this.getDefaultOptions());
    }

    public void test012() {
        this.runInferTest("Test.prototype=new Object();\nTest.x=1;\n", "X.js", "class Test extends Object{\n  static Number x;\n}\n", this.getDefaultOptions());
    }

    public void test013() {
        this.runInferTest("function MyClass() {\n  this.arr = [1];\n}\nvar myClassObj = new MyClass();\n\n", "X.js", "class MyClass extends Object{\n  Array(Number) arr;\n  MyClass()\n}\n", this.getDefaultOptions());
    }

    public void test020() {
        this.runInferTest("var foo;\n  foo.onMouseDown = function () { return 1; };\n\n", "X.js", "class ___foo0 extends Object{\n  static Number onMouseDown()\n}\n", this.getDefaultOptions());
    }

    public void test040() {
        this.runInferTest("/**\n * @constructor \n */\nfunction MyClass(){}/**\n * @memberOf MyClass \n * @type String \n */\nvar s;/**\n * @memberOf MyClass \n * @type Number \n */\nfunction numValue(){};\n", "X.js", "class MyClass extends Object{\n  String s;\n  MyClass()\n  Number numValue()\n}\n", this.getDefaultOptions());
    }

    public void test041() {
        this.runInferTest(" i= { \n/**\n   * @memberOf MyClass\n   * @type Number\n */\n a: 2 ,\n/**\n   * @memberOf MyClass\n   * @type String\n */\n b: function(){}};\n", "X.js", "class MyClass extends Object{\n  Number a;\n  String b()\n}\n", this.getDefaultOptions());
    }

    public void test042() {
        this.runInferTest("/**\n * @constructor \n * @extends String \n */\nfunction MyClass(){}MyClass.prototype = { \n/**\n   * @memberOf MyClass\n   * @type Number\n */\n a: 2 ,\n/**\n   * @memberOf MyClass\n   * @type String\n */\n b: function(){}};\n", "X.js", "class MyClass extends String{\n  Number a;\n  MyClass()\n  String b()\n}\n", this.getDefaultOptions());
    }

    public void test043() {
        this.runInferTest("/**\n * @constructor \n */\nfunction MyClass(){}/**\n * @memberOf MyClass \n * @param {Number} p1\n * @type String \n */\nfunction foo(p1){};\n", "X.js", "class MyClass extends Object{\n  MyClass()\n  String foo(Number p1)\n}\n", this.getDefaultOptions());
    }

    public void test060() {
        this.runInferTest("Shape.prototype.GetArea = Shape_GetArea;function Shape_GetArea(){ var str=\"\";return str;}", "X.js", "class Shape extends Object{\n  String GetArea()\n}\n", this.getDefaultOptions());
    }

    public void test061() {
        this.runInferTest("var foo = {  bar: \"bar\",  bar2: function(){}}", "X.js", "class ___anonymous10_44 extends Object{\n  String bar;\n  void bar2()\n}\n", this.getDefaultOptions());
    }

    public void test062() {
        this.runInferTest("var foo;foo = {  bar: \"bar\",  bar2: function(){}}", "X.js", "class ___anonymous14_48 extends Object{\n  String bar;\n  void bar2()\n}\n", this.getDefaultOptions());
    }

    public void test063() {
        this.runInferTest("var foo = {  bar: \"bar\",  bar2: {    bar3: \"bar3\"  }}", "X.js", "class ___anonymous10_52 extends Object{\n  String bar;\n  ___anonymous32_51 bar2;\n}\nclass ___anonymous32_51 extends Object{\n  String bar3;\n}\n", this.getDefaultOptions());
    }

    public void test064() {
        this.runInferTest("var ns = {};ns.foo = \"\";ns.bar = function(){  return \"\";}", "X.js", "class ___anonymous9_10 extends Object{\n  String foo;\n  String bar()\n}\n", this.getDefaultOptions());
    }

    public void test065() {
        this.runInferTest("var ns = {};ns.foo = {  bar: \"\"};", "X.js", "class ___anonymous9_10 extends Object{\n  ___anonymous21_31 foo;\n}\nclass ___anonymous21_31 extends Object{\n  String bar;\n}\n", this.getDefaultOptions());
    }

    public void test066() {
        this.runInferTest("function foo(){};foo.prototype = {  bar: \"\"}", "X.js", "class foo extends Object{\n  String bar;\n  foo()\n}\n", this.getDefaultOptions());
    }

    public void test067() {
        this.runInferTest("function foo(){};foo.prototype.bar = {  bar2: \"\"}", "X.js", "class foo extends Object{\n  ___anonymous37_48 bar;\n  foo()\n}\nclass ___anonymous37_48 extends Object{\n  String bar2;\n}\n", this.getDefaultOptions());
    }

    public void test068() {
        this.runInferTest("var ns = {};ns.foo = function(){};ns.foo.prototype.bar = \"\";ns.foo.prototype.bar2 = function(){  return \"\";}", "X.js", "class ___anonymous9_10 extends Object{\n  void foo()\n}\nclass ns.foo extends Object{\n  String bar;\n  String bar2()\n  ns.foo()\n}\n", this.getDefaultOptions());
    }

    public void test068b() {
        this.runInferTest("var ns = {};ns.foo = function(){};function abc(){};ns.foo2 = abc;", "X.js", "class ___anonymous9_10 extends Object{\n  void foo()\n  void foo2()\n}\n", this.getDefaultOptions());
    }

    public void test068c() {
        this.runInferTest("var ns = {};ns.foo = function(){};ns.foo2 = ns.foo;", "X.js", "class ___anonymous9_10 extends Object{\n  void foo()\n  void foo2()\n}\n", this.getDefaultOptions());
    }

    public void test069() {
        this.runInferTest("var ns1 = {  ns2: {}};ns1.ns2.foo = function(){};ns1.ns2.foo.prototype.bar = \"\";ns1.ns2.foo.prototype.bar2 = function(){  return \"\";}", "X.js", "class ___anonymous10_20 extends Object{\n  ___anonymous18_19 ns2;\n}\nclass ___anonymous18_19 extends Object{\n  void foo()\n}\nclass ns1.ns2.foo extends Object{\n  String bar;\n  String bar2()\n  ns1.ns2.foo()\n}\n", this.getDefaultOptions());
    }

    public void test070() {
        this.runInferTest("var foo = {  a: \"\",  b: function(){    return \"\";  }};foo.c = \"\";foo.d = function(x, y, z) {  return { x : \"\", y : \"\", z : \"\" };};", "X.js", "class ___anonymous10_52 extends Object{\n  String a;\n  String c;\n  String b()\n  ___anonymous101_126 d(x, y, z)\n}\nclass ___anonymous101_126 extends Object{\n  String x;\n  String y;\n  String z;\n}\n", this.getDefaultOptions());
    }

    public void test071() {
        this.runInferTest("if( true ){  var foo = {};}foo.bar = \"\"", "X.js", "class ___anonymous23_24 extends Object{\n  String bar;\n}\n", this.getDefaultOptions());
    }

    public void test072() {
        this.runInferTest("var foo = function(){\treturn {\t\tx: \"\",\t\ty: \"\"\t}};", "X.js", "class ___anonymous29_46 extends Object{\n  String x;\n  String y;\n}\n", this.getDefaultOptions());
    }

    public void test073() {
        this.runInferTest("var foo = function(){\tvar bar = {\t\tx: \"\",\t\ty: \"\"\t}};", "X.js", "class ___anonymous32_49 extends Object{\n  String x;\n  String y;\n}\n", this.getDefaultOptions());
    }

    public void test074() {
        this.runInferTest("/**\n  * Object Node()\n  * @super Object\n  * @constructor\n  * @class Node\n  * @since Standard ECMA-262 3rd. Edition\n  * @since Level 2 Document Object Model Core Definition.\n  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html\n */\nfunction Node(){};\n/**\n  * Property firstChild\n  * @type Node\n  * @class Node\n  * @see Node\n\n  * @since Standard ECMA-262 3rd. Edition\n  * @since Level 2 Document Object Model Core Definition.\n  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html\n */\nNode.prototype.firstChild=new Node();\n/**\n  * function insertBefore(newChild, refChild)\n  * @type Node\n  * @class Node\n  * @param newChilds Node\n  * @param refChild Node\n  * @return Node\n  * @throws DOMException\n  * @see Node\n  * @since Standard ECMA-262 3rd. Edition\n  * @since Level 2 Document Object Model Core Definition.\n  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html\n */\nNode.prototype.insertBefore = function(newChild, refChild){};\n", "X.js", "class Node extends Object{\n  Node firstChild;\n  Node()\n  Node insertBefore(newChild, refChild)\n}\n", this.getDefaultOptions());
    }

    public void test075() {
        this.runInferTest("var x = function(){};x.prototype = {};x.foo = \"\";x.bar = function(){  return \"\";}", "X.js", "class x extends Object{\n  static String foo;\n  static String bar()\n}\n", this.getDefaultOptions());
    }

    public void test075b() {
        this.runInferTest("function x(){};x.foo = \"\";x.bar = function(){  return \"\";}", "X.js", "class x extends Object{\n  static String foo;\n  static String bar()\n  x()\n}\n", this.getDefaultOptions());
    }

    public void test080() {
        this.runInferTest("(function(){this.someField = 1;})();", "X.js", "class Global extends Object{\n  Number someField;\n}\n", this.getDefaultOptions());
    }

    public void test081() {
        this.runInferTest("String.foo = \"\";String.bar = function(){  return \"\";}", "X.js", "class String extends Object{\n  static String foo;\n  static String bar()\n}\n", this.getDefaultOptions());
    }

    public void test082() {
        this.runInferTest("String.foo = \"\";String.bar1 = String.bar2 = function(){  return \"\";}", "X.js", "class String extends Object{\n  static String foo;\n  static String bar1()\n  static String bar2()\n}\n", this.getDefaultOptions());
    }

    public void test083() {
        this.runInferTest("function Car() {\tthis.color = 'red';\tthis.Move = function() { return \"I'm moving\"; };};Car.Stop = function() { return \"I'm not moving\"; };Car.engine = 'diesel';", "X.js", "class Car extends Object{\n  static String engine;\n  String color;\n  Car()\n  String Move()\n  static String Stop()\n}\n", this.getDefaultOptions());
    }
}

