/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class NonFatalErrorTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public NonFatalErrorTest(String name) {
        super(name);
    }

    public static Test suite() {
        return NonFatalErrorTest.buildAllCompliancesTestSuite(NonFatalErrorTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.NonFatalErrorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedImport", "error");
        this.runNegativeTestWithExecution(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\t\t public static void main(String argv[]) {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\timport java.util.*;\n\t       ^^^^^^^^^\nThe import java.util is never used\n----------\n", "SUCCESS", null, true, null, customOptions, null);
    }

    public void test002() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.fatalOptionalError", "enabled");
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedImport", "error");
        this.runNegativeTestWithExecution(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\t\t public static void main(String argv[]) {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\timport java.util.*;\n\t       ^^^^^^^^^\nThe import java.util is never used\n----------\n", "Unexpected target error running resulting class file for X.java:\njava.lang.Error: Unresolved compilation problem: \n\n", null, true, null, customOptions, null);
    }

    public void test003() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTestWithExecution(new String[]{"X.java", "public class X {\n\t\t public static void main(String argv[]) {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(\"SUCCESS\");\n\t                   ^^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", "SUCCESS", null, true, null, customOptions, null);
    }

    public void test004() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTestWithExecution(new String[]{"X.java", "public class X {\n\t\t public static void foo() {}\n\t\t public static void main(String argv[]) {\n\t\t\t\tfoo();\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void foo() {}\n\t                         ^^\nEmpty block should be documented\n----------\n", "SUCCESS", null, true, null, customOptions, null);
    }

    public void test005() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.fatalOptionalError", "enabled");
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTestWithExecution(new String[]{"X.java", "public class X {\n\t\t public static void foo() {}\n\t\t public static void main(String argv[]) {\n\t\t\t\tfoo();\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void foo() {}\n\t                         ^^\nEmpty block should be documented\n----------\n", "Unexpected target error running resulting class file for X.java:\njava.lang.Error: Unresolved compilation problem: \n\tEmpty block should be documented\n\n", null, true, null, customOptions, null);
    }
}

