/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.tests.dom.AbstractASTTests;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;

public class ASTModelBridgeTests
extends AbstractASTTests {
    IJavaScriptUnit workingCopy;
    static /* synthetic */ Class class$0;

    public ASTModelBridgeTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTModelBridgeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTModelBridgeTests.buildModelTestSuite(clazz);
    }

    private ASTNode buildAST(String contents) throws JavaScriptModelException {
        return this.buildAST(contents, this.workingCopy);
    }

    private IBinding[] createBindings(String contents, IJavaScriptElement element) throws JavaScriptModelException {
        this.workingCopy.getBuffer().setContents(contents);
        this.workingCopy.makeConsistent(null);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(this.getJavaProject("P"));
        IJavaScriptElement[] elements = new IJavaScriptElement[]{element};
        return parser.createBindings(elements, null);
    }

    private IBinding[] createBinaryBindings(String contents, IJavaScriptElement element) throws CoreException {
        this.createClassFile("/P/lib", "A.class", contents);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(this.getJavaProject("P"));
        IJavaScriptElement[] elements = new IJavaScriptElement[]{element};
        return parser.createBindings(elements, null);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject();
    }

    private void setUpJavaProject() throws CoreException, IOException, JavaScriptModelException {
        IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"}, new String[]{"JCL15_LIB,JCL15_SRC", "/P/lib"}, "bin", "1.5");
        project.setOption("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
        project.setOption("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "ignore");
        project.setOption("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", "ignore");
        project.setOption("org.eclipse.wst.jsdt.core.compiler.problem.localVariableHiding", "ignore");
        project.setOption("org.eclipse.wst.jsdt.core.compiler.problem.typeParameterHiding", "ignore");
        project.setOption("org.eclipse.wst.jsdt.core.compiler.problem.rawTypeReference", "ignore");
        this.addLibrary(project, "lib.jar", "libsrc.zip", new String[]{"p/Y.js", "package p;\npublic class Y<T> {\n  public Y(T t) {\n  }\n}", "p/Z.js", "package p;\npublic class Z {\n  /*start*/class Member {\n  }/*end*/\n  void foo() {\n    new Member() {};\n  }\n}", "p/W.js", "package p;\npublic class W {\n  class Member {\n    /*start*/Member(String s) {\n    }/*end*/\n  }\n}", "p/ABC.js", "package p;\npublic class ABC {\n}", "Z.js", "public class Z {\n  /*start*/class Member {\n  }/*end*/\n  void foo() {\n    new Member() {};\n  }\n}"}, "1.5");
        this.workingCopy = this.getCompilationUnit("/P/src/X.js").getWorkingCopy(new WorkingCopyOwner(){}, new IProblemRequestor(){

            public void acceptProblem(IProblem problem) {
            }

            public void beginReporting() {
            }

            public void endReporting() {
            }

            public boolean isActive() {
                return true;
            }
        }, null);
    }

    public void tearDownSuite() throws Exception {
        this.tearDownJavaProject();
        super.tearDownSuite();
    }

    private void tearDownJavaProject() throws JavaScriptModelException, CoreException {
        if (this.workingCopy != null) {
            this.workingCopy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    public void testAnonymousType() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  Object foo() {\n    return new Object() /*start*/{\n    }/*end*/;\n  }\n}");
        ITypeBinding binding = ((AnonymousClassDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "<anonymous #1> [in foo() [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testAnonymousType2() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n\tpublic void foo() {\n\t\tnew Y(0/*c*/) /*start*/{\n\t\t\tObject field;\n\t\t}/*end*/;\n\t}\n}\nclass Y {\n\tY(int i) {\n\t}\n}");
        ITypeBinding binding = ((AnonymousClassDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "<anonymous #1> [in foo() [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testArrayType1() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  /*start*/Object[]/*end*/ field;\n}");
        ITypeBinding binding = ((ArrayType)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testArrayType2() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  /*start*/char[][]/*end*/ field;\n}");
        ITypeBinding binding = ((ArrayType)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "<null>", element);
    }

    public void testBinaryMethod() throws JavaScriptModelException {
        IClassFile classFile = this.getClassFile("P", this.getExternalJCLPathString("1.5"), "java.lang", "Enum.class");
        String source = classFile.getSource();
        AbstractASTTests.MarkerInfo markerInfo = new AbstractASTTests.MarkerInfo(this, source);
        markerInfo.astStarts = new int[]{source.indexOf("protected Enum")};
        markerInfo.astEnds = new int[]{source.indexOf(125, markerInfo.astStarts[0]) + 1};
        ASTNode node = this.buildAST(markerInfo, classFile);
        IFunctionBinding binding = ((FunctionDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "Enum(java.lang.String, int) [in Enum [in Enum.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testBinaryMemberTypeConstructor() throws JavaScriptModelException {
        IClassFile classFile = this.getClassFile("P", "/P/lib.jar", "p", "W$Member.class");
        String source = classFile.getSource();
        AbstractASTTests.MarkerInfo markerInfo = new AbstractASTTests.MarkerInfo(this, source);
        markerInfo.astStarts = new int[]{source.indexOf("/*start*/") + "/*start*/".length()};
        markerInfo.astEnds = new int[]{source.indexOf("/*end*/")};
        ASTNode node = this.buildAST(markerInfo, classFile);
        IFunctionBinding binding = ((FunctionDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "Member(p.W, java.lang.String) [in Member [in W$Member.class [in p [in lib.jar [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testBinaryType() throws JavaScriptModelException {
        IClassFile classFile = this.getClassFile("P", this.getExternalJCLPathString("1.5"), "java.lang", "String.class");
        String source = classFile.getSource();
        AbstractASTTests.MarkerInfo markerInfo = new AbstractASTTests.MarkerInfo(this, source);
        markerInfo.astStarts = new int[]{source.indexOf("public")};
        markerInfo.astEnds = new int[]{source.lastIndexOf(125) + 1};
        ASTNode node = this.buildAST(markerInfo, classFile);
        ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "String [in String.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBinaryType2() throws CoreException {
        IClassFile classFile = this.getClassFile("P", "lib.jar", "p", "ABC.class");
        classFile.open(null);
        try {
            this.createFile("/P/src/Test.js", "import p.ABC;\npublic class Test extends ABC {\n}");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.getPackageFragmentRoot("/P/src")});
            this.search((IJavaScriptElement)classFile.getType(), 2, scope, new AbstractJavaSearchTests.JavaSearchResultCollector());
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.deleteFile("/P/src/Test.js");
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        this.deleteFile("/P/src/Test.js");
        String source = classFile.getSource();
        AbstractASTTests.MarkerInfo markerInfo = new AbstractASTTests.MarkerInfo(this, source);
        markerInfo.astStarts = new int[]{source.indexOf("public")};
        markerInfo.astEnds = new int[]{source.lastIndexOf(125) + 1};
        ASTNode node = this.buildAST(markerInfo, classFile);
        ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "ABC [in ABC.class [in p [in lib.jar [in P]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBinaryType3() throws CoreException, IOException {
        this.buildAST("public class X {\n    /*start*/String/*end*/ field;\n}");
        try {
            this.tearDownJavaProject();
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL15_LIB"}, "", "1.5");
            this.createFile("/P1/X.js", "public class X {\n    /*start*/String/*end*/ field;\n}");
            ASTNode node = this.buildAST(this.getCompilationUnit("/P1/X.js"));
            ITypeBinding binding = ((Type)node).resolveBinding();
            IJavaScriptElement element = binding.getJavaElement();
            this.assertElementEquals("Unexpected Java element", "String [in String.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]", element);
            ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P1");
            this.setUpJavaProject();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P1");
        this.setUpJavaProject();
    }

    public void testBinaryMemberTypeFromAnonymousClassFile1() throws JavaScriptModelException {
        IClassFile classFile = this.getClassFile("P", "/P/lib.jar", "p", "Z$1.class");
        String source = classFile.getSource();
        AbstractASTTests.MarkerInfo markerInfo = new AbstractASTTests.MarkerInfo(this, source);
        markerInfo.astStarts = new int[]{source.indexOf("/*start*/") + "/*start*/".length()};
        markerInfo.astEnds = new int[]{source.indexOf("/*end*/")};
        ASTNode node = this.buildAST(markerInfo, classFile);
        ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "Member [in Z$Member.class [in p [in lib.jar [in P]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testBinaryMemberTypeFromAnonymousClassFile2() throws JavaScriptModelException {
        IClassFile classFile = this.getClassFile("P", "/P/lib.jar", "", "Z$1.class");
        String source = classFile.getSource();
        AbstractASTTests.MarkerInfo markerInfo = new AbstractASTTests.MarkerInfo(this, source);
        markerInfo.astStarts = new int[]{source.indexOf("/*start*/") + "/*start*/".length()};
        markerInfo.astEnds = new int[]{source.indexOf("/*end*/")};
        ASTNode node = this.buildAST(markerInfo, classFile);
        ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "Member [in Z$Member.class [in <default> [in lib.jar [in P]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testCreateBindings01() throws JavaScriptModelException {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setProject(this.getJavaProject("P"));
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/P/src/X.js", "public class X {\n  public void foo(int i, String s) {\n  }\n}", owner, false);
        this.workingCopies[1] = this.getWorkingCopy("/P/src/Y.js", "public class Y extends X {\n  void bar() {\n    new Y() {};\n  }\n}", owner, false);
        this.workingCopies[2] = this.getWorkingCopy("/P/src/I.js", "public interface I {\n  int BAR;\n}", owner, false);
        IType typeX = this.workingCopies[0].getType("X");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{typeX, this.getClassFile("P", this.getExternalJCLPathString("1.5"), "java.lang", "Object.class").getType(), typeX.getFunction("foo", new String[]{"I", "QString;"}), this.workingCopies[2].getType("I").getField("BAR"), this.workingCopies[1].getType("Y").getFunction("bar", new String[0]).getType("", 1)};
        IBinding[] bindings = parser.createBindings(elements, null);
        this.assertBindingsEqual("LX;\nLjava/lang/Object;\nLX;.foo(ILjava/lang/String;)V\nLI;.BAR)I\nLY$50;", bindings);
    }

    public void testCreateBindings02() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("public class X {\n}", (IJavaScriptElement)this.workingCopy.getType("X"));
        this.assertBindingsEqual("LX;", bindings);
    }

    public void testCreateBindings03() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("public class X {\n  public class Member {\n  }\n}", (IJavaScriptElement)this.workingCopy.getType("X").getType("Member"));
        this.assertBindingsEqual("LX$Member;", bindings);
    }

    public void testCreateBindings04() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("public class X {\n  void foo() {\n    new X() {\n    };\n  }\n}", (IJavaScriptElement)this.workingCopy.getType("X").getFunction("foo", new String[0]).getType("", 1));
        this.assertBindingsEqual("LX$40;", bindings);
    }

    public void testCreateBindings05() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("public class X {\n  void foo() {\n    class Y {\n    }\n  }\n}", (IJavaScriptElement)this.workingCopy.getType("X").getFunction("foo", new String[0]).getType("Y", 1));
        this.assertBindingsEqual("LX$42$Y;", bindings);
    }

    public void testCreateBindings06() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("public class X {\n  int field;\n}", (IJavaScriptElement)this.workingCopy.getType("X").getField("field"));
        this.assertBindingsEqual("LX;.field)I", bindings);
    }

    public void testCreateBindings07() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("public class X {\n  void foo() {}\n}", (IJavaScriptElement)this.workingCopy.getType("X").getFunction("foo", new String[0]));
        this.assertBindingsEqual("LX;.foo()V", bindings);
    }

    public void testCreateBindings08() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("@interface X {\n}", (IJavaScriptElement)this.workingCopy.getType("X"));
        this.assertBindingsEqual("LX;", bindings);
    }

    public void testCreateBindings09() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("public enum X {\n}", (IJavaScriptElement)this.workingCopy.getType("X"));
        this.assertBindingsEqual("LX;", bindings);
    }

    public void testCreateBindings10() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("@interface X {\n  int foo();\n}", (IJavaScriptElement)this.workingCopy.getType("X").getFunction("foo", new String[0]));
        this.assertBindingsEqual("LX;.foo()I", bindings);
    }

    public void testCreateBindings11() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("public enum X {\n  FOO;\n}", (IJavaScriptElement)this.workingCopy.getType("X").getField("FOO"));
        this.assertBindingsEqual("LX;.FOO)LX;", bindings);
    }

    public void testCreateBindings12() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("import java.io.*;\npublic class X implements Serializable {\n  static final long serialVersionUID = 0;\n}", (IJavaScriptElement)this.workingCopy.getImport("java.io.*"));
        this.assertBindingsEqual("java/io", bindings);
    }

    public void testCreateBindings13() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("import java.io.Serializable;\npublic class X implements Serializable {\n  static final long serialVersionUID = 0;\n}", (IJavaScriptElement)this.workingCopy.getImport("java.io.Serializable"));
        this.assertBindingsEqual("Ljava/io/Serializable;", bindings);
    }

    public void testCreateBindings14() throws JavaScriptModelException {
        IBinding[] bindings = this.createBindings("public class X<T> {\n}", (IJavaScriptElement)this.workingCopy.getType("X").getTypeParameter("T"));
        this.assertBindingsEqual("LX;:TT;", bindings);
    }

    public void testCreateBindings15() throws CoreException {
        IBinding[] bindings = this.createBinaryBindings("public class A {\n}", (IJavaScriptElement)this.getClassFile("/P/lib/A.class").getType());
        this.assertBindingsEqual("LA;", bindings);
    }

    public void testCreateBindings16() throws CoreException {
        IBinding[] bindings = this.createBinaryBindings("public class A {\n  int field;\n}", (IJavaScriptElement)this.getClassFile("/P/lib/A.class").getType().getField("field"));
        this.assertBindingsEqual("LA;.field)I", bindings);
    }

    public void testCreateBindings17() throws CoreException {
        IBinding[] bindings = this.createBinaryBindings("public class A {\n  int foo(String s, boolean b) {\n    return -1;\n  }\n}", (IJavaScriptElement)this.getClassFile("/P/lib/A.class").getType().getFunction("foo", new String[]{"Ljava.lang.String;", "Z"}));
        this.assertBindingsEqual("LA;.foo(Ljava/lang/String;Z)I", bindings);
    }

    public void testCreateBindings18() throws CoreException {
        IBinding[] bindings = this.createBinaryBindings("public class A {\n  <E> void foo(E e) {\n  }\n}", (IJavaScriptElement)this.getClassFile("/P/lib/A.class").getType().getFunction("foo", new String[]{"TE;"}));
        this.assertBindingsEqual("LA;.foo<E:Ljava/lang/Object;>(TE;)V", bindings);
    }

    public void testField1() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  Object /*start*/field/*end*/;\n}");
        IVariableBinding binding = ((VariableDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "field [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testField2() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  Object foo() {\n    return new Object() {\n      Object /*start*/field/*end*/;\n    };\n  }\n}");
        IVariableBinding binding = ((VariableDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "field [in <anonymous #1> [in foo() [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testLocalType() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  void foo() {\n    /*start*/class Y {\n    }/*end*/\n  }\n}");
        ITypeBinding binding = ((TypeDeclarationStatement)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "Y [in foo() [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testLocalType2() throws CoreException {
        String filePath = "/P/src/Z.js";
        try {
            String contents = "public class Z {\n  void foo() {\n    /*start*/class Local {\n    }/*end*/\n  }\n}";
            this.createFile(filePath, contents);
            ASTNode node = this.buildAST(contents, this.getCompilationUnit(filePath));
            ITypeBinding binding = ((TypeDeclarationStatement)node).resolveBinding();
            String bindingKey = binding.getKey();
            AbstractASTTests.BindingRequestor requestor = new AbstractASTTests.BindingRequestor(this);
            String[] bindingKeys = new String[]{bindingKey};
            this.resolveASTs(new IJavaScriptUnit[0], bindingKeys, requestor, this.getJavaProject("P"), this.workingCopy.getOwner());
            IBinding[] bindings = requestor.getBindings(bindingKeys);
            IJavaScriptElement element = bindings[0].getJavaElement();
            this.assertElementEquals("Unexpected Java element", "Local [in foo() [in Z [in Z.java [in <default> [in src [in P]]]]]]", element);
            ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.deleteFile(filePath);
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        this.deleteFile(filePath);
    }

    public void testLocalVariable1() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  void foo() {\n    int /*start*/local/*end*/;\n  }\n}");
        IVariableBinding binding = ((VariableDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        ILocalVariable expected = this.getLocalVariable((ISourceReference)this.workingCopy, "local", "local");
        ASTModelBridgeTests.assertEquals((String)"Unexpected Java element", (Object)expected, (Object)element);
    }

    public void testLocalVariable2() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  void foo() {\n    Object first, /*start*/second/*end*/, third;\n  }\n}");
        IVariableBinding binding = ((VariableDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        ILocalVariable expected = this.getLocalVariable((ISourceReference)this.workingCopy, "second", "second");
        ASTModelBridgeTests.assertEquals((String)"Unexpected Java element", (Object)expected, (Object)element);
    }

    public void testLocalVariable3() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  void foo(/*start*/int arg/*end*/) {\n  }\n}");
        IVariableBinding binding = ((VariableDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        ILocalVariable expected = this.getLocalVariable((ISourceReference)this.workingCopy, "arg", "arg");
        ASTModelBridgeTests.assertEquals((String)"Unexpected Java element", (Object)expected, (Object)element);
    }

    public void testMemberType() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  /*start*/class Y {\n  }/*end*/\n}");
        ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "Y [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testMethod01() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X<K, V> {\n  /*start*/void foo(int i, Object o, java.lang.String s, Class[] c, X<K, V> x) {\n  }/*end*/\n}");
        IFunctionBinding binding = ((FunctionDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "foo(int, Object, java.lang.String, Class[], X<K,V>) [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testMethod02() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X<K, V> {\n  /*start*/void foo() {\n  }/*end*/\n}");
        IFunctionBinding binding = ((FunctionDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "foo() [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    /*
     * Exception decompiling
     */
    public void testMethod03() throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 101->105)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testMethod04() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n\tvoid foo() {\n\t\t/*start*/bar(new B<Object>())/*end*/;\n\t}\n\t<T extends Object> void bar(A<? extends T> arg) {\n\t}\n}\nclass A<T> {\n}\nclass B<T> extends A<T> {\t\n}");
        IFunctionBinding binding = ((FunctionInvocation)node).resolveMethodBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "bar(A<? extends T>) [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testMethod05() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X<T> {\n    void m(T t) { }\n}\n\nclass Y {\n    {\n        /*start*/new X<String>().m(\"s\")/*end*/;\n    }\n}");
        IFunctionBinding binding = ((FunctionInvocation)node).resolveMethodBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "m(T) [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testMethod06() throws JavaScriptModelException {
        ASTNode node = this.buildAST("@X(/*start*/value/*end*/=\"Hello\", count=-1)\n@interface X {\n    String value();\n    int count();\n}");
        IBinding binding = ((SimpleName)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "value() [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testMethod07() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  /*start*/public int[] bar(int a[]) {\n    return a;\n  }/*end*/\n}");
        IFunctionBinding binding = ((FunctionDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "bar(int[]) [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testMethod08() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  /*start*/public Object[] bar2(Object[] o[][]) [][] {\n    return o;\n  }/*end*/\n}");
        IFunctionBinding binding = ((FunctionDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "bar2(Object[][][]) [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testMethod09() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X {\n  /*start*/public void bar3(Object... objs) {\n  }/*end*/\n}");
        IFunctionBinding binding = ((FunctionDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "bar3(Object[]) [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMethod10() throws CoreException {
        try {
            this.createFile("/P/src/Test.js", "public class X {\n        void test() {\n                new Object() {\n                        /*start*/public void yes() {\n                                System.out.println(\"hello world\");\n                        }/*end*/\n                } // missing semicolon;\n        }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/src/Test.js");
            ASTNode node = this.buildAST(null, cu, false, true);
            IFunctionBinding binding = ((FunctionDeclaration)node).resolveBinding();
            ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
            IJavaScriptElement element = binding.getJavaElement();
            this.assertElementEquals("Unexpected Java element", "yes() [in <anonymous #1> [in test() [in X [in Test.java [in <default> [in src [in P]]]]]]]", element);
            ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteFile("/P/src/Test.js");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteFile("/P/src/Test.js");
    }

    public void testPackage1() throws CoreException {
        ASTNode node = this.buildAST("public class X {\n  /*start*/java.lang/*end*/.String field;\n}");
        IBinding binding = ((QualifiedName)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "java.lang [in " + this.getExternalJCLPathString("1.5") + "]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testPackage2() throws CoreException {
        ASTNode node = this.buildAST("/*start*/public class X {\n}/*end*/");
        ITypeBinding typeBinding = ((TypeDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)typeBinding);
        IPackageBinding binding = typeBinding.getPackage();
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "<default> [in src [in P]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testParameterizedBinaryType() throws CoreException {
        ASTNode node = this.buildAST("public class X {\n  /*start*/Comparable<String>/*end*/ field;\n}");
        ITypeBinding binding = ((Type)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "Comparable [in Comparable.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testParameterizedBinaryMethod() throws CoreException {
        ASTNode node = this.buildAST("public class X extends p.Y<String> {\n  public X(String s) {\n    /*start*/super(s);/*end*/\n  }\n}");
        IFunctionBinding binding = ((SuperConstructorInvocation)node).resolveConstructorBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "Y(T) [in Y [in Y.class [in p [in lib.jar [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testRawBinaryType() throws CoreException {
        ASTNode node = this.buildAST("public class X {\n  /*start*/Comparable/*end*/ field;\n}");
        ITypeBinding binding = ((Type)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "Comparable [in Comparable.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testTopLevelType1() throws JavaScriptModelException {
        ASTNode node = this.buildAST("/*start*/public class X {\n}/*end*/");
        ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "X [in [Working copy] X.java [in <default> [in src [in P]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTopLevelType2() throws CoreException {
        try {
            this.createFile("/P/src/Y.js", "public class Y {\n}");
            ASTNode node = this.buildAST("public class X extends /*start*/Y/*end*/ {\n}");
            ITypeBinding binding = ((Type)node).resolveBinding();
            ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
            IJavaScriptElement element = binding.getJavaElement();
            this.assertElementEquals("Unexpected Java element", "Y [in Y.java [in <default> [in src [in P]]]]", element);
            ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteFile("/P/src/Y.js");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteFile("/P/src/Y.js");
    }

    public void testTopLevelType3() throws CoreException {
        ASTNode node = this.buildAST("public class X {\n  /*start*/String/*end*/ field;\n}");
        ITypeBinding binding = ((Type)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "String [in String.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testTypeParameter() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X</*start*/T/*end*/> {\n}");
        ITypeBinding binding = ((TypeParameter)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "<T> [in X [in [Working copy] X.java [in <default> [in src [in P]]]]]", element);
        ASTModelBridgeTests.assertTrue((String)"Element should exist", (boolean)element.exists());
    }

    public void testWildCard() throws JavaScriptModelException {
        ASTNode node = this.buildAST("public class X<T> {\n\tX</*start*/? extends Exception/*end*/> field;\n}");
        ITypeBinding binding = ((WildcardType)node).resolveBinding();
        ASTModelBridgeTests.assertNotNull((String)"No binding", (Object)binding);
        IJavaScriptElement element = binding.getJavaElement();
        this.assertElementEquals("Unexpected Java element", "<null>", element);
    }

    public void testCreateBindings19() throws CoreException {
        IBinding[] bindings = this.createBinaryBindings("public class A {\n  String foo(String s) {\n\t\treturn null;\n  }\n}", (IJavaScriptElement)this.getClassFile("/P/lib/A.class").getType().getFunction("foo", new String[]{"Ljava.lang.String;"}));
        ASTModelBridgeTests.assertNotNull((String)"No bindings", (Object)bindings);
        ASTModelBridgeTests.assertEquals((String)"Wrong size", (int)1, (int)bindings.length);
        ASTModelBridgeTests.assertTrue((String)"Not a method binding", (boolean)(bindings[0] instanceof IFunctionBinding));
        this.assertBindingsEqual("LA;.foo(Ljava/lang/String;)Ljava/lang/String;", bindings);
    }
}

