/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class ClassFileTests
extends ModifyingResourceTests {
    IPackageFragmentRoot jarRoot;
    IJavaScriptUnit workingCopy;
    IClassFile classFile;
    static /* synthetic */ Class class$0;

    public ClassFileTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.ClassFileTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ClassFileTests.buildModelTestSuite(clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        IJavaScriptProject javaProject = this.createJavaProject("P");
        String[] pathAndContents = new String[]{"nongeneric/A.js", "package nongeneric;\npublic class A {\n}", "generic/X.js", "package generic;\npublic class X<T> {\n  <U extends Exception> X<T> foo(X<T> x) throws RuntimeException, U {\n    return null;\n  }\n  <K, V> V foo(K key, V value) throws Exception {\n    return value;\n  }\n}", "generic/Y.js", "package generic;\npublic class Y<K, L> {\n}", "generic/Z.js", "package generic;\npublic class Z<T extends Object & I<? super T>> {\n}", "generic/I.js", "package generic;\npublic interface I<T> {\n}", "generic/W.js", "package generic;\npublic class W<T extends X<T> , U extends T> {\n}", "generic/V.js", "package generic;\npublic class V extends X<Thread> implements I<String> {\n}", "varargs/X.js", "package varargs;\npublic class X {\n  void foo(String s, Object ... others) {\n  }\n}", "workingcopy/X.js", "package workingcopy;\npublic class X {\n  void foo() {\n    System.out.println();\n  }\n}", "workingcopy/Y.js", "package workingcopy;\npublic class Y<W> {\n  <T> T foo(T t, String... args) {\n    return t;\n  }\n}"};
        this.addLibrary(javaProject, "lib.jar", "libsrc.zip", pathAndContents, "1.5");
        this.jarRoot = javaProject.getPackageFragmentRoot((IResource)this.getFile("/P/lib.jar"));
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
        this.deleteProject("P");
    }

    protected void tearDown() throws Exception {
        if (this.workingCopy != null) {
            this.workingCopy.discardWorkingCopy();
        }
        if (this.classFile != null) {
            this.removeLibrary(this.getJavaProject("P"), "lib2.jar", "src2.zip");
            this.classFile = null;
        }
        super.tearDown();
    }

    private IClassFile createClassFile(String contents) throws CoreException, IOException {
        IJavaScriptProject project = this.getJavaProject("P");
        this.addLibrary(project, "lib2.jar", "src2.zip", new String[]{"p/X.js", contents}, "1.5");
        this.classFile = project.getPackageFragmentRoot((IResource)this.getFile("/P/lib2.jar")).getPackageFragment("p").getClassFile("X.class");
        return this.classFile;
    }

    public void testDotName() throws JavaScriptModelException {
        IType type = this.getClassFile("/P/X.Y.class").getType();
        ClassFileTests.assertEquals((String)"X.Y", (String)type.getElementName());
    }

    public void testExceptionTypes1() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("generic").getClassFile("X.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"TK;", "TV;"});
        this.assertStringsEqual("Unexpected return type", "Ljava.lang.Exception;\n", method.getExceptionTypes());
    }

    public void testExceptionTypes2() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("generic").getClassFile("X.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"Lgeneric.X<TT;>;"});
        this.assertStringsEqual("Unexpected return type", "Ljava.lang.RuntimeException;\nTU;\n", method.getExceptionTypes());
    }

    public void testGetCategories01() throws CoreException, IOException {
        this.createClassFile("package p;\n/**\n * @category test\n */\npublic class X {\n}");
        String[] categories = this.classFile.getType().getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories02() throws CoreException, IOException {
        this.createClassFile("package p;\n/**\n * @category test1 test2 test3 test4 test5 test6 test7 test8 test9 test10\n */\npublic class X {\n}");
        String[] categories = this.classFile.getType().getCategories();
        this.assertStringsEqual("Unexpected categories", "test1\ntest2\ntest3\ntest4\ntest5\ntest6\ntest7\ntest8\ntest9\ntest10\n", categories);
    }

    public void testGetCategories03() throws CoreException, IOException {
        this.createClassFile("package p;\npublic class X {\n  /**\n   * @category test\n   */\n  int field;\n}");
        String[] categories = this.classFile.getType().getField("field").getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories04() throws CoreException, IOException {
        this.createClassFile("package p;\npublic class X {\n  /**\n   * @category test1 test2\n   */\n  int field;\n}");
        String[] categories = this.classFile.getType().getField("field").getCategories();
        this.assertStringsEqual("Unexpected categories", "test1\ntest2\n", categories);
    }

    public void testGetCategories05() throws CoreException, IOException {
        this.createClassFile("package p;\npublic class X {\n  /**\n * @category test\n   */\n  void foo() {}\n}");
        String[] categories = this.classFile.getType().getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories06() throws CoreException, IOException {
        this.createClassFile("package p;\npublic class X {\n  /**\n * @category test1 test2 test3 test4 test5\n   */\n  void foo() {}\n}");
        String[] categories = this.classFile.getType().getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "test1\ntest2\ntest3\ntest4\ntest5\n", categories);
    }

    public void testGetCategories07() throws CoreException, IOException {
        this.createClassFile("package p;\npublic class X {\n  /**\n   * @category \t *\t\ttest\n   */\n  void foo() {}\n}");
        String[] categories = this.classFile.getType().getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "", categories);
    }

    public void testGetCategories08() throws CoreException, IOException {
        this.createClassFile("package p;\npublic class X {\n  /**\n   * @category\t *\t\ttest\n   */\n  void foo() {}\n}");
        String[] categories = this.classFile.getType().getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "", categories);
    }

    public void testGetCategories09() throws CoreException, IOException {
        this.createClassFile("package p;\npublic class X {\n  /**\n   * @category test1\t *\t\ttest2\n   */\n  void foo() {}\n}");
        String[] categories = this.classFile.getType().getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "test1\n", categories);
    }

    public void testGetCategories10() throws CoreException, IOException {
        this.createClassFile("package p;\npublic class X {\n  int field1;\n  /**\n   * @category test\n   */\n  int field2;\n}");
        String[] categories = this.classFile.getType().getField("field1").getCategories();
        this.assertStringsEqual("Unexpected categories", "", categories);
    }

    public void testGetChildrenForCategory01() throws CoreException, IOException {
        this.createClassFile("package p;\npublic class X {\n  /**\n   * @category test\n   */\n  int field;\n  /**\n   * @category test\n   */\n  void foo1() {}\n  /**\n   * @category test\n   */\n  void foo2() {}\n  /**\n   * @category other\n   */\n  void foo3() {}\n}");
        IJavaScriptElement[] children = this.classFile.getType().getChildrenForCategory("test");
        this.assertElementsEqual("Unexpected children", "field [in X [in X.class [in p [in lib2.jar [in P]]]]]\nfoo1() [in X [in X.class [in p [in lib2.jar [in P]]]]]\nfoo2() [in X [in X.class [in p [in lib2.jar [in P]]]]]", children);
    }

    public void testGetChildrenForCategory02() throws CoreException, IOException {
        this.createClassFile("package p;\npublic class X {\n  /**\n   * @category fields test all\n   */\n  int field;\n  /**\n   * @category methods test all\n   */\n  void foo1() {}\n  /**\n   * @category methods test all\n   */\n  void foo2() {}\n  /**\n   * @category methods other all\n   */\n  void foo3() {}\n}");
        IJavaScriptElement[] tests = this.classFile.getType().getChildrenForCategory("test");
        this.assertElementsEqual("Unexpected children", "field [in X [in X.class [in p [in lib2.jar [in P]]]]]\nfoo1() [in X [in X.class [in p [in lib2.jar [in P]]]]]\nfoo2() [in X [in X.class [in p [in lib2.jar [in P]]]]]", tests);
        IJavaScriptElement[] methods = this.classFile.getType().getChildrenForCategory("methods");
        this.assertElementsEqual("Unexpected children", "foo1() [in X [in X.class [in p [in lib2.jar [in P]]]]]\nfoo2() [in X [in X.class [in p [in lib2.jar [in P]]]]]\nfoo3() [in X [in X.class [in p [in lib2.jar [in P]]]]]", methods);
        IJavaScriptElement[] others = this.classFile.getType().getChildrenForCategory("other");
        this.assertElementsEqual("Unexpected children", "foo3() [in X [in X.class [in p [in lib2.jar [in P]]]]]", others);
        IJavaScriptElement[] all = this.classFile.getType().getChildrenForCategory("all");
        this.assertElementsEqual("Unexpected children", "field [in X [in X.class [in p [in lib2.jar [in P]]]]]\nfoo1() [in X [in X.class [in p [in lib2.jar [in P]]]]]\nfoo2() [in X [in X.class [in p [in lib2.jar [in P]]]]]\nfoo3() [in X [in X.class [in p [in lib2.jar [in P]]]]]", all);
    }

    public void testGetSuperclassTypeSignature() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("generic").getClassFile("V.class").getType();
        ClassFileTests.assertEquals((String)"Unexpected signature", (String)"Lgeneric.X<Ljava.lang.Thread;>;", (String)type.getSuperclassTypeSignature());
    }

    public void testGetSuperInterfaceTypeSignatures() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("generic").getClassFile("V.class").getType();
        this.assertStringsEqual("Unexpected signatures", "Lgeneric.I<Ljava.lang.String;>;\n", type.getSuperInterfaceTypeSignatures());
    }

    public void testParameterNames01() throws CoreException {
        IFunction method = this.jarRoot.getPackageFragment("generic").getClassFile("X.class").getType().getFunction("foo", new String[]{"TK;", "TV;"});
        String[] parameterNames = method.getParameterNames();
        this.assertStringsEqual("Unexpected parameter names", "key\nvalue\n", parameterNames);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testParameterNames02() throws CoreException {
        IPath sourceAttachmentPath = this.jarRoot.getSourceAttachmentPath();
        try {
            this.attachSource(this.jarRoot, null, null);
            IFunction method = this.jarRoot.getPackageFragment("generic").getClassFile("X.class").getType().getFunction("foo", new String[]{"TK;", "TV;"});
            String[] parameterNames = method.getParameterNames();
            this.assertStringsEqual("Unexpected parameter names", "arg0\narg1\n", parameterNames);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.attachSource(this.jarRoot, sourceAttachmentPath.toString(), null);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.attachSource(this.jarRoot, sourceAttachmentPath.toString(), null);
    }

    public void testParameterTypeSignatures1() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("generic").getClassFile("X.class").getType();
        this.assertStringsEqual("Unexpected type parameters", "T:Ljava.lang.Object;\n", type.getTypeParameterSignatures());
    }

    public void testParameterTypeSignatures2() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("nongeneric").getClassFile("A.class").getType();
        this.assertStringsEqual("Unexpected type parameters", "", type.getTypeParameterSignatures());
    }

    public void testParameterTypeSignatures3() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("generic").getClassFile("Y.class").getType();
        this.assertStringsEqual("Unexpected type parameters", "K:Ljava.lang.Object;\nL:Ljava.lang.Object;\n", type.getTypeParameterSignatures());
    }

    public void testParameterTypeSignatures4() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("generic").getClassFile("Z.class").getType();
        this.assertStringsEqual("Unexpected type parameters", "T:Ljava.lang.Object;:Lgeneric.I<-TT;>;\n", type.getTypeParameterSignatures());
    }

    public void testParameterTypeSignatures5() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("generic").getClassFile("W.class").getType();
        this.assertStringsEqual("Unexpected type parameters", "T:Lgeneric.X<TT;>;\nU:TT;\n", type.getTypeParameterSignatures());
    }

    public void testRawParameterNames01() throws CoreException {
        IFunction method = this.jarRoot.getPackageFragment("generic").getClassFile("X.class").getType().getFunction("foo", new String[]{"TK;", "TV;"});
        String[] parameterNames = method.getRawParameterNames();
        this.assertStringsEqual("Unexpected parameter names", "arg0\narg1\n", parameterNames);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRawParameterNames02() throws CoreException {
        IPath sourceAttachmentPath = this.jarRoot.getSourceAttachmentPath();
        try {
            this.attachSource(this.jarRoot, null, null);
            IFunction method = this.jarRoot.getPackageFragment("generic").getClassFile("X.class").getType().getFunction("foo", new String[]{"TK;", "TV;"});
            String[] parameterNames = method.getParameterNames();
            this.assertStringsEqual("Unexpected parameter names", "arg0\narg1\n", parameterNames);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.attachSource(this.jarRoot, sourceAttachmentPath.toString(), null);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.attachSource(this.jarRoot, sourceAttachmentPath.toString(), null);
    }

    public void testReturnType1() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("generic").getClassFile("X.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"TK;", "TV;"});
        ClassFileTests.assertEquals((String)"Unexpected return type", (String)"TV;", (String)method.getReturnType());
    }

    public void testReturnType2() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("generic").getClassFile("X.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"Lgeneric.X<TT;>;"});
        ClassFileTests.assertEquals((String)"Unexpected return type", (String)"Lgeneric.X<TT;>;", (String)method.getReturnType());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSourceRangeNonJavaProject() throws CoreException {
        try {
            this.createProject("Simple");
            this.createFile("/Simple/X.class", "");
            IClassFile classX = this.getClassFile("/Simple/X.class");
            JavaScriptModelException exception = null;
            try {
                classX.getSourceRange();
            }
            catch (JavaScriptModelException e) {
                exception = e;
            }
            this.assertExceptionEquals("Unexpected exception", "Simple does not exist", exception);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("Simple");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("Simple");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSourceRangeNotOnClasspath() throws CoreException {
        try {
            this.createJavaProject("P2", new String[]{"src"}, "bin");
            this.createFile("/P2/bin/X.class", "");
            IClassFile classX = this.getClassFile("/P2/bin/X.class");
            ClassFileTests.assertNull((String)"Unxepected source range", (Object)classX.getSourceRange());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P2");
    }

    public void testTypeParameter() throws CoreException {
        IClassFile clazz = this.jarRoot.getPackageFragment("generic").getClassFile("X.class");
        ITypeParameter typeParameter = clazz.getType().getTypeParameter("T");
        clazz.close();
        this.assertStringsEqual("Unexpected bounds", "java.lang.Object\n", typeParameter.getBounds());
    }

    public void testVarargs() throws JavaScriptModelException {
        IType type = this.jarRoot.getPackageFragment("varargs").getClassFile("X.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"Ljava.lang.String;", "[Ljava.lang.Object;"});
        ClassFileTests.assertTrue((String)"Should have the AccVarargs flag set", (boolean)Flags.isVarargs((int)method.getFlags()));
    }

    public void testWorkingCopy01() throws CoreException {
        IClassFile clazz = this.jarRoot.getPackageFragment("workingcopy").getClassFile("X.class");
        this.workingCopy = clazz.becomeWorkingCopy(null, null, null);
        this.assertElementDescendants("Unexpected children", "[Working copy] X.class\n  package workingcopy\n  class X\n    void foo()", (IJavaScriptElement)this.workingCopy);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testWorkingCopy02() throws CoreException {
        IPath sourceAttachmentPath = this.jarRoot.getSourceAttachmentPath();
        try {
            this.attachSource(this.jarRoot, null, null);
            IClassFile clazz = this.jarRoot.getPackageFragment("workingcopy").getClassFile("X.class");
            ClassFileTests.assertNull((String)"Should not have source attached", (Object)clazz.getSource());
            this.workingCopy = clazz.becomeWorkingCopy(null, null, null);
            this.assertElementDescendants("Unexpected children", "[Working copy] X.class\n  package workingcopy\n  class X\n    X()\n    void foo()", (IJavaScriptElement)this.workingCopy);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.attachSource(this.jarRoot, sourceAttachmentPath.toString(), null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.attachSource(this.jarRoot, sourceAttachmentPath.toString(), null);
    }

    public void testWorkingCopy03() throws CoreException {
        IClassFile clazz = this.jarRoot.getPackageFragment("workingcopy").getClassFile("X.class");
        this.workingCopy = clazz.becomeWorkingCopy(null, null, null);
        this.workingCopy.getBuffer().setContents("package workingcopy;\npublic class X {\n  void bar() {\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertElementDescendants("Unexpected children", "[Working copy] X.class\n  package workingcopy\n  class X\n    void bar()", (IJavaScriptElement)this.workingCopy);
    }

    public void testWorkingCopy04() throws CoreException {
        IClassFile clazz = this.jarRoot.getPackageFragment("workingcopy").getClassFile("X.class");
        this.workingCopy = clazz.becomeWorkingCopy(null, null, null);
        this.workingCopy.getBuffer().setContents("package workingcopy;\npublic class X {\n  void bar() {\n  }\n}");
        JavaScriptModelException exception = null;
        try {
            this.workingCopy.commitWorkingCopy(false, null);
        }
        catch (JavaScriptModelException e) {
            exception = e;
        }
        ClassFileTests.assertEquals((String)"Unxepected JavaScriptModelException", (String)"Java Model Exception: Java Model Status [Operation not supported for specified element type(s):[Working copy] X.class [in workingcopy [in lib.jar [in P]]]]", (String)exception.toString());
    }

    public void testWorkingCopy05() throws CoreException {
        IClassFile clazz = this.jarRoot.getPackageFragment("workingcopy").getClassFile("X.class");
        this.workingCopy = clazz.becomeWorkingCopy(null, null, null);
        this.workingCopy.createType("class Y {\n}", null, false, null);
        this.assertElementDescendants("Unexpected children", "[Working copy] X.class\n  package workingcopy\n  class X\n    void foo()\n  class Y", (IJavaScriptElement)this.workingCopy);
    }

    public void testWorkingCopy06() throws CoreException {
        IClassFile clazz = this.jarRoot.getPackageFragment("workingcopy").getClassFile("X.class");
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopy = clazz.becomeWorkingCopy(null, owner, null);
        IJavaScriptUnit primary = this.workingCopy.getPrimary();
        ClassFileTests.assertEquals((String)"Unexpected owner of primary working copy", null, (Object)primary.getOwner());
    }

    public void testWorkingCopy07() throws CoreException {
        IClassFile clazz = this.jarRoot.getPackageFragment("workingcopy").getClassFile("X.class");
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopy = clazz.becomeWorkingCopy(null, owner, null);
        this.workingCopy.getBuffer().setContents("package workingcopy;\npublic class X {\n  void bar() {\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.workingCopy.restore();
        this.assertElementDescendants("Unexpected children", "[Working copy] X.class\n  package workingcopy\n  class X\n    void foo()", (IJavaScriptElement)this.workingCopy);
    }

    /*
     * Exception decompiling
     */
    public void testWorkingCopy08() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 179->183)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testWorkingCopy09() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 179->183)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testWorkingCopy10() throws CoreException {
        IPath sourceAttachmentPath = this.jarRoot.getSourceAttachmentPath();
        try {
            this.attachSource(this.jarRoot, null, null);
            IClassFile clazz = this.jarRoot.getPackageFragment("workingcopy").getClassFile("Y.class");
            ClassFileTests.assertNull((String)"Should not have source attached", (Object)clazz.getSource());
            this.workingCopy = clazz.becomeWorkingCopy(null, null, null);
            this.assertSourceEquals("Unexpected source", "package workingcopy;\npublic class Y<W> {\n  \n  public Y() {\n  }\n  \n  <T> T foo(T t, java.lang.String... args) {\n    return null;\n  }\n}", this.workingCopy.getSource());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.attachSource(this.jarRoot, sourceAttachmentPath.toString(), null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.attachSource(this.jarRoot, sourceAttachmentPath.toString(), null);
    }

    public void testWorkingCopy11() throws CoreException {
        IPackageFragment pkg = this.jarRoot.getPackageFragment("workingcopy");
        IClassFile clazz = pkg.getClassFile("X.class");
        this.workingCopy = clazz.becomeWorkingCopy(null, null, null);
        this.workingCopy.getBuffer().setContents("");
        this.workingCopy.makeConsistent(null);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{pkg});
        AbstractJavaSearchTests.JavaSearchResultCollector requestor = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.search("*", 0, 0, scope, (SearchRequestor)requestor);
        this.assertSearchResults("lib.jar workingcopy.Y", (Object)requestor);
    }
}

