/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.xml.core.internal.contenttype.ByteReader;

public class TestsPlugin
extends Plugin {
    private static TestsPlugin plugin;

    public TestsPlugin() {
        plugin = this;
    }

    public static TestsPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        return key;
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }

    public static URL getInstallLocation() {
        URL installLocation = Platform.getBundle((String)"org.eclipse.wst.xml.tests.encoding").getEntry("/");
        URL resolvedLocation = null;
        try {
            resolvedLocation = FileLocator.resolve((URL)installLocation);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return resolvedLocation;
    }

    public static File getTestFile(String filepath) {
        URL installURL = TestsPlugin.getInstallLocation();
        String path = installURL.getPath();
        String location = String.valueOf(path) + filepath;
        File result = new File(location);
        return result;
    }

    public static List getAllTestFiles(String topDirName) {
        List result = null;
        URL installURL = TestsPlugin.getInstallLocation();
        String path = installURL.getPath();
        String location = String.valueOf(path) + topDirName;
        File topDir = new File(location);
        if (!topDir.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(topDirName) + " is not a directory");
        }
        result = TestsPlugin.getFilesInDir(topDir);
        return result;
    }

    private static List getFilesInDir(File topDir) {
        ArrayList<File> files = new ArrayList<File>();
        File[] topFiles = topDir.listFiles();
        int i = 0;
        while (i < topFiles.length) {
            File file = topFiles[i];
            if (file.isFile()) {
                files.add(file);
            } else if (file.isDirectory() && !file.getName().endsWith("CVS")) {
                List innerFiles = TestsPlugin.getFilesInDir(file);
                files.addAll(innerFiles);
            }
            ++i;
        }
        return files;
    }

    public static Reader getTestReader(String filepath) throws FileNotFoundException {
        URL installURL = TestsPlugin.getInstallLocation();
        String path = installURL.getPath();
        String location = String.valueOf(path) + filepath;
        FileReader result = new FileReader(location);
        return result;
    }

    public static Reader getByteReader(String filepath) throws FileNotFoundException {
        URL installURL = TestsPlugin.getInstallLocation();
        String path = installURL.getPath();
        String location = String.valueOf(path) + filepath;
        ByteReader result = new ByteReader((InputStream)new BufferedInputStream(new FileInputStream(location)));
        return result;
    }
}

