/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser.tree;

import java.text.MessageFormat;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.base.ParseTreeAllocationInstantiationVisitor;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.tests.proxy.initParser.AbstractInitStringParserTestHelper;
import org.eclipse.jem.workbench.utility.ASTBoundResolver;
import org.eclipse.jem.workbench.utility.ParseTreeCreationFromAST;

public class ASTTreeInitStringParserTestHelper
extends AbstractInitStringParserTestHelper {
    private static final String TEMPLATE_CLASS = "public class TEMPLATE '{'\n  public void test() '{'\n    String.valueOf({0});\t// a line comment\n  }\n}";
    private static final String TEMPLATE_CLASS_IMPORTS = "{0}\npublic class TEMPLATE '{'\n  public void test() '{'\n    String.valueOf({1});\n  }\n}";
    private IJavaProject project;
    private ParseTreeCreationFromAST parser = new ParseTreeCreationFromAST((ParseTreeCreationFromAST.Resolver)new ASTBoundResolver());
    private ProxyFactoryRegistry registry;

    public ASTTreeInitStringParserTestHelper() {
    }

    public ASTTreeInitStringParserTestHelper(IProject project, ProxyFactoryRegistry registry) {
        this.project = JavaCore.create((IProject)project);
        this.registry = registry;
    }

    public ASTTreeInitStringParserTestHelper(IProject project) {
        this(project, null);
    }

    public ProxyFactoryRegistry getRegistry() {
        return this.registry;
    }

    public void testInitString(String aString, Object expectedResult, boolean throwsException, boolean equalsOnly) throws Throwable {
        String testClass = MessageFormat.format(TEMPLATE_CLASS, aString);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(testClass.toCharArray());
        parser.setUnitName("TEMPLATE.java");
        if (this.project != null) {
            parser.setProject(this.project);
            parser.setResolveBindings(true);
        }
        CompilationUnit cu = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
        IBeanProxy expectedProxy = null;
        if (expectedResult instanceof IBeanProxy) {
            expectedProxy = (IBeanProxy)expectedResult;
        } else if (expectedResult != null && !throwsException && this.registry != null) {
            expectedProxy = this.registry.getBeanProxyFactory().createBeanProxyFrom(aString);
        }
        this.testInitString(aString, cu, expectedProxy, throwsException, equalsOnly);
    }

    public void testInitString(String aString, String[] imports, IBeanProxy expectedResult) throws Throwable {
        this.testInitString(aString, imports, expectedResult, false, true);
    }

    public void testInitString(String aString, String[] imports, IBeanProxy expectedResult, boolean throwsException, boolean equalsOnly) throws Throwable {
        StringBuffer importLines = new StringBuffer(100);
        int i = 0;
        while (i < imports.length) {
            importLines.append("import ");
            importLines.append(imports[i]);
            importLines.append(";\n");
            ++i;
        }
        String testClass = MessageFormat.format(TEMPLATE_CLASS_IMPORTS, importLines, aString);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(testClass.toCharArray());
        parser.setUnitName("TEMPLATE.java");
        if (this.project != null) {
            parser.setProject(this.project);
            parser.setResolveBindings(true);
        }
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        this.testInitString(aString, cu, expectedResult, throwsException, equalsOnly);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void testInitString(String aString, CompilationUnit cu, IBeanProxy expectedResult, boolean throwsException, boolean equalsOnly) throws Throwable {
        IProblem[] problems = cu.getProblems();
        if (problems.length > 0) {
            boolean errors = false;
            StringBuffer buf = new StringBuffer(100);
            int i = 0;
            while (i < problems.length) {
                errors |= problems[i].isError();
                buf.append(" " + problems[i].getMessage());
                ++i;
            }
            if (errors) {
                if (throwsException) return;
                Assert.fail((String)("Problems with \"" + aString + "\": " + buf));
            } else {
                System.err.println("Warnings ocurred for \"" + aString + "\":" + buf);
            }
        }
        TypeDeclaration td = (TypeDeclaration)cu.types().get(0);
        ExpressionStatement es = (ExpressionStatement)td.getMethods()[0].getBody().statements().get(0);
        MethodInvocation mi = (MethodInvocation)es.getExpression();
        Expression exp = (Expression)mi.arguments().get(0);
        PTExpression parseExp = this.parser.createExpression(exp);
        if (this.registry == null) return;
        ParseTreeAllocationInstantiationVisitor v = new ParseTreeAllocationInstantiationVisitor();
        try {
            IBeanProxy bean = v.getBeanProxy(parseExp, this.registry);
            if (throwsException) {
                Assert.fail((String)("Should of thrown exception. Instead result was \"" + (bean != null ? bean.toBeanString() : null) + "\""));
            }
            if (bean == expectedResult) {
                return;
            }
            if (bean == null && expectedResult != null || expectedResult == null && bean != null) {
                Assert.fail((String)("ExpectedResult=" + (expectedResult != null ? expectedResult.toBeanString() : null) + " result=" + (bean != null ? bean.toBeanString() : null)));
            }
            if (bean.equals((Object)expectedResult)) {
                return;
            }
            if (bean.getTypeProxy() != expectedResult.getTypeProxy()) {
                Assert.fail((String)(String.valueOf(aString) + " ExpectedResult=" + expectedResult.toBeanString() + " ActualResult=" + bean.toBeanString() + " ExpectedClass=" + expectedResult.getTypeProxy().getFormalTypeName() + " ActualClass=" + bean.getTypeProxy().getFormalTypeName()));
                return;
            }
            if (bean.toBeanString().equals(expectedResult.toBeanString())) {
                return;
            }
            if (expectedResult.getTypeProxy().isArray() && bean.getTypeProxy().isArray()) {
                IBeanTypeProxy expectedResultClass = ((IArrayBeanTypeProxy)expectedResult.getTypeProxy()).getComponentType();
                IBeanTypeProxy resultClass = ((IArrayBeanTypeProxy)bean.getTypeProxy()).getComponentType();
                int resultLength = ((IArrayBeanProxy)bean).getLength();
                int expectedLength = ((IArrayBeanProxy)expectedResult).getLength();
                if (expectedLength != resultLength) {
                    Assert.fail((String)(String.valueOf(aString) + " ExpectedResult=" + expectedResult.toBeanString() + " ActualResult=" + bean.toBeanString() + " ExpectedClass=" + expectedResult.getTypeProxy().getFormalTypeName() + " ActualClass=" + bean.getTypeProxy().getFormalTypeName()));
                    return;
                }
                if (resultClass == expectedResultClass) {
                    return;
                }
                Assert.fail((String)(String.valueOf(aString) + " ExpectedResult=" + expectedResult.toBeanString() + " ActualResult=" + bean.toBeanString() + " ExpectedClass=" + expectedResult.getTypeProxy().getFormalTypeName() + " ActualClass=" + bean.getTypeProxy().getFormalTypeName()));
                return;
            }
            if (!equalsOnly) return;
            Assert.fail((String)(String.valueOf(aString) + " ExpectedResult=" + expectedResult.toBeanString() + " ActualResult=" + bean.toBeanString() + " ExpectedClass=" + expectedResult.getTypeProxy().getFormalTypeName() + " ActualClass=" + bean.getTypeProxy().getFormalTypeName()));
            return;
        }
        catch (Exception e) {
            if (!throwsException) throw e;
            return;
        }
    }
}

