/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.performance.internal.scalability;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.tests.performance.internal.scalability.ScalabilityTestCase;
import org.eclipse.wst.common.tests.performance.internal.util.EditorTestHelper;

public abstract class RepeatOpenEditorTestCase
extends ScalabilityTestCase {
    protected List files = new ArrayList();

    protected abstract int getRepeatCount();

    protected abstract String getEditorId();

    protected abstract String getBundleId();

    protected abstract String getFilePath();

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void execute() throws Exception {
        IProject project = this.createProject("sp");
        String bundleId = this.getBundleId();
        String filePath = this.getFilePath();
        int count = this.getRepeatCount();
        int i = 0;
        while (i < count) {
            this.files.add(this.copyFile(bundleId, filePath, (IContainer)project, String.valueOf(i)));
            ++i;
        }
        this.joinBackgroundJobs(3000);
        this.tagAsSummary(this.getClassName(), new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.USED_JAVA_HEAP});
        this.startMeasuring();
        String editorId = this.getEditorId();
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            this.openEditor(editorId, (IFile)it.next());
        }
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    protected void openEditor(String editorId, IFile file) throws PartInitException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart editor = workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorId, true);
        EditorTestHelper.runEventQueue((IWorkbenchPart)editor);
        workbenchWindow.getActivePage().closeEditor(editor, false);
        try {
            EditorTestHelper.joinBackgroundActivities();
        }
        catch (CoreException e) {
            RepeatOpenEditorTestCase.fail((String)e.getMessage());
        }
    }
}

