/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.model;

import org.eclipse.wst.css.core.internal.provisional.document.ICSSCharsetRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.tests.model.AbstractModelTest;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public class CSSCharsetRuleTest
extends AbstractModelTest {
    private final String RULE = "@charset \"iso-8859-1\";";

    public void testInsertRule() {
        ICSSStyleSheet sheet = this.getStyleSheet();
        CSSCharsetRuleTest.assertEquals((int)0, (int)sheet.insertRule("@charset \"iso-8859-1\";", 0));
        CSSRuleList ruleList = sheet.getCssRules();
        CSSRule rule = ruleList.item(0);
        CSSCharsetRuleTest.assertTrue((boolean)(rule instanceof CSSCharsetRule));
        CSSCharsetRule charsetRule = (CSSCharsetRule)rule;
        CSSCharsetRuleTest.assertEquals((String)"iso-8859-1", (String)charsetRule.getEncoding());
        CSSCharsetRuleTest.assertEquals((String)"@charset \"iso-8859-1\";", (String)charsetRule.getCssText());
    }

    public void testCreateRule() {
        ICSSStyleSheet sheet;
        ICSSStyleSheet doc = sheet = this.getStyleSheet();
        ICSSCharsetRule newRule = doc.createCSSCharsetRule();
        newRule.setEncoding("iso-8859-1");
        sheet.insertRuleBefore((CSSRule)newRule, null);
        CSSRuleList ruleList = sheet.getCssRules();
        CSSRule rule = ruleList.item(0);
        CSSCharsetRuleTest.assertTrue((boolean)(rule instanceof CSSCharsetRule));
        CSSCharsetRule charsetRule = (CSSCharsetRule)rule;
        CSSCharsetRuleTest.assertEquals((String)"iso-8859-1", (String)charsetRule.getEncoding());
        CSSCharsetRuleTest.assertEquals((String)"@charset \"iso-8859-1\";", (String)charsetRule.getCssText());
    }
}

