/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.jca.ConnectorResource;
import org.eclipse.jst.j2ee.jca.JcaPackage;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class RarEMFTest
extends GeneralEMFPopulationTest {
    EARFile earFile;
    protected RARFile rarFile;
    static /* synthetic */ Class class$0;

    public RarEMFTest(String name) {
        super(name);
    }

    public RarEMFTest(String name, RendererFactory factory) {
        super(name, factory);
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.RarEMFTest", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite(RendererFactory factory) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.emftests.RarEMFTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest((Test)new RarEMFTest("test14RARPopulation", factory));
        return suite;
    }

    public void testRARPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createRAR();
        ConnectorResource DD = (ConnectorResource)this.rarFile.getDeploymentDescriptorResource();
        DD.setVersionID(13);
        this.setVersion(1);
        this.setModuleType(2);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestRarEAR";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(curDir) + "EMFTestNoID/ra.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/TestRarEAR/fooRAR/META-INF/ra.xml";
        RarEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    public void test14RARPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createRAR();
        ConnectorResource DD = (ConnectorResource)this.rarFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(2);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/Test14RarEAR";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        this.getRar();
        RarEMFTest.assertTrue((boolean)"1.5".equals(this.rarFile.getDeploymentDescriptor().getSpecVersion()));
        out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/Test14RarEAR2";
        this.rarFile.extractTo(out, 126);
        this.rarFile.close();
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(curDir) + "testOutput/Test14RarEAR2/META-INF/ra.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/Test14RarEAR/fooRAR/META-INF/ra.xml";
        RarEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    public void getRar() throws DuplicateObjectException, OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/Test14RarEAR/fooRAR";
        this.rarFile = this.getArchiveFactory().openRARFile(in);
        RarEMFTest.assertTrue((this.rarFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void createRAR() throws DuplicateObjectException {
        this.rarFile = this.getArchiveFactory().createRARFileInitialized("fooRAR");
        this.rarFile = (RARFile)this.earFile.addCopy((ModuleFile)this.rarFile);
        this.rarFile.getDeploymentDescriptor().setDisplayName("fooRAR");
        RarEMFTest.assertTrue((this.rarFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void createEAR() {
        String earName = "Test.ear";
        this.earFile = this.getArchiveFactory().createEARFileInitialized(earName);
        RarEMFTest.assertTrue((this.earFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    protected Object createAttributeValue(EAttribute att, EObject eObject) {
        if (att == JcaPackage.eINSTANCE.getConfigProperty_Type()) {
            return "java.lang.String";
        }
        if (att == JcaPackage.eINSTANCE.getAuthenticationMechanism_CredentialInterface()) {
            return "javax.resource.spi.security.PasswordCredential";
        }
        if (att == JcaPackage.eINSTANCE.getConnector_SpecVersion() && this.version == 1) {
            return "1.0";
        }
        return super.createAttributeValue(att, eObject);
    }
}

