/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.tests;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.metadata.tests.AbstractBaseMetaDataTestCase;

public class MergeTests
extends AbstractBaseMetaDataTestCase {
    private boolean _debugInfo = false;

    public void testIncludeMerge() {
        this.showDebugInfo(this._debugInfo);
        String uri = "TinyIncludeTest";
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this.project, (String)uri);
        this.startTime(uri);
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)modelContext);
        this.endTime();
        MergeTests.assertNotNull((Object)model);
        this.dumpMDTree((Entity)model, 0);
        MergeTests.assertEquals((int)0, (int)model.getTraits().size());
        MergeTests.assertEquals((int)1, (int)model.getChildEntities().size());
        Entity A_Entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)model, (String)"A");
        MergeTests.assertEquals((int)2, (int)A_Entity.getTraits().size());
        Trait t = TaglibDomainMetaDataQueryHelper.getTrait((Entity)A_Entity, (String)"T1");
        MergeTests.assertNotNull((Object)t);
        MergeTests.assertEquals((String)"A1", (String)TraitValueHelper.getValueAsString((Trait)t));
        t = TaglibDomainMetaDataQueryHelper.getTrait((Entity)A_Entity, (String)"T2");
        MergeTests.assertNotNull((Object)t);
        MergeTests.assertEquals((String)"T2FromEG", (String)TraitValueHelper.getValueAsString((Trait)t));
        MergeTests.assertEquals((int)2, (int)A_Entity.getChildEntities().size());
        Entity a_Entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)A_Entity, (String)"a");
        MergeTests.assertNotNull((Object)a_Entity);
        MergeTests.assertEquals((int)1, (int)a_Entity.getTraits().size());
        MergeTests.assertEquals((int)2, (int)a_Entity.getChildEntities().size());
        Entity subA_Entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)A_Entity, (String)"sub-A");
        MergeTests.assertNotNull((Object)subA_Entity);
        Entity subSubA_Entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)subA_Entity, (String)"sub-sub-A");
        MergeTests.assertNotNull((Object)subSubA_Entity);
    }

    public void testMergeOfFileAandFileB() {
        this.showDebugInfo(this._debugInfo);
        String uri = "http://org.eclipse.jsf/mergetest1";
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this.project, (String)uri);
        this.startTime(uri);
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)modelContext);
        MergeTests.assertNotNull((Object)model);
        this.endTime();
        this.dumpMDTree((Entity)model, 0);
        MergeTests.assertEquals((int)3, (int)model.getTraits().size());
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"Dupe");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"dupe from A", (String)TraitValueHelper.getValueAsString((Trait)trait));
        MergeTests.assertEquals((int)5, (int)model.getChildEntities().size());
        Entity entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)model, (String)"A");
        MergeTests.assertNotNull((Object)entity);
        entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)model, (String)"B");
        MergeTests.assertNotNull((Object)entity);
        entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)model, (String)"Dupe");
        MergeTests.assertNotNull((Object)entity);
        MergeTests.assertEquals((int)2, (int)entity.getTraits().size());
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromA", (String)TraitValueHelper.getValueAsString((Trait)trait));
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"B1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((int)2, (int)entity.getChildEntities().size());
        Entity secondEntity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)entity, (String)"a");
        MergeTests.assertNotNull((Object)secondEntity);
        MergeTests.assertEquals((int)2, (int)secondEntity.getTraits().size());
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)secondEntity, (String)"A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromA", (String)TraitValueHelper.getValueAsString((Trait)trait));
        entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)model, (String)"DupeWithInclude");
        MergeTests.assertNotNull((Object)entity);
        MergeTests.assertEquals((int)2, (int)entity.getTraits().size());
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1", (String)TraitValueHelper.getValueAsString((Trait)trait));
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"B");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"trait SHOULD appear in merge from eg2", (String)TraitValueHelper.getValueAsString((Trait)trait));
        MergeTests.assertEquals((int)2, (int)entity.getChildEntities().size());
        secondEntity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)entity, (String)"a");
        MergeTests.assertNotNull((Object)secondEntity);
        MergeTests.assertEquals((int)2, (int)secondEntity.getTraits().size());
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1", (String)TraitValueHelper.getValueAsString((Trait)trait));
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"A1");
        MergeTests.assertNotNull((Object)trait);
        entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)model, (String)"DupeWithInclude2");
        MergeTests.assertNotNull((Object)entity);
        MergeTests.assertEquals((int)1, (int)entity.getTraits().size());
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromEG1", (String)TraitValueHelper.getValueAsString((Trait)trait));
        MergeTests.assertEquals((int)1, (int)entity.getChildEntities().size());
        secondEntity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)entity, (String)"a");
        MergeTests.assertNotNull((Object)secondEntity);
        MergeTests.assertEquals((int)2, (int)secondEntity.getTraits().size());
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromEG1", (String)TraitValueHelper.getValueAsString((Trait)trait));
    }

    public void testIncludeExternalModel() {
        this.showDebugInfo(this._debugInfo);
        String uri = "http://org.eclipse.jsf/mergetest2";
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this.project, (String)uri);
        this.startTime(uri);
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)modelContext);
        this.endTime();
        MergeTests.assertNotNull((Object)model);
        this.dumpMDTree((Entity)model, 0);
        MergeTests.assertEquals((int)1, (int)model.getTraits().size());
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"A1");
        MergeTests.assertNotNull((Object)trait);
        MergeTests.assertEquals((String)"A1FromEG1", (String)TraitValueHelper.getValueAsString((Trait)trait));
        MergeTests.assertEquals((int)1, (int)model.getChildEntities().size());
        Entity entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)model, (String)"a");
        MergeTests.assertNotNull((Object)entity);
        MergeTests.assertEquals((int)0, (int)entity.getChildEntities().size());
        MergeTests.assertEquals((int)2, (int)entity.getTraits().size());
    }

    public void testLoadJSFCore() {
        this.showDebugInfo(this._debugInfo);
        String uri = "http://java.sun.com/jsf/core";
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this.project, (String)uri);
        this.startTime(uri);
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)modelContext);
        this.endTime();
        MergeTests.assertNotNull((Object)model);
    }

    public void testLoadJSFHTML() {
        this.showDebugInfo(this._debugInfo);
        String uri = "http://java.sun.com/jsf/html";
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this.project, (String)uri);
        this.startTime(uri);
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)modelContext);
        this.endTime();
        MergeTests.assertNotNull((Object)model);
    }
}

