/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.filesystem;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.validation.sample.filesystem.FilesystemManager;
import org.eclipse.jst.validation.sample.filesystem.IFilesystemHelper;
import org.eclipse.jst.validation.sample.filesystem.MessageManager;
import org.eclipse.jst.validation.sample.filesystem.ValidatorMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class IncrementalReporter
implements IReporter {
    public void addMessage(IValidator validator, IMessage message) {
        if (validator == null) {
            return;
        }
        if (message == null) {
            return;
        }
        ValidatorMessages vm = MessageManager.getManager().getMessages(validator);
        if (vm != null) {
            vm.addValidationMessage(message);
        }
    }

    public void displaySubtask(IValidator validator, IMessage message) {
        System.err.println(message.getText());
    }

    public List getMessages() {
        return null;
    }

    public Map getMessages(int messageType) {
        return MessageManager.getManager().getMessages(messageType);
    }

    public boolean isCancelled() {
        return false;
    }

    public void removeAllMessages(IValidator validator) {
        if (validator == null) {
            return;
        }
        MessageManager.getManager().removeAllMessages(validator);
    }

    public void removeAllMessages(IValidator validator, Object object) {
        if (validator == null) {
            return;
        }
        MessageManager.getManager().removeAllMessages(validator, object);
    }

    public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
    }

    public void report() {
        System.out.println();
        System.out.println("Error messages");
        Map messages = this.getMessages(1);
        IncrementalReporter.report(messages);
        System.out.println();
        System.out.println("Warning messages");
        messages = this.getMessages(2);
        IncrementalReporter.report(messages);
        System.out.println();
        System.out.println("Information messages");
        messages = this.getMessages(4);
        IncrementalReporter.report(messages);
    }

    protected static void report(Map messages) {
        if (messages.size() == 0) {
            return;
        }
        Iterator iterator = messages.keySet().iterator();
        while (iterator.hasNext()) {
            String validatorClassName = (String)iterator.next();
            IValidator validator = FilesystemManager.getManager().getValidator(validatorClassName);
            IFilesystemHelper helper = FilesystemManager.getManager().getHelper(validator);
            List mssgList = (List)messages.get(validator);
            if (mssgList == null) continue;
            Collections.sort(mssgList, MessageManager.getManager().getMessageComparator(helper));
            int i = 0;
            while (i < mssgList.size()) {
                IMessage mssg = (IMessage)mssgList.get(i);
                System.out.println(MessageManager.formatMessage(validator, mssg));
                ++i;
            }
        }
    }
}

