/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.filesystemimpl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jst.validation.sample.filesystem.IFilesystemHelper;
import org.eclipse.jst.validation.sample.parser.APropertyFile;
import org.eclipse.jst.validation.sample.parser.PropertyLine;
import org.eclipse.wst.validation.internal.core.FileDelta;
import org.eclipse.wst.validation.internal.core.IFileDelta;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class FilesystemPropertiesHelper
implements IFilesystemHelper {
    public Object loadModel(String symbolicName) {
        return this.loadModel(symbolicName, null);
    }

    public Object loadModel(String symbolicName, Object[] parm) {
        if (symbolicName == null || symbolicName.equals("")) {
            return null;
        }
        if (symbolicName.equals("get a LineInputReader for a .properties file") && parm != null && parm.length == 1 && parm[0] instanceof String) {
            return this.loadLineNumberReader((String)parm[0]);
        }
        if (symbolicName.equals("relase (close) the LineInputReader") && parm != null && parm.length == 1 && parm[0] instanceof LineNumberReader) {
            return this.releaseLineNumberReader((LineNumberReader)parm[0]);
        }
        if (symbolicName.equals("return an IFileDelta[] of all of the .properties files in the project")) {
            return this.loadAllPropertiesFiles();
        }
        if (symbolicName.equals("get only the .properties files that are in src dir; filter out the .properties files that are in bin dir (i.e., don't validate the same file twice")) {
            return parm;
        }
        return null;
    }

    protected Object loadLineNumberReader(String fileName) {
        File propertyFile = new File(fileName);
        if (!propertyFile.exists() || !propertyFile.isFile()) {
            return null;
        }
        FileReader input = null;
        try {
            input = new FileReader(propertyFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        LineNumberReader lineInput = new LineNumberReader(input);
        return lineInput;
    }

    protected Object releaseLineNumberReader(LineNumberReader reader) {
        if (reader == null) {
            return null;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        return null;
    }

    protected Object loadAllPropertiesFiles() {
        String pwd = System.getProperty("user.dir");
        File pwdDir = new File(pwd);
        if (!pwdDir.exists()) {
            return null;
        }
        if (!pwdDir.isDirectory()) {
            return null;
        }
        HashSet tempSet = new HashSet();
        this.traverseDirectories(pwdDir, tempSet);
        IFileDelta[] result = new IFileDelta[tempSet.size()];
        Iterator iterator = tempSet.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            result[count++] = new FileDelta(file.getAbsolutePath(), 2);
        }
        tempSet.clear();
        tempSet = null;
        iterator = null;
        return result;
    }

    protected void traverseDirectories(File directoryToSearch, Set result) {
        String fileName;
        if (directoryToSearch == null) {
            return;
        }
        if (directoryToSearch.isDirectory()) {
            String[] children = directoryToSearch.list();
            int i = 0;
            while (i < children.length) {
                File child = new File(directoryToSearch, children[i]);
                this.traverseDirectories(child, result);
                ++i;
            }
        } else if (directoryToSearch.isFile() && (fileName = directoryToSearch.getName()) != null && fileName.endsWith("properties")) {
            result.add(directoryToSearch);
        }
    }

    public String getFileName(IMessage message) {
        Object object = message.getTargetObject();
        if (object instanceof PropertyLine) {
            PropertyLine line = (PropertyLine)object;
            APropertyFile pFile = line.getFile();
            return pFile.getQualifiedFileName();
        }
        if (object instanceof APropertyFile) {
            APropertyFile pFile = (APropertyFile)object;
            return pFile.getQualifiedFileName();
        }
        return "";
    }

    public String[] getURIs() {
        return null;
    }
}

