package oracle.adfdemo.view.faces.email;

import javax.faces.component.UIComponent;
import javax.faces.convert.Converter;
import javax.faces.context.FacesContext;

/**
 * Converter that displays just the name, or the full
 * e-mail address if the name is not available.
 */
public class EmailDisplayConverter implements Converter
{
  public EmailDisplayConverter()
  {
  }

  public String getAsString(FacesContext context, UIComponent component,
                            Object value)
  {
    if (value == null)
      return null;

    String val = value.toString();
    int lessThanIndex = val.indexOf('<');
    if (lessThanIndex < 0)
      return val;

    return val.substring(0, lessThanIndex).trim();
  }

  public Object getAsObject(FacesContext context, UIComponent component,
                            String value)
  {
    throw new UnsupportedOperationException();
  }
}
