/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EnumType;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.LobAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaBasicMapping
extends AbstractJavaAttributeMapping<BasicAnnotation>
implements JavaBasicMapping {
    protected FetchType specifiedFetch;
    protected Boolean specifiedOptional;
    protected EnumType specifiedEnumerated;
    protected final JavaColumn column = this.createJavaColumn();
    protected boolean lob;
    protected TemporalType temporal;

    public GenericJavaBasicMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected JavaColumn createJavaColumn() {
        return this.getJpaFactory().buildJavaColumn(this, this);
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.initializeFromResource(resourcePersistentAttribute);
        this.column.initializeFromResource(this.getColumnResource());
        this.specifiedEnumerated = this.specifiedEnumerated(this.getEnumeratedResource());
        this.lob = this.lob(resourcePersistentAttribute);
        this.temporal = this.temporal(this.getTemporalResource());
    }

    @Override
    protected void initialize(BasicAnnotation basicResource) {
        this.specifiedFetch = this.specifiedFetchType(basicResource);
        this.specifiedOptional = this.specifiedOptional(basicResource);
    }

    protected EnumeratedAnnotation getEnumeratedResource() {
        return (EnumeratedAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Enumerated");
    }

    protected TemporalAnnotation getTemporalResource() {
        return (TemporalAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Temporal");
    }

    @Override
    public ColumnAnnotation getColumnResource() {
        return (ColumnAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Column");
    }

    @Override
    public String getKey() {
        return "basic";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Basic";
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.Column", "javax.persistence.Lob", "javax.persistence.Temporal", "javax.persistence.Enumerated"});
    }

    @Override
    public String getDefaultColumnName() {
        return this.getAttributeName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getTableName();
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    @Override
    public FetchType getFetch() {
        return this.getSpecifiedFetch() == null ? this.getDefaultFetch() : this.getSpecifiedFetch();
    }

    @Override
    public FetchType getDefaultFetch() {
        return BasicMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        ((BasicAnnotation)this.getMappingResource()).setFetch(FetchType.toJavaResourceModel(newSpecifiedFetch));
        this.firePropertyChanged("specifiedFetchProperty", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected void setSpecifiedFetch_(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        this.firePropertyChanged("specifiedFetchProperty", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    @Override
    public Boolean getOptional() {
        return this.getSpecifiedOptional() == null ? this.getDefaultOptional() : this.getSpecifiedOptional();
    }

    @Override
    public Boolean getDefaultOptional() {
        return Nullable.DEFAULT_OPTIONAL;
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        ((BasicAnnotation)this.getMappingResource()).setOptional(newSpecifiedOptional);
        this.firePropertyChanged("specifiedOptionalProperty", oldOptional, newSpecifiedOptional);
    }

    protected void setSpecifiedOptional_(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        this.firePropertyChanged("specifiedOptionalProperty", oldOptional, newSpecifiedOptional);
    }

    @Override
    public boolean isLob() {
        return this.lob;
    }

    @Override
    public void setLob(boolean newLob) {
        boolean oldLob = this.lob;
        this.lob = newLob;
        if (newLob) {
            if (this.lobResource(this.getResourcePersistentAttribute()) == null) {
                this.getResourcePersistentAttribute().addAnnotation("javax.persistence.Lob");
            }
        } else if (this.lobResource(this.getResourcePersistentAttribute()) != null) {
            this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.Lob");
        }
        this.firePropertyChanged("lobProperty", oldLob, newLob);
    }

    @Override
    public TemporalType getTemporal() {
        return this.temporal;
    }

    @Override
    public void setTemporal(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        this.getTemporalResource().setValue(TemporalType.toJavaResourceModel(newTemporal));
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    protected void setTemporal_(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    @Override
    public EnumType getEnumerated() {
        return this.getSpecifiedEnumerated() == null ? this.getDefaultEnumerated() : this.getSpecifiedEnumerated();
    }

    @Override
    public EnumType getDefaultEnumerated() {
        return BasicMapping.DEFAULT_ENUMERATED;
    }

    @Override
    public EnumType getSpecifiedEnumerated() {
        return this.specifiedEnumerated;
    }

    @Override
    public void setSpecifiedEnumerated(EnumType newSpecifiedEnumerated) {
        EnumType oldEnumerated = this.specifiedEnumerated;
        this.specifiedEnumerated = newSpecifiedEnumerated;
        this.getEnumeratedResource().setValue(EnumType.toJavaResourceModel(newSpecifiedEnumerated));
        this.firePropertyChanged("specifiedEnumeratedProperty", (Object)oldEnumerated, (Object)newSpecifiedEnumerated);
    }

    protected void setSpecifiedEnumerated_(EnumType newSpecifiedEnumerated) {
        EnumType oldEnumerated = this.specifiedEnumerated;
        this.specifiedEnumerated = newSpecifiedEnumerated;
        this.firePropertyChanged("specifiedEnumeratedProperty", (Object)oldEnumerated, (Object)newSpecifiedEnumerated);
    }

    @Override
    public void update(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.update(resourcePersistentAttribute);
        this.column.update(this.getColumnResource());
        this.setSpecifiedEnumerated_(this.specifiedEnumerated(this.getEnumeratedResource()));
        this.setLob(this.lob(resourcePersistentAttribute));
        this.setTemporal_(this.temporal(this.getTemporalResource()));
    }

    @Override
    protected void update(BasicAnnotation basicResource) {
        this.setSpecifiedFetch_(this.specifiedFetchType(basicResource));
        this.setSpecifiedOptional_(this.specifiedOptional(basicResource));
    }

    protected FetchType specifiedFetchType(BasicAnnotation basic) {
        return FetchType.fromJavaResourceModel(basic.getFetch());
    }

    protected Boolean specifiedOptional(BasicAnnotation basic) {
        return basic.getOptional();
    }

    protected EnumType specifiedEnumerated(EnumeratedAnnotation enumerated) {
        return EnumType.fromJavaResourceModel(enumerated.getValue());
    }

    protected boolean lob(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        return this.lobResource(resourcePersistentAttribute) != null;
    }

    protected LobAnnotation lobResource(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        return (LobAnnotation)resourcePersistentAttribute.getAnnotation("javax.persistence.Lob");
    }

    protected TemporalType temporal(TemporalAnnotation temporal) {
        return TemporalType.fromJavaResourceModel(temporal.getValue());
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        this.addColumnMessages(messages, astRoot);
    }

    protected void addColumnMessages(List<IMessage> messages, CompilationUnit astRoot) {
        boolean doContinue;
        JavaColumn column = this.getColumn();
        String table = column.getTable();
        boolean bl = doContinue = this.entityOwned() && column.connectionProfileIsActive();
        if (doContinue && this.getTypeMapping().tableNameIsInvalid(table)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.getTableTextRange(astRoot)));
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.getNameTextRange(astRoot)));
        }
    }
}

