/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.tests;

import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.servertype.definition.Classpath;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public final class ServerRuntimeUtils
extends Assert {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private ServerRuntimeUtils() {
    }

    public static GenericServer getGenericServer(String serverTypeId, IRuntime runtime) throws Exception {
        GenericServer serverDelegate = null;
        IServerType[] sTypes = ServerCore.getServerTypes();
        int i = 0;
        while (i < sTypes.length) {
            IServerType serverType = sTypes[i];
            if (serverTypeId.equals(serverType.getId())) {
                IServerWorkingCopy serverWorkingCopy = serverType.createServer(serverTypeId, null, runtime, null);
                ServerRuntimeUtils.assertNotNull((String)"Could not create server", (Object)serverWorkingCopy);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                serverDelegate = (GenericServer)serverWorkingCopy.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
        return serverDelegate;
    }

    public static GenericServerRuntime getGenericServerRuntime(String runtimeTypeId) throws CoreException {
        GenericServerRuntime runtimeDelegate = null;
        IRuntimeType[] runtimesTypes = ServerCore.getRuntimeTypes();
        int i = 0;
        while (i < runtimesTypes.length) {
            IRuntimeType runtimeType = runtimesTypes[i];
            if (runtimeType.getId().equals(runtimeTypeId)) {
                IRuntimeWorkingCopy runtimeWorkingCopy = runtimeType.createRuntime(runtimeTypeId, null);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServerRuntime");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                runtimeDelegate = (GenericServerRuntime)runtimeWorkingCopy.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            ++i;
        }
        return runtimeDelegate;
    }

    public static void verifyProperty(List property, String id, String value) {
        boolean found = false;
        int count = 0;
        Iterator iter = property.iterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!prop.getId().equals(id)) continue;
            ServerRuntimeUtils.assertEquals((String)"Property value does not match", (String)value, (String)prop.getDefault());
            found = true;
            ++count;
        }
        ServerRuntimeUtils.assertTrue((String)"Property not found", (boolean)found);
        ServerRuntimeUtils.assertEquals((String)"More than one property found", (int)1, (int)count);
    }

    public static void verifyNoProperty(List property, String id) {
        boolean found = false;
        Iterator iter = property.iterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!prop.getId().equals(id)) continue;
            found = true;
            break;
        }
        ServerRuntimeUtils.assertFalse((String)"Property found when there should be none", (boolean)found);
    }

    public static void verifyClasspath(List classpaths, String id) {
        boolean found = false;
        int count = 0;
        Iterator iter = classpaths.iterator();
        while (iter.hasNext()) {
            Classpath cp = (Classpath)iter.next();
            if (!cp.getId().equals(id)) continue;
            found = true;
            ++count;
        }
        ServerRuntimeUtils.assertTrue((String)"Classpath not found", (boolean)found);
        ServerRuntimeUtils.assertEquals((String)"More than one classpath found", (int)1, (int)count);
    }
}

