/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.eclipse.jem.tests.proxy.initParser.AbstractInitParserTestCase;

public class JFCTest
extends AbstractInitParserTestCase {
    public JFCTest(String name) {
        super(name);
    }

    public void testDimension() throws Throwable {
        this.testHelper.testInitString("new java.awt.Dimension(1,1)", new Dimension(1, 1));
    }

    public void testDimensionNeg() throws Throwable {
        this.testHelper.testInitString("new java.awt.Dimension(-1,-1)", new Dimension(-1, -1));
    }

    public void testColorConstant() throws Throwable {
        this.testHelper.testInitString("java.awt.Color.cyan", Color.cyan);
    }

    public void testColorString() throws Throwable {
        this.testHelper.testInitString("java.awt.Color.cyan.toString()", Color.cyan.toString());
    }

    public void testColorRGB() throws Throwable {
        this.testHelper.testInitString("new java.awt.Color(10,20,30)", new Color(10, 20, 30));
    }

    public void testInteger() throws Throwable {
        this.testHelper.testInitString("new Integer(50)", new Integer(50));
    }

    public void testIntegerNegative() throws Throwable {
        this.testHelper.testInitString("new java.lang.Integer(-50)", new Integer(-50));
    }

    public void testShort() throws Throwable {
        this.testHelper.testInitString("new Short((short)50)", new Short(50));
    }

    public void testShortNegative() throws Throwable {
        this.testHelper.testInitString("new Short((short)-50)", new Short(-50));
    }

    public void testLong() throws Throwable {
        this.testHelper.testInitString("new Long(50L)", new Long(50L));
    }

    public void testLongNegative() throws Throwable {
        this.testHelper.testInitString("new java.lang.Long(-50L)", new Long(-50L));
    }

    public void testByte() throws Throwable {
        this.testHelper.testInitString("new Byte((byte)10)", new Byte(10));
    }

    public void testByteNegative() throws Throwable {
        this.testHelper.testInitString("new Byte((byte)-10)", new Byte(-10));
    }

    public void testFloat() throws Throwable {
        this.testHelper.testInitString("new java.lang.Float(10.3F)", new Float(10.3f));
    }

    public void testDouble() throws Throwable {
        this.testHelper.testInitString("new java.lang.Double(10.3D)", new Double(10.3));
    }

    public void testIntegerString() throws NumberFormatException, Throwable {
        this.testHelper.testInitString("new Integer(\"50\")", new Integer("50"));
    }

    public void testFlowLayout() throws Throwable {
        this.testHelper.testInitString("new java.awt.FlowLayout()", new FlowLayout());
    }

    public void testImageIcon() throws Throwable {
        this.testHelper.testInitString("new javax.swing.ImageIcon( \"C:/WINNT/Zapotec.bmp\")", new ImageIcon("C:/WINNT/Zapotec.bmp"));
    }

    public void testRectangle() throws Throwable {
        this.testHelper.testInitString("new java.awt.Rectangle( 10 , 20 , 30 , 40 )", new Rectangle(10, 20, 30, 40));
    }

    public void testLocale() throws Throwable {
        this.testHelper.testInitString("new java.util.Locale(\"fr\",\"FR\")", new Locale("fr", "FR"));
    }

    public void testLocaleVariant() throws Throwable {
        this.testHelper.testInitString("new java.util.Locale(\"fr\",\"FR\",\"\")", new Locale("fr", "FR", ""));
    }

    public void testLocaleException() throws Throwable {
        this.testHelper.testInitString("new java.util.Locale(\"fr\",\"FR\",null)", null, true, true);
    }

    public void testDialog() throws Throwable {
        this.testHelper.testInitString("new java.awt.Dialog(new java.awt.Frame())", false, new Dialog(new Frame()));
    }

    public void testLength() throws Throwable {
        this.testHelper.testInitString("new Integer( 50 ).toString().length()", new Integer(new Integer(50).toString().length()));
    }

    public void testSize() throws Throwable {
        this.testHelper.testInitString("new java.util.ArrayList().size()", new Integer(new ArrayList().size()));
    }

    public void testCursor() throws Throwable {
        this.testHelper.testInitString("new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR)", new Cursor(12));
    }

    public void testPanel() throws Throwable {
        this.testHelper.testInitString("new java.awt.Panel(null)", false, new Panel(null));
    }

    public void testComplexFont() throws Throwable {
        this.testHelper.testInitString("new java.awt.Font(\"Dialog\", java.awt.Font.BOLD | java.awt.Font.ITALIC, 12)", new Font("Dialog", 3, 12));
    }

    public void testKeyStroke() throws Throwable {
        this.testHelper.testInitString("javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_H, java.awt.Event.ALT_MASK | java.awt.Event.CTRL_MASK | java.awt.Event.SHIFT_MASK, true)", KeyStroke.getKeyStroke(72, 11, true));
    }
}

