/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.remote;

import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.tests.proxy.AbstractTestProxy;

public class TestProjectAccess
extends AbstractTestProxy {
    public TestProjectAccess() {
    }

    public TestProjectAccess(String name) {
        super(name);
    }

    public void testClassFromProject() {
        IBeanTypeProxy testClassType = this.proxyTypeFactory.getBeanTypeProxy("org.eclipse.jem.testing.proxy.remote.TestClass");
        TestProjectAccess.assertNotNull((Object)testClassType);
    }

    public void testProjectClassInstantiation() throws ThrowableProxy {
        IBeanTypeProxy testClassType = this.proxyTypeFactory.getBeanTypeProxy("org.eclipse.jem.testing.proxy.remote.TestClass");
        IBeanProxy testClass = testClassType.newInstance();
        TestProjectAccess.assertNotNull((Object)testClass);
    }

    public void testProjectClassMethod() throws ThrowableProxy {
        IBeanTypeProxy testClassType = this.proxyTypeFactory.getBeanTypeProxy("org.eclipse.jem.testing.proxy.remote.TestClass");
        IMethodProxy testMethod = testClassType.getMethodProxy("getTestString");
        TestProjectAccess.assertNotNull((Object)testMethod);
    }

    public void testProjectClassMethodInvoke() throws ThrowableProxy {
        IBeanTypeProxy testClassType = this.proxyTypeFactory.getBeanTypeProxy("org.eclipse.jem.testing.proxy.remote.TestClass");
        IMethodProxy testMethod = testClassType.getMethodProxy("getTestString");
        IBeanProxy testClass = testClassType.newInstance();
        IStringBeanProxy aString = (IStringBeanProxy)testMethod.invoke(testClass);
        TestProjectAccess.assertNotNull((Object)aString);
        TestProjectAccess.assertEquals((String)"TESTSTRING", (String)aString.stringValue());
    }
}

