/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistry;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistryImpl;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;

public class AdapterFactoryRegistryTest
extends TestCase {
    private final String CLASSNAME_HTML_FACTORY = "org.eclipse.wst.html.ui.internal.registry.AdapterFactoryProviderForHTML";
    private final String CLASSNAME_DTD_FACTORY = "org.eclipse.wst.dtd.ui.internal.registry.AdapterFactoryProviderForDTD";
    private final String CLASSNAME_JSP_FACTORY = "org.eclipse.jst.jsp.ui.internal.registry.AdapterFactoryProviderForJSP";
    private final String CLASSNAME_CSS_FACTORY = "org.eclipse.wst.css.ui.internal.registry.AdapterFactoryProviderCSS";
    private final String CLASSNAME_XML_FACTORY = "org.eclipse.wst.xml.ui.internal.registry.AdapterFactoryProviderForXML";

    public void testCreate() {
        AdapterFactoryRegistry instance = AdapterFactoryRegistryImpl.getInstance();
        AdapterFactoryRegistryTest.assertNotNull((Object)instance);
    }

    public void testGetAllFactories() {
        AdapterFactoryRegistry instance = AdapterFactoryRegistryImpl.getInstance();
        Iterator it = instance.getAdapterFactories();
        Object provider = null;
        ArrayList<String> known = new ArrayList<String>();
        known.add("org.eclipse.wst.html.ui.internal.registry.AdapterFactoryProviderForHTML");
        known.add("org.eclipse.wst.dtd.ui.internal.registry.AdapterFactoryProviderForDTD");
        known.add("org.eclipse.jst.jsp.ui.internal.registry.AdapterFactoryProviderForJSP");
        known.add("org.eclipse.wst.css.ui.internal.registry.AdapterFactoryProviderCSS");
        known.add("org.eclipse.wst.xml.ui.internal.registry.AdapterFactoryProviderForXML");
        while (it.hasNext()) {
            provider = it.next();
            known.remove(provider.getClass().getName());
        }
        AdapterFactoryRegistryTest.assertEquals((String)"unknown (extra) adapter factories found", (int)0, (int)known.size());
    }

    public void testGetFactoriesXML() {
        ArrayList<String> known = new ArrayList<String>();
        known.add("org.eclipse.wst.xml.ui.internal.registry.AdapterFactoryProviderForXML");
        this.getFactoriesForContentType(known, ContentTypeIdForXML.ContentTypeID_XML, "org.eclipse.wst.html.ui.internal.registry.AdapterFactoryProviderForHTML");
    }

    public void testGetFactoriesHTML() {
        ArrayList<String> known = new ArrayList<String>();
        known.add("org.eclipse.jst.jsp.ui.internal.registry.AdapterFactoryProviderForJSP");
        this.getFactoriesForContentType(known, ContentTypeIdForJSP.ContentTypeID_JSP, "org.eclipse.wst.xml.ui.internal.registry.AdapterFactoryProviderForXML");
    }

    public void testGetFactoriesJSP() {
        ArrayList<String> known = new ArrayList<String>();
        known.add("org.eclipse.wst.html.ui.internal.registry.AdapterFactoryProviderForHTML");
        this.getFactoriesForContentType(known, ContentTypeIdForHTML.ContentTypeID_HTML, "org.eclipse.wst.dtd.ui.internal.registry.AdapterFactoryProviderForDTD");
    }

    public void testGetFactoriesDTD() {
        ArrayList<String> known = new ArrayList<String>();
        known.add("org.eclipse.wst.dtd.ui.internal.registry.AdapterFactoryProviderForDTD");
        this.getFactoriesForContentType(known, "org.eclipse.wst.dtd.core.dtdsource", "org.eclipse.wst.html.ui.internal.registry.AdapterFactoryProviderForHTML");
    }

    public void testGetFactoriesCSS() {
        ArrayList<String> known = new ArrayList<String>();
        known.add("org.eclipse.wst.css.ui.internal.registry.AdapterFactoryProviderCSS");
        this.getFactoriesForContentType(known, ContentTypeIdForCSS.ContentTypeID_CSS, "org.eclipse.jst.jsp.ui.internal.registry.AdapterFactoryProviderForJSP");
    }

    private void getFactoriesForContentType(List expected, String contentTypeId, String notExpectedClassname) {
        AdapterFactoryRegistryImpl instance = (AdapterFactoryRegistryImpl)AdapterFactoryRegistryImpl.getInstance();
        Iterator it = instance.getAdapterFactories(contentTypeId);
        Object provider = null;
        while (it.hasNext()) {
            provider = it.next();
            expected.remove(provider.getClass().getName());
            AdapterFactoryRegistryTest.assertTrue((String)("!provider: " + notExpectedClassname + " shouldn't be in the list!"), (!notExpectedClassname.equals(provider.getClass().getName()) ? 1 : 0) != 0);
        }
        AdapterFactoryRegistryTest.assertTrue((String)("extra providers (expected none): " + expected), (boolean)expected.isEmpty());
    }
}

