/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.validation;

import junit.framework.TestCase;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jst.jsp.ui.internal.validation.JSPMarkupValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.ui.internal.validation.MarkupValidator;

public class TestJSPMarkupValidator
extends TestCase {
    private MarkupValidator fValidator;
    private IReporter fReporter;
    private IStructuredDocument fDocument;

    private boolean validateError(String contents) {
        this.fDocument.set(contents);
        this.fValidator.validate((IRegion)new Region(0, this.fDocument.getLength()), null, this.fReporter);
        return this.fReporter.getMessages().isEmpty();
    }

    protected void setUp() throws Exception {
        if (this.fValidator == null) {
            this.fValidator = new JSPMarkupValidator();
        }
        if (this.fReporter == null) {
            this.fReporter = new IncrementalReporter(null);
        }
        if (this.fDocument == null) {
            this.fDocument = StructuredModelManager.getModelManager().createStructuredDocumentFor("onfire.xml", "", null);
        }
        this.fValidator.connect((IDocument)this.fDocument);
    }

    protected void tearDown() throws Exception {
        this.fValidator.disconnect((IDocument)this.fDocument);
    }

    public void testAttributesInEndTag() {
        TestJSPMarkupValidator.assertTrue((String)"Should get attributes in end tag error", (!this.validateError("<stop></stop drop=\"roll\">") ? 1 : 0) != 0);
        TestJSPMarkupValidator.assertTrue((String)"Should not get attributes in end tag error", (boolean)this.validateError("<stop></stop>"));
    }

    public void testClosingBracket() {
        TestJSPMarkupValidator.assertTrue((String)"Should get closing bracket error", (!this.validateError("<stop </stop>") ? 1 : 0) != 0);
        TestJSPMarkupValidator.assertTrue((String)"Should not get closing bracket error", (boolean)this.validateError("<stop></stop>"));
    }

    public void testEmptyTag() {
        TestJSPMarkupValidator.assertTrue((String)"Should get empty tag error", (!this.validateError("<>") ? 1 : 0) != 0);
        TestJSPMarkupValidator.assertTrue((String)"Should not get empty tag error", (boolean)this.validateError("<stop></stop>"));
    }

    public void testAttributeValue() {
        TestJSPMarkupValidator.assertTrue((String)"Should get attribute missing value error", (!this.validateError("<stop drop=></stop>") ? 1 : 0) != 0);
        TestJSPMarkupValidator.assertTrue((String)"Should not get attribute has no value error", (boolean)this.validateError("<stop drop></stop>"));
        TestJSPMarkupValidator.assertTrue((String)"Should not get attribute missing value error", (boolean)this.validateError("<stop drop=\"roll\"></stop>"));
    }

    public void testSpaceBeforeName() {
        TestJSPMarkupValidator.assertTrue((String)"Should get tag has space before name error", (!this.validateError("<    stop></stop>") ? 1 : 0) != 0);
        TestJSPMarkupValidator.assertTrue((String)"Should not get tag has space before name error", (boolean)this.validateError("<stop></stop>"));
    }

    public void testQuotesForAttributeValues() {
        TestJSPMarkupValidator.assertTrue((String)"Should get missing end quote error", (!this.validateError("<stop drop=\"></stop>") ? 1 : 0) != 0);
        TestJSPMarkupValidator.assertTrue((String)"Should get missing end quote error", (!this.validateError("<stop drop=\"roll></stop>") ? 1 : 0) != 0);
        TestJSPMarkupValidator.assertTrue((String)"Should get missing end quote error", (!this.validateError("<stop drop='></stop>") ? 1 : 0) != 0);
        TestJSPMarkupValidator.assertTrue((String)"Should not get missing quotes error", (boolean)this.validateError("<stop drop=roll></stop>"));
        TestJSPMarkupValidator.assertTrue((String)"Should not get missing end quote error", (boolean)this.validateError("<stop drop=\"\"></stop>"));
        TestJSPMarkupValidator.assertTrue((String)"Should not get missing end quote error", (boolean)this.validateError("<stop drop=\"roll\"></stop>"));
        TestJSPMarkupValidator.assertTrue((String)"Should not get missing end quote error", (boolean)this.validateError("<stop drop=''></stop>"));
        TestJSPMarkupValidator.assertTrue((String)"Should not get missing quotes error", (boolean)this.validateError("<stop drop='roll'></stop>"));
    }
}

