/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tests.tabbed.properties.sections;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.properties.IPropertyPageDescriptor;
import org.eclipse.jst.pagedesigner.properties.internal.AttributeGroupSection;
import org.eclipse.jst.pagedesigner.properties.internal.NullQuickEditTabSection;
import org.eclipse.jst.pagedesigner.properties.internal.QuickEditTabManager;
import org.eclipse.jst.pagedesigner.properties.internal.QuickEditTabSectionsDescriptor;
import org.eclipse.jst.pagedesigner.tests.tabbed.properties.sections.BaseTestCase;
import org.eclipse.jst.pagedesigner.tests.tabbed.properties.sections.FakePropertySection;
import org.eclipse.jst.pagedesigner.tests.tabbed.properties.sections.FakePropertySectionUsingDialogField;
import org.eclipse.jst.pagedesigner.ui.dialogfields.DialogFieldWrapper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BasicTabbedPropertyPageTests
extends BaseTestCase {
    public void testSanity() {
        block8: {
            HTMLEditor ed = null;
            try {
                try {
                    IFile file = this.getJSPFile("/testdata/propertypages/testPropertyPage.jsp.data", "/testPropertyPage.jsp");
                    BasicTabbedPropertyPageTests.assertNotNull((Object)file);
                    ed = this.openHTMLEditor(file);
                    BasicTabbedPropertyPageTests.assertNotNull((Object)ed);
                    IViewPart view = this.showPropertiesView();
                    BasicTabbedPropertyPageTests.assertNotNull((Object)view);
                    Node node = this.getNode(file, 425);
                    BasicTabbedPropertyPageTests.assertTrue((boolean)(node instanceof Element));
                    BasicTabbedPropertyPageTests.assertEquals((String)"tagWithQuickEditMD", (String)node.getLocalName());
                    IStructuredSelection sel = this.getSelection(node);
                    view.getViewSite().getSelectionProvider().setSelection((ISelection)sel);
                    ISelection selection = view.getViewSite().getSelectionProvider().getSelection();
                    BasicTabbedPropertyPageTests.assertEquals((Object)selection, (Object)sel);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    BasicTabbedPropertyPageTests.fail((String)ex.getLocalizedMessage());
                    if (ed != null) {
                        this.closeEditor((IEditorPart)ed);
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (ed != null) {
                    this.closeEditor((IEditorPart)ed);
                }
                throw throwable;
            }
            if (ed != null) {
                this.closeEditor((IEditorPart)ed);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testQuickEditTabManager() {
        IFile file = null;
        QuickEditTabManager mgr = null;
        HTMLEditor ed = null;
        try {
            file = this.getJSPFile("/testdata/propertypages/testPropertyPage.jsp.data", "/testPropertyPage.jsp");
            BasicTabbedPropertyPageTests.assertNotNull((Object)file);
            ed = this.openHTMLEditor(file);
            BasicTabbedPropertyPageTests.assertNotNull((Object)ed);
            this.showPropertiesView();
            mgr = this.getWPETabbedPropertySheetPage(ed).getTabManager();
            BasicTabbedPropertyPageTests.assertNotNull((Object)mgr);
            Node node1 = this.getNode(file, 425);
            IStructuredSelection selection = this.getSelection(node1);
            mgr.selectionChanged((IWorkbenchPart)ed, (ISelection)selection);
            QuickEditTabSectionsDescriptor tsg1 = mgr.getCurrentTabGroupDescriptor();
            BasicTabbedPropertyPageTests.assertNotNull((String)"QuickEditTabSectionsDescriptor was null for Qtag with QE MD", (Object)tsg1);
            List sections = tsg1.getSections();
            BasicTabbedPropertyPageTests.assertEquals((String)"Expected 3 sections for tag qith QE MD", (int)3, (int)sections.size());
            ISection sec = (ISection)sections.get(0);
            BasicTabbedPropertyPageTests.assertTrue((String)"section was not AttributeGroupSection", (boolean)(sec instanceof AttributeGroupSection));
            DialogField[] fields = ((AttributeGroupSection)sec).getAttributeGroup().getDialogFields();
            BasicTabbedPropertyPageTests.assertEquals((String)"Expecting 4 dialog fields for the 4 attributes", (int)4, (int)fields.length);
            DialogField fld = fields[0];
            BasicTabbedPropertyPageTests.assertTrue((String)"IPropertyPageDescriptor not located for tagWithQuickEditMD", (boolean)(fld.getAttachedData((Object)"KEY_ATTR") instanceof IPropertyPageDescriptor));
            IPropertyPageDescriptor ppd = (IPropertyPageDescriptor)fld.getAttachedData((Object)"KEY_ATTR");
            BasicTabbedPropertyPageTests.assertEquals((String)"aBoolean", (String)ppd.getAttributeName());
            BasicTabbedPropertyPageTests.assertTrue((String)"aBoolean fld should be a DialogFieldWrapper", (boolean)(fld instanceof DialogFieldWrapper));
            BasicTabbedPropertyPageTests.assertTrue((String)"aBoolean should be a MDEnabledComboDialogField", (boolean)((DialogFieldWrapper)fld).getWrappedDialogField().getClass().getName().equals("org.eclipse.jst.pagedesigner.properties.dialogfields.MDEnabledComboDialogField"));
            fld = fields[1];
            BasicTabbedPropertyPageTests.assertEquals((String)"aStyle", (String)((IPropertyPageDescriptor)fld.getAttachedData((Object)"KEY_ATTR")).getAttributeName());
            BasicTabbedPropertyPageTests.assertTrue((String)"aStyle should be a StyleButtonDialogField", (boolean)((DialogFieldWrapper)fld).getWrappedDialogField().getClass().getName().equals("org.eclipse.jst.pagedesigner.ui.dialogfields.StyleButtonDialogField"));
            fld = fields[2];
            BasicTabbedPropertyPageTests.assertEquals((String)"aStringPropWithMd", (String)((IPropertyPageDescriptor)fld.getAttachedData((Object)"KEY_ATTR")).getAttributeName());
            BasicTabbedPropertyPageTests.assertTrue((String)"aStringPropWithMd should be a MDEnabledComboDialogField", (boolean)((DialogFieldWrapper)fld).getWrappedDialogField().getClass().getName().equals("org.eclipse.jst.pagedesigner.properties.dialogfields.MDEnabledComboDialogField"));
            fld = fields[3];
            BasicTabbedPropertyPageTests.assertEquals((String)"aStringPropNoMd", (String)((IPropertyPageDescriptor)fld.getAttachedData((Object)"KEY_ATTR")).getAttributeName());
            BasicTabbedPropertyPageTests.assertTrue((String)"aStringPropNoMd should be a StringDialogField", (boolean)((DialogFieldWrapper)fld).getWrappedDialogField().getClass().getName().equals("org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField"));
            sec = (ISection)sections.get(1);
            BasicTabbedPropertyPageTests.assertTrue((String)"section was not FakePropertySection", (boolean)(sec instanceof FakePropertySection));
            sec = (ISection)sections.get(2);
            BasicTabbedPropertyPageTests.assertTrue((String)"section was not FakePropertySectionUsingDialogField", (boolean)(sec instanceof FakePropertySectionUsingDialogField));
            Node node2 = this.getNode(file, 475);
            selection = this.getSelection(node2);
            mgr.selectionChanged((IWorkbenchPart)ed, (ISelection)selection);
            QuickEditTabSectionsDescriptor tsg2 = mgr.getCurrentTabGroupDescriptor();
            BasicTabbedPropertyPageTests.assertNotNull((String)"QuickEditTabSectionsDescriptor was null", (Object)tsg2);
            sections = tsg2.getSections();
            BasicTabbedPropertyPageTests.assertEquals((String)"Expected single section", (int)1, (int)sections.size());
            sec = (ISection)sections.get(0);
            BasicTabbedPropertyPageTests.assertTrue((String)"section was not NullQuickEditTabSection", (boolean)(sec instanceof NullQuickEditTabSection));
            selection = this.getSelection(node1);
            mgr.selectionChanged((IWorkbenchPart)ed, (ISelection)selection);
            BasicTabbedPropertyPageTests.assertSame((String)"Desc w/MD not same", (Object)tsg1, (Object)mgr.getCurrentTabGroupDescriptor());
            selection = this.getSelection(node2);
            mgr.selectionChanged((IWorkbenchPart)ed, (ISelection)selection);
            BasicTabbedPropertyPageTests.assertSame((String)"Desc wo/MD not same", (Object)tsg2, (Object)mgr.getCurrentTabGroupDescriptor());
            Node node3 = this.getNode(file, 530);
            selection = this.getSelection(node3);
            mgr.selectionChanged((IWorkbenchPart)ed, (ISelection)selection);
            QuickEditTabSectionsDescriptor tsg3 = mgr.getCurrentTabGroupDescriptor();
            BasicTabbedPropertyPageTests.assertNotNull((String)"QuickEditTabSectionsDescriptor was null for Qtag with bad QE MD", (Object)tsg3);
            sections = tsg3.getSections();
            BasicTabbedPropertyPageTests.assertEquals((String)"Expected 2 sections for tag with bad QE MD", (int)2, (int)sections.size());
            sec = (ISection)sections.get(0);
            BasicTabbedPropertyPageTests.assertTrue((String)"section was not AttributeGroupSection", (boolean)(sec instanceof AttributeGroupSection));
            sec = (ISection)sections.get(1);
            BasicTabbedPropertyPageTests.assertTrue((String)"section was not FakePropertySectionUsingDialogField", (boolean)(sec instanceof FakePropertySectionUsingDialogField));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            BasicTabbedPropertyPageTests.fail((String)ex.getLocalizedMessage());
            mgr = null;
            if (ed == null) return;
            this.closeEditor((IEditorPart)ed);
            return;
        }
        catch (CoreException ex) {
            ex.printStackTrace();
            BasicTabbedPropertyPageTests.fail((String)ex.getLocalizedMessage());
            mgr = null;
            if (ed == null) return;
            this.closeEditor((IEditorPart)ed);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BasicTabbedPropertyPageTests.fail((String)ex.getLocalizedMessage());
            mgr = null;
            if (ed == null) return;
            {
                catch (Throwable throwable) {
                    mgr = null;
                    if (ed == null) throw throwable;
                    this.closeEditor((IEditorPart)ed);
                    throw throwable;
                }
            }
            this.closeEditor((IEditorPart)ed);
            return;
        }
        mgr = null;
        if (ed == null) return;
        this.closeEditor((IEditorPart)ed);
    }

    /*
     * Loose catch block
     */
    public void testMultipleJSPs() {
        block15: {
            HTMLEditor ed2;
            block18: {
                QuickEditTabManager mgr1 = null;
                QuickEditTabManager mgr2 = null;
                HTMLEditor ed1 = null;
                ed2 = null;
                try {
                    IFile file = this.getJSPFile("/testdata/propertypages/testPropertyPage.jsp.data", "/testPropertyPage.jsp");
                    BasicTabbedPropertyPageTests.assertNotNull((Object)file);
                    ed1 = this.openHTMLEditor(file);
                    BasicTabbedPropertyPageTests.assertNotNull((Object)ed1);
                    this.showPropertiesView();
                    mgr1 = this.getWPETabbedPropertySheetPage(ed1).getTabManager();
                    BasicTabbedPropertyPageTests.assertNotNull((Object)mgr1);
                    Node node1 = this.getNode(file, 425);
                    IStructuredSelection selection = this.getSelection(node1);
                    mgr1.selectionChanged((IWorkbenchPart)ed1, (ISelection)selection);
                    QuickEditTabSectionsDescriptor tsg1 = mgr1.getCurrentTabGroupDescriptor();
                    BasicTabbedPropertyPageTests.assertNotNull((Object)tsg1);
                    file = this.getJSPFile("/testdata/propertypages/testPropertyPage.jsp.data", "/testPropertyPage2.jsp");
                    BasicTabbedPropertyPageTests.assertNotNull((Object)file);
                    ed2 = this.openHTMLEditor(file);
                    BasicTabbedPropertyPageTests.assertNotNull((Object)ed2);
                    this.showPropertiesView();
                    mgr2 = this.getWPETabbedPropertySheetPage(ed2).getTabManager();
                    BasicTabbedPropertyPageTests.assertNotNull((Object)mgr2);
                    BasicTabbedPropertyPageTests.assertSame((String)"Manager instances should be the same for different WPE instances within same project", (Object)mgr1.getQuickEditTabSectionsManager(), (Object)mgr2.getQuickEditTabSectionsManager());
                    Node node2 = this.getNode(file, 425);
                    selection = this.getSelection(node2);
                    mgr2.selectionChanged((IWorkbenchPart)ed2, (ISelection)selection);
                    QuickEditTabSectionsDescriptor tsg2 = mgr2.getCurrentTabGroupDescriptor();
                    BasicTabbedPropertyPageTests.assertSame((String)"section descriptor for tag on different pages should be the same", (Object)tsg1, (Object)tsg2);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    BasicTabbedPropertyPageTests.fail((String)ex.getLocalizedMessage());
                    mgr1 = null;
                    mgr2 = null;
                    if (ed1 != null) {
                        this.closeEditor((IEditorPart)ed1);
                        ed1 = null;
                    }
                    if (ed2 != null) {
                        this.closeEditor((IEditorPart)ed2);
                        ed2 = null;
                    }
                    break block15;
                }
                catch (CoreException ex) {
                    block16: {
                        ex.printStackTrace();
                        BasicTabbedPropertyPageTests.fail((String)ex.getLocalizedMessage());
                        mgr1 = null;
                        mgr2 = null;
                        if (ed1 == null) break block16;
                        this.closeEditor((IEditorPart)ed1);
                        ed1 = null;
                    }
                    if (ed2 != null) {
                        this.closeEditor((IEditorPart)ed2);
                        ed2 = null;
                    }
                    break block15;
                }
                catch (Exception ex) {
                    block17: {
                        ex.printStackTrace();
                        BasicTabbedPropertyPageTests.fail((String)ex.getLocalizedMessage());
                        mgr1 = null;
                        mgr2 = null;
                        if (ed1 == null) break block17;
                        {
                            catch (Throwable throwable) {
                                mgr1 = null;
                                mgr2 = null;
                                if (ed1 != null) {
                                    this.closeEditor((IEditorPart)ed1);
                                    ed1 = null;
                                }
                                if (ed2 != null) {
                                    this.closeEditor((IEditorPart)ed2);
                                    ed2 = null;
                                }
                                throw throwable;
                            }
                        }
                        this.closeEditor((IEditorPart)ed1);
                        ed1 = null;
                    }
                    if (ed2 != null) {
                        this.closeEditor((IEditorPart)ed2);
                        ed2 = null;
                    }
                    break block15;
                }
                mgr1 = null;
                mgr2 = null;
                if (ed1 == null) break block18;
                this.closeEditor((IEditorPart)ed1);
                ed1 = null;
            }
            if (ed2 != null) {
                this.closeEditor((IEditorPart)ed2);
                ed2 = null;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void testMultiProject() {
        block15: {
            HTMLEditor ed2;
            block18: {
                QuickEditTabManager mgr1 = null;
                QuickEditTabManager mgr2 = null;
                HTMLEditor ed1 = null;
                ed2 = null;
                try {
                    IFile file = this.getJSPFile("/testdata/propertypages/testPropertyPage.jsp.data", "/testPropertyPage.jsp");
                    BasicTabbedPropertyPageTests.assertNotNull((Object)file);
                    ed1 = this.openHTMLEditor(file);
                    BasicTabbedPropertyPageTests.assertNotNull((Object)ed1);
                    this.showPropertiesView();
                    mgr1 = this.getWPETabbedPropertySheetPage(ed1).getTabManager();
                    BasicTabbedPropertyPageTests.assertNotNull((Object)mgr1);
                    Node node1 = this.getNode(file, 425);
                    IStructuredSelection selection = this.getSelection(node1);
                    mgr1.selectionChanged((IWorkbenchPart)ed1, (ISelection)selection);
                    QuickEditTabSectionsDescriptor tsg1 = mgr1.getCurrentTabGroupDescriptor();
                    BasicTabbedPropertyPageTests.assertNotNull((Object)tsg1);
                    file = this.getJSPFileFromSecondProject("/testdata/propertypages/testPropertyPage.jsp.data", "/testPropertyPage2.jsp");
                    BasicTabbedPropertyPageTests.assertNotNull((Object)file);
                    ed2 = this.openHTMLEditor(file);
                    BasicTabbedPropertyPageTests.assertNotNull((Object)ed2);
                    this.showPropertiesView();
                    mgr2 = this.getWPETabbedPropertySheetPage(ed2).getTabManager();
                    BasicTabbedPropertyPageTests.assertNotNull((Object)mgr2);
                    BasicTabbedPropertyPageTests.assertNotSame((String)"Should have different QuickEditMgrInstances for different projects", (Object)mgr1.getQuickEditTabSectionsManager(), (Object)mgr2.getQuickEditTabSectionsManager());
                    Node node2 = this.getNode(file, 425);
                    selection = this.getSelection(node2);
                    mgr2.selectionChanged((IWorkbenchPart)ed2, (ISelection)selection);
                    QuickEditTabSectionsDescriptor tsg2 = mgr2.getCurrentTabGroupDescriptor();
                    BasicTabbedPropertyPageTests.assertNotSame((String)"section descriptor for tag on different pages from different projects should be different", (Object)tsg1, (Object)tsg2);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    BasicTabbedPropertyPageTests.fail((String)ex.getLocalizedMessage());
                    mgr1 = null;
                    mgr2 = null;
                    if (ed1 != null) {
                        this.closeEditor((IEditorPart)ed1);
                        ed1 = null;
                    }
                    if (ed2 != null) {
                        this.closeEditor((IEditorPart)ed2);
                        ed2 = null;
                    }
                    break block15;
                }
                catch (CoreException ex) {
                    block16: {
                        ex.printStackTrace();
                        BasicTabbedPropertyPageTests.fail((String)ex.getLocalizedMessage());
                        mgr1 = null;
                        mgr2 = null;
                        if (ed1 == null) break block16;
                        this.closeEditor((IEditorPart)ed1);
                        ed1 = null;
                    }
                    if (ed2 != null) {
                        this.closeEditor((IEditorPart)ed2);
                        ed2 = null;
                    }
                    break block15;
                }
                catch (Exception ex) {
                    block17: {
                        ex.printStackTrace();
                        BasicTabbedPropertyPageTests.fail((String)ex.getLocalizedMessage());
                        mgr1 = null;
                        mgr2 = null;
                        if (ed1 == null) break block17;
                        {
                            catch (Throwable throwable) {
                                mgr1 = null;
                                mgr2 = null;
                                if (ed1 != null) {
                                    this.closeEditor((IEditorPart)ed1);
                                    ed1 = null;
                                }
                                if (ed2 != null) {
                                    this.closeEditor((IEditorPart)ed2);
                                    ed2 = null;
                                }
                                throw throwable;
                            }
                        }
                        this.closeEditor((IEditorPart)ed1);
                        ed1 = null;
                    }
                    if (ed2 != null) {
                        this.closeEditor((IEditorPart)ed2);
                        ed2 = null;
                    }
                    break block15;
                }
                mgr1 = null;
                mgr2 = null;
                if (ed1 == null) break block18;
                this.closeEditor((IEditorPart)ed1);
                ed1 = null;
            }
            if (ed2 != null) {
                this.closeEditor((IEditorPart)ed2);
                ed2 = null;
            }
        }
    }
}

