/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.validation;

import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.validation.JSPActionValidator;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.jst.jsp.core.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.core.tests.validation.ValidationContextForTest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class JSPActionValidatorTest
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "testvalidatejspactions";
    private static final String UNDEFINED_ATTR_IDONT = "idont";
    private static final String REQUIRED_ATTR_NAME = "name";
    private static final String NONEMPTY_INLINE_TAG_NAME = "libtags:emptybodycontent";

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists()) {
            BundleResourceUtil.createSimpleProject(PROJECT_NAME, null, new String[]{"org.eclipse.jdt.core.javanature"});
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/testvalidatejspactions", "/testvalidatejspactions");
        }
        JSPActionValidatorTest.assertTrue((String)"project could not be created", (boolean)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
    }

    public void testUknownAttribute() throws Exception {
        JSPActionValidator validator = new JSPActionValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/testvalidatejspactions/WebContent/undefinedattribute.jsp";
        JSPActionValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        boolean foundError1 = this.errorMessageFound(reporter, NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_6, (Object)UNDEFINED_ATTR_IDONT), 4);
        if (foundError1) {
            foundError1 = this.errorMessageFound(reporter, NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_6, (Object)UNDEFINED_ATTR_IDONT), 12);
        }
        if (foundError1) {
            foundError1 = this.errorMessageFound(reporter, NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_6, (Object)UNDEFINED_ATTR_IDONT), 13);
        }
        JSPActionValidatorTest.assertTrue((String)"jsp action validator did not detect undefined attributes", (boolean)foundError1);
    }

    public void testMissingRequiredAttribute() throws Exception {
        JSPActionValidator validator = new JSPActionValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/testvalidatejspactions/WebContent/norequiredattribute.jsp";
        JSPActionValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        boolean foundError = this.errorMessageFound(reporter, NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_5, (Object)REQUIRED_ATTR_NAME), 11);
        if (foundError) {
            foundError = this.errorMessageFound(reporter, NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_5, (Object)REQUIRED_ATTR_NAME), 12);
        }
        JSPActionValidatorTest.assertTrue((String)"jsp action validator did not detect missing required attributes", (boolean)foundError);
    }

    private boolean errorMessageFound(IReporter reporter, String errorMessage, int errorLineNumber) {
        boolean foundError = false;
        List messages = reporter.getMessages();
        Iterator iter = messages.iterator();
        while (iter.hasNext() && !foundError) {
            IMessage message = (IMessage)iter.next();
            int lineNumber = message.getLineNumber();
            String messageText = message.getText();
            if (lineNumber != errorLineNumber || !messageText.startsWith(errorMessage)) continue;
            foundError = true;
        }
        return foundError;
    }

    public void testAttributesCorrect() throws Exception {
        JSPActionValidator validator = new JSPActionValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/testvalidatejspactions/WebContent/worksfine.jsp";
        JSPActionValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPActionValidatorTest.assertTrue((String)"jsp action validator found errors when it should not have", (boolean)reporter.getMessages().isEmpty());
    }

    public void testNonEmptyInlineTag() throws Exception {
        JSPActionValidator validator = new JSPActionValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/testvalidatejspactions/WebContent/nonemptyinlinetag.jsp";
        JSPActionValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        boolean foundError = this.errorMessageFound(reporter, NLS.bind((String)JSPCoreMessages.JSPActionValidator_0, (Object)NONEMPTY_INLINE_TAG_NAME), 10);
        JSPActionValidatorTest.assertTrue((String)"jsp action validator had problems detecting an error with content in an inline tag", (boolean)foundError);
    }
}

