/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.validation;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.validation.JSPBatchValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPContentValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPJavaValidator;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.jst.jsp.core.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.core.tests.validation.ValidationContextForTest;
import org.eclipse.wst.validation.ReporterHelper;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class JSPBatchValidatorTest
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "batchvalidation";
    Object originalWorkspaceValue = null;
    IEclipsePreferences workspaceScope = null;
    IEclipsePreferences projectScope = null;
    Object[] validatorIds = new String[]{"org.eclipse.jst.jsp.core.JSPContentValidator", "org.eclipse.jst.jsp.core.JSPBatchValidator"};
    IWorkspace workspace = ResourcesPlugin.getWorkspace();

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!this.getProject().exists()) {
            BundleResourceUtil.createSimpleProject(PROJECT_NAME, null, new String[]{"org.eclipse.jdt.core.javanature"});
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/batchvalidation", "/batchvalidation");
        }
        JSPBatchValidatorTest.assertTrue((String)"project could not be created", (boolean)this.getProject().exists());
        String filePath = "/batchvalidation/WebContent/header.jspf";
        IFile fragment = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        String qualifier = JSPCorePlugin.getDefault().getBundle().getSymbolicName();
        this.workspaceScope = new InstanceScope().getNode(qualifier);
        this.projectScope = new ProjectScope(fragment.getProject()).getNode(qualifier);
        this.originalWorkspaceValue = this.workspaceScope.get("validateFragments", null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
        this.projectScope.remove("validateFragments");
        this.projectScope.remove("validation.use-project-settings");
        if (this.originalWorkspaceValue != null) {
            this.workspaceScope.put("validateFragments", this.originalWorkspaceValue.toString());
        } else {
            this.workspaceScope.remove("validateFragments");
        }
    }

    public void testValidating2Files() throws Exception {
        JSPJavaValidator validator = new JSPJavaValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath1 = "/batchvalidation/WebContent/ihaveerrors.jsp";
        IFile file1 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath1));
        JSPBatchValidatorTest.assertTrue((boolean)file1.exists());
        String filePath2 = "/batchvalidation/WebContent/ihaveerrors2.jsp";
        IFile file2 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath1));
        JSPBatchValidatorTest.assertTrue((boolean)file2.exists());
        helper.setURIs(new String[]{filePath1, filePath2});
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPBatchValidatorTest.assertTrue((String)"jsp errors were not found in both files", (reporter.getMessages().size() == 2 ? 1 : 0) != 0);
    }

    public void testFragmentValidationPreferenceOnProject() throws Exception {
        JSPBatchValidator validator1 = new JSPBatchValidator();
        JSPContentValidator validator2 = new JSPContentValidator();
        String filePath = "/batchvalidation/WebContent/header.jspf";
        ValidationResult result = null;
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        this.workspaceScope.putBoolean("validateFragments", true);
        this.projectScope.putBoolean("validation.use-project-settings", true);
        this.projectScope.putBoolean("validateFragments", false);
        result = validator1.validate((IResource)file, 4, new ValidationState(), (IProgressMonitor)new NullProgressMonitor());
        result.mergeResults(validator2.validate((IResource)file, 4, new ValidationState(), (IProgressMonitor)new NullProgressMonitor()));
        JSPBatchValidatorTest.assertEquals((String)"Problems found while fragment validation was disabled in project but enabled on workspace", (int)0, (int)((ReporterHelper)result.getReporter(null)).getMessages().size());
        this.workspaceScope.putBoolean("validateFragments", false);
        this.projectScope.putBoolean("validation.use-project-settings", true);
        this.projectScope.putBoolean("validateFragments", true);
        JSPFContentProperties.setProperty((String)"validateFragments", (IResource)file, (String)Boolean.toString(true));
        result = validator1.validate((IResource)file, 4, new ValidationState(), (IProgressMonitor)new NullProgressMonitor());
        result.mergeResults(validator2.validate((IResource)file, 4, new ValidationState(), (IProgressMonitor)new NullProgressMonitor()));
        JSPBatchValidatorTest.assertTrue((String)"Problems not found while fragment validation was enabled for project but disabled on workspace", (((ReporterHelper)result.getReporter(null)).getMessages().size() > 0 ? 1 : 0) != 0);
    }

    public void testFragmentValidationPreferenceOnWorkspace() throws Exception {
        JSPBatchValidator validator1 = new JSPBatchValidator();
        JSPContentValidator validator2 = new JSPContentValidator();
        String filePath = "/batchvalidation/WebContent/header.jspf";
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        ValidationResult result = null;
        this.workspaceScope.putBoolean("validateFragments", false);
        result = validator1.validate((IResource)file, 4, new ValidationState(), (IProgressMonitor)new NullProgressMonitor());
        result.mergeResults(validator2.validate((IResource)file, 4, new ValidationState(), (IProgressMonitor)new NullProgressMonitor()));
        JSPBatchValidatorTest.assertEquals((String)"Problem markers found while fragment validation was disabled", (int)0, (int)((ReporterHelper)result.getReporter(null)).getMessages().size());
        this.workspaceScope.putBoolean("validateFragments", true);
        ValidationFramework.getDefault().validate(new IProject[]{this.getProject()}, true, false, (IProgressMonitor)new NullProgressMonitor());
        ValidationFramework.getDefault().join((IProgressMonitor)new NullProgressMonitor());
        result = validator1.validate((IResource)file, 4, new ValidationState(), (IProgressMonitor)new NullProgressMonitor());
        result.mergeResults(validator2.validate((IResource)file, 4, new ValidationState(), (IProgressMonitor)new NullProgressMonitor()));
        JSPBatchValidatorTest.assertTrue((String)"Problem markers not found while fragment validation was enabled on workspace", (((ReporterHelper)result.getReporter(null)).getMessages().size() != 0 ? 1 : 0) != 0);
        this.workspaceScope.remove("validateFragments");
        this.projectScope.remove("validateFragments");
        this.projectScope.remove("validation.use-project-settings");
        result = validator1.validate((IResource)file, 4, new ValidationState(), (IProgressMonitor)new NullProgressMonitor());
        result.mergeResults(validator2.validate((IResource)file, 4, new ValidationState(), (IProgressMonitor)new NullProgressMonitor()));
        JSPBatchValidatorTest.assertTrue((String)"Problem markers not found while fragment validation was preferences were default", (((ReporterHelper)result.getReporter(null)).getMessages().size() != 0 ? 1 : 0) != 0);
    }

    private IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
    }
}

