/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IBinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.CastExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class BinaryExpression
extends OperatorExpression
implements IBinaryExpression {
    public Expression left;
    public Expression right;
    public Constant optimizedBooleanConstant;

    public BinaryExpression(Expression left, Expression right, int operator) {
        this.left = left;
        this.right = right;
        this.bits |= operator << 6;
        this.sourceStart = left.sourceStart;
        this.sourceEnd = right.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.resolvedType.id == 11) {
            return this.right.analyseCode(currentScope, flowContext, this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
        }
        this.left.checkNPE(currentScope, flowContext, flowInfo);
        flowInfo = this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        this.right.checkNPE(currentScope, flowContext, flowInfo);
        return this.right.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
    }

    public void computeConstant(BlockScope scope, int leftId, int rightId) {
        if (this.left.constant == null) {
            this.left.constant = Constant.NotAConstant;
        }
        if (this.right.constant == null) {
            this.left.constant = Constant.NotAConstant;
        }
        if (this.left.constant != Constant.NotAConstant && this.right.constant != Constant.NotAConstant) {
            try {
                this.constant = Constant.computeConstantOperation(this.left.constant, leftId, (this.bits & 0xFC0) >> 6, this.right.constant, rightId);
            }
            catch (Exception exception) {
                this.constant = Constant.NotAConstant;
            }
        } else {
            this.constant = Constant.NotAConstant;
            this.optimizedBooleanConstant(leftId, (this.bits & 0xFC0) >> 6, rightId);
        }
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public boolean isCompactableOperation() {
        return true;
    }

    void nonRecursiveResolveTypeUpwards(BlockScope scope) {
        boolean use15specifics;
        TypeBinding leftType = this.left.resolvedType;
        boolean rightIsCast = this.right instanceof CastExpression;
        if (rightIsCast) {
            this.right.bits |= 0x20;
        }
        TypeBinding rightType = this.right.resolveType(scope);
        if (leftType == null || rightType == null) {
            this.constant = Constant.NotAConstant;
            return;
        }
        int leftTypeID = leftType.id;
        int rightTypeID = rightType.id;
        boolean bl = use15specifics = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (use15specifics) {
            if (!leftType.isBaseType() && rightTypeID != 11 && rightTypeID != 12) {
                leftTypeID = scope.environment().computeBoxingType((TypeBinding)leftType).id;
            }
            if (!rightType.isBaseType() && leftTypeID != 11 && leftTypeID != 12) {
                rightTypeID = scope.environment().computeBoxingType((TypeBinding)rightType).id;
            }
        }
        if (leftTypeID > 15 || rightTypeID > 15) {
            if (leftTypeID == 11) {
                rightTypeID = 1;
            } else if (rightTypeID == 11) {
                leftTypeID = 1;
            } else {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftType, rightType);
                return;
            }
        }
        if ((this.bits & 0xFC0) >> 6 == 14) {
            if (leftTypeID == 11) {
                this.left.computeConversion(scope, leftType, leftType);
                if (rightType.isArrayType() && ((ArrayBinding)rightType).elementsType() == TypeBinding.CHAR) {
                    scope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.right);
                }
            }
            if (rightTypeID == 11) {
                this.right.computeConversion(scope, rightType, rightType);
                if (leftType.isArrayType() && ((ArrayBinding)leftType).elementsType() == TypeBinding.CHAR) {
                    scope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.left);
                }
            }
        }
        int operator = (this.bits & 0xFC0) >> 6;
        int operatorSignature = OperatorExpression.OperatorSignatures[operator][(leftTypeID << 4) + rightTypeID];
        this.left.computeConversion(scope, TypeBinding.wellKnownType(scope, operatorSignature >>> 16 & 0xF), leftType);
        this.right.computeConversion(scope, TypeBinding.wellKnownType(scope, operatorSignature >>> 8 & 0xF), rightType);
        this.bits |= operatorSignature & 0xF;
        switch (operatorSignature & 0xF) {
            case 5: {
                this.resolvedType = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                this.resolvedType = TypeBinding.BYTE;
                break;
            }
            case 2: {
                this.resolvedType = TypeBinding.CHAR;
                break;
            }
            case 8: {
                this.resolvedType = TypeBinding.DOUBLE;
                break;
            }
            case 9: {
                this.resolvedType = TypeBinding.FLOAT;
                break;
            }
            case 10: {
                this.resolvedType = TypeBinding.INT;
                break;
            }
            case 7: {
                this.resolvedType = TypeBinding.LONG;
                break;
            }
            case 11: {
                this.resolvedType = scope.getJavaLangString();
                break;
            }
            default: {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftType, rightType);
                return;
            }
        }
        boolean leftIsCast = this.left instanceof CastExpression;
        if (leftIsCast || rightIsCast) {
            CastExpression.checkNeedForArgumentCasts(scope, operator, operatorSignature, this.left, leftTypeID, leftIsCast, this.right, rightTypeID, rightIsCast);
        }
        this.computeConstant(scope, leftTypeID, rightTypeID);
    }

    public void optimizedBooleanConstant(int leftId, int operator, int rightId) {
        switch (operator) {
            case 2: {
                if (leftId != 5 || rightId != 5) {
                    return;
                }
            }
            case 0: {
                Constant cst = this.left.optimizedBooleanConstant();
                if (cst != Constant.NotAConstant) {
                    if (!cst.booleanValue()) {
                        this.optimizedBooleanConstant = cst;
                        return;
                    }
                    cst = this.right.optimizedBooleanConstant();
                    if (cst != Constant.NotAConstant) {
                        this.optimizedBooleanConstant = cst;
                    }
                    return;
                }
                cst = this.right.optimizedBooleanConstant();
                if (cst != Constant.NotAConstant && !cst.booleanValue()) {
                    this.optimizedBooleanConstant = cst;
                }
                return;
            }
            case 3: {
                if (leftId != 5 || rightId != 5) {
                    return;
                }
            }
            case 1: {
                Constant cst = this.left.optimizedBooleanConstant();
                if (cst != Constant.NotAConstant) {
                    if (cst.booleanValue()) {
                        this.optimizedBooleanConstant = cst;
                        return;
                    }
                    cst = this.right.optimizedBooleanConstant();
                    if (cst != Constant.NotAConstant) {
                        this.optimizedBooleanConstant = cst;
                    }
                    return;
                }
                cst = this.right.optimizedBooleanConstant();
                if (cst == Constant.NotAConstant || !cst.booleanValue()) break;
                this.optimizedBooleanConstant = cst;
            }
        }
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.left.printExpression(indent, output).append(' ').append(this.operatorToString()).append(' ');
        return this.right.printExpression(0, output);
    }

    public TypeBinding resolveType(BlockScope scope) {
        boolean use15specifics;
        boolean leftIsCast = this.left instanceof CastExpression;
        if (leftIsCast) {
            this.left.bits |= 0x20;
        }
        TypeBinding leftType = this.left.resolveType(scope);
        boolean rightIsCast = this.right instanceof CastExpression;
        if (rightIsCast) {
            this.right.bits |= 0x20;
        }
        TypeBinding rightType = this.right.resolveType(scope);
        if (leftType == null || rightType == null) {
            this.constant = Constant.NotAConstant;
            this.resolvedType = TypeBinding.ANY;
            return null;
        }
        int operator = (this.bits & 0xFC0) >> 6;
        int leftTypeID = leftType.id;
        int rightTypeID = rightType.id;
        if (operator == 26 || operator == 23) {
            if (rightTypeID > 15) {
                rightTypeID = 1;
            }
            if (leftTypeID > 15) {
                leftTypeID = 1;
            }
        }
        boolean bl = use15specifics = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (use15specifics) {
            if (!leftType.isBaseType() && rightTypeID != 11 && rightTypeID != 12) {
                leftTypeID = scope.environment().computeBoxingType((TypeBinding)leftType).id;
            }
            if (!rightType.isBaseType() && leftTypeID != 11 && leftTypeID != 12) {
                rightTypeID = scope.environment().computeBoxingType((TypeBinding)rightType).id;
            }
        }
        if (rightType.isArrayType()) {
            rightType = rightType.leafComponentType();
            rightTypeID = rightType.id;
        }
        if (leftTypeID > 15 || rightTypeID > 15) {
            if (leftTypeID == 11) {
                rightTypeID = 1;
            } else if (rightTypeID == 11) {
                leftTypeID = 1;
            } else {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftType, rightType);
                return null;
            }
        }
        if ((this.bits & 0xFC0) >> 6 == 14) {
            if (leftTypeID == 11) {
                this.left.computeConversion(scope, leftType, leftType);
                if (rightType.isArrayType() && ((ArrayBinding)rightType).elementsType() == TypeBinding.CHAR) {
                    scope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.right);
                }
            }
            if (rightTypeID == 11) {
                this.right.computeConversion(scope, rightType, rightType);
                if (leftType.isArrayType() && ((ArrayBinding)leftType).elementsType() == TypeBinding.CHAR) {
                    scope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.left);
                }
            }
        }
        int operatorSignature = OperatorExpression.OperatorSignatures[operator][(leftTypeID << 4) + rightTypeID];
        this.left.computeConversion(scope, TypeBinding.wellKnownType(scope, operatorSignature >>> 16 & 0xF), leftType);
        this.right.computeConversion(scope, TypeBinding.wellKnownType(scope, operatorSignature >>> 8 & 0xF), rightType);
        this.bits |= operatorSignature & 0xF;
        switch (operatorSignature & 0xF) {
            case 5: {
                this.resolvedType = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                this.resolvedType = TypeBinding.BYTE;
                break;
            }
            case 2: {
                this.resolvedType = TypeBinding.CHAR;
                break;
            }
            case 8: {
                this.resolvedType = TypeBinding.DOUBLE;
                break;
            }
            case 9: {
                this.resolvedType = TypeBinding.FLOAT;
                break;
            }
            case 10: {
                this.resolvedType = scope.getJavaLangNumber();
                break;
            }
            case 7: {
                this.resolvedType = TypeBinding.LONG;
                break;
            }
            case 11: {
                this.resolvedType = scope.getJavaLangString();
                break;
            }
            case 13: {
                this.resolvedType = TypeBinding.UNKNOWN;
                break;
            }
            case 14: {
                this.resolvedType = scope.getJavaLangFunction();
                break;
            }
            default: {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftType, rightType);
                return null;
            }
        }
        if (leftIsCast || rightIsCast) {
            CastExpression.checkNeedForArgumentCasts(scope, operator, operatorSignature, this.left, leftTypeID, leftIsCast, this.right, rightTypeID, rightIsCast);
        }
        this.computeConstant(scope, leftTypeID, rightTypeID);
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 15;
    }
}

