/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.beaninfo.BeanDecorator;
import org.eclipse.jem.internal.beaninfo.BeaninfoFactory;
import org.eclipse.jem.internal.beaninfo.BeaninfoPackage;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.jem.internal.beaninfo.FeatureDecorator;
import org.eclipse.jem.internal.beaninfo.ImplicitItem;
import org.eclipse.jem.internal.beaninfo.IndexedPropertyDecorator;
import org.eclipse.jem.internal.beaninfo.MethodDecorator;
import org.eclipse.jem.internal.beaninfo.MethodProxy;
import org.eclipse.jem.internal.beaninfo.ParameterDecorator;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoProxyConstants;
import org.eclipse.jem.internal.beaninfo.common.BeanRecord;
import org.eclipse.jem.internal.beaninfo.common.EventSetRecord;
import org.eclipse.jem.internal.beaninfo.common.FeatureAttributeValue;
import org.eclipse.jem.internal.beaninfo.common.FeatureRecord;
import org.eclipse.jem.internal.beaninfo.common.IndexedPropertyRecord;
import org.eclipse.jem.internal.beaninfo.common.MethodRecord;
import org.eclipse.jem.internal.beaninfo.common.ParameterRecord;
import org.eclipse.jem.internal.beaninfo.common.PropertyRecord;
import org.eclipse.jem.internal.beaninfo.common.ReflectFieldRecord;
import org.eclipse.jem.internal.beaninfo.common.ReflectMethodRecord;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoPlugin;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.beaninfo.impl.BeaninfoFactoryImpl;
import org.eclipse.jem.internal.beaninfo.impl.FeatureAttributeMapEntryImpl;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.MapJNITypes;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaEvent;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;

public class BeanInfoDecoratorUtility {
    private static final Integer ZERO = new Integer(0);
    private static final Integer ONE = new Integer(1);
    private static final Integer MINUS_ONE = new Integer(-1);

    public static void clear(FeatureDecorator decor) {
        long implicitSettings = decor.getImplicitlySetBits();
        if ((implicitSettings & Long.MIN_VALUE) != 0L) {
            decor.unsetDisplayName();
        }
        if ((implicitSettings & 0x4000000000000000L) != 0L) {
            decor.unsetShortDescription();
        }
        if ((implicitSettings & 0x2000000000000000L) != 0L) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getFeatureDecorator_Category());
        }
        if ((implicitSettings & 0x1000000000000000L) != 0L) {
            decor.unsetExpert();
        }
        if ((implicitSettings & 0x800000000000000L) != 0L) {
            decor.unsetHidden();
        }
        if ((implicitSettings & 0x400000000000000L) != 0L) {
            decor.unsetPreferred();
        }
        if ((implicitSettings & 0x200000000000000L) != 0L) {
            Iterator itr = decor.getAttributes().listIterator();
            while (itr.hasNext()) {
                FeatureAttributeMapEntryImpl entry = (FeatureAttributeMapEntryImpl)((Object)itr.next());
                if (!entry.getTypedValue().isImplicitValue()) continue;
                itr.remove();
            }
        }
        decor.setImplicitlySetBits(implicitSettings & 0x1FFFFFFFFFFFFFFL);
    }

    public static void clear(BeanDecorator decor) {
        BeanInfoDecoratorUtility.clear((FeatureDecorator)decor);
        long implicitSettings = decor.getImplicitlySetBits();
        if ((implicitSettings & 1L) != 0L) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_CustomizerClass());
        }
        if ((implicitSettings & 2L) != 0L) {
            decor.unsetMergeSuperProperties();
        }
        if ((implicitSettings & 4L) != 0L) {
            decor.unsetMergeSuperMethods();
        }
        if ((implicitSettings & 8L) != 0L) {
            decor.unsetMergeSuperEvents();
        }
        if (decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedPropertyNames())) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedPropertyNames());
        }
        if (decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedMethodNames())) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedMethodNames());
        }
        if (decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedEventNames())) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedEventNames());
        }
        decor.setImplicitlySetBits(implicitSettings & 0xFFFFFFFFFFFFFFF0L);
    }

    public static void clear(PropertyDecorator decor) {
        BeanInfoDecoratorUtility.clear((FeatureDecorator)decor);
        long implicitSettings = decor.getImplicitlySetBits();
        if ((implicitSettings & 1L) != 0L) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_PropertyEditorClass());
        }
        if ((implicitSettings & 4L) != 0L) {
            decor.unsetReadMethod();
        }
        if ((implicitSettings & 8L) != 0L) {
            decor.unsetWriteMethod();
        }
        if ((implicitSettings & 0x80L) != 0L) {
            decor.unsetField();
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_Field());
        }
        if ((implicitSettings & 0x10L) != 0L) {
            decor.unsetBound();
        }
        if ((implicitSettings & 0x20L) != 0L) {
            decor.unsetConstrained();
        }
        if ((implicitSettings & 0x40L) != 0L) {
            decor.unsetDesignTime();
        }
        decor.setImplicitlySetBits(implicitSettings & 0xFFFFFFFFFFFFFF82L);
    }

    public static void clear(IndexedPropertyDecorator decor) {
        BeanInfoDecoratorUtility.clear((PropertyDecorator)decor);
        long implicitSettings = decor.getImplicitlySetBits();
        if ((implicitSettings & 0x100000L) != 0L) {
            decor.unsetIndexedReadMethod();
        }
        if ((implicitSettings & 0x200000L) != 0L) {
            decor.unsetIndexedWriteMethod();
        }
        decor.setImplicitlySetBits(implicitSettings & 0xFFFFFFFFFFCFFFFFL);
    }

    public static void clear(MethodDecorator decor) {
        BeanInfoDecoratorUtility.clear((FeatureDecorator)decor);
        long implicitSettings = decor.getImplicitlySetBits();
        if ((implicitSettings & 3L) != 0L) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getMethodDecorator_SerParmDesc());
        }
        decor.setImplicitlySetBits(implicitSettings & 0xFFFFFFFFFFFFFFFCL);
    }

    public static void clear(EventSetDecorator decor) {
        BeanInfoDecoratorUtility.clear((FeatureDecorator)decor);
        long implicitSettings = decor.getImplicitlySetBits();
        if ((implicitSettings & 1L) != 0L) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_AddListenerMethod());
        }
        if ((implicitSettings & 2L) != 0L) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_EventAdapterClass());
        }
        if ((implicitSettings & 0x84L) != 0L) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_SerListMthd());
        }
        if ((implicitSettings & 0x10L) != 0L) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_RemoveListenerMethod());
        }
        if ((implicitSettings & 0x20L) != 0L) {
            decor.unsetInDefaultEventSet();
        }
        if ((implicitSettings & 0x40L) != 0L) {
            decor.unsetUnicast();
        }
        if ((implicitSettings & 8L) != 0L) {
            decor.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_ListenerType());
        }
        decor.setImplicitlySetBits(implicitSettings & 0xFFFFFFFFFFFFFF00L);
    }

    public static void introspect(IBeanProxy modelBeaninfoProxy, IntrospectCallBack callback) {
        ProxyIntrospectCallBack cb = new ProxyIntrospectCallBack(callback);
        modelBeaninfoProxy.getProxyFactoryRegistry().getCallbackRegistry().registerCallback(modelBeaninfoProxy, (ICallback)cb);
        try {
            BeaninfoProxyConstants.getConstants(modelBeaninfoProxy.getProxyFactoryRegistry()).getSendBeanInfoProxy().invokeCatchThrowableExceptions(modelBeaninfoProxy);
        }
        finally {
            modelBeaninfoProxy.getProxyFactoryRegistry().getCallbackRegistry().deregisterCallback(modelBeaninfoProxy);
        }
    }

    protected static void applyRecord(FeatureDecorator decor, FeatureRecord record) {
        long implicitSettings = decor.getImplicitlySetBits();
        if (record.displayName != null && !decor.isSetDisplayName()) {
            decor.setDisplayName(record.displayName);
            implicitSettings |= Long.MIN_VALUE;
        }
        if (record.shortDescription != null && !decor.isSetShortDescription()) {
            decor.setShortDescription(record.shortDescription);
            implicitSettings |= 0x4000000000000000L;
        }
        if (record.category != null && !decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getFeatureDecorator_Category())) {
            decor.setCategory(record.category);
            implicitSettings |= 0x2000000000000000L;
        }
        if (!decor.isSetExpert()) {
            if (decor.isExpert() != record.expert) {
                decor.setExpert(record.expert);
            }
            implicitSettings |= 0x1000000000000000L;
        }
        if (!decor.isSetHidden()) {
            if (decor.isHidden() != record.hidden) {
                decor.setHidden(record.hidden);
            }
            implicitSettings |= 0x800000000000000L;
        }
        if (!decor.isSetPreferred()) {
            if (decor.isPreferred() != record.preferred) {
                decor.setPreferred(record.preferred);
            }
            implicitSettings |= 0x400000000000000L;
        }
        if (record.attributeNames != null && !decor.isAttributesExplicitEmpty()) {
            EMap attrs = decor.getAttributes();
            int i = 0;
            while (i < record.attributeNames.length) {
                FeatureAttributeMapEntryImpl entry = (FeatureAttributeMapEntryImpl)((Object)((BeaninfoFactoryImpl)BeaninfoFactory.eINSTANCE).createFeatureAttributeMapEntry());
                entry.setTypedKey(record.attributeNames[i]);
                FeatureAttributeValue fv = record.attributeValues[i];
                fv.setImplicitValue(true);
                entry.setTypedValue(fv);
                attrs.add((Object)entry);
                ++i;
            }
            implicitSettings |= 0x200000000000000L;
        }
        decor.setImplicitlySetBits(implicitSettings);
    }

    public static void applyRecord(BeanDecorator decor, BeanRecord record) {
        BeanInfoDecoratorUtility.applyRecord((FeatureDecorator)decor, (FeatureRecord)record);
        long implicitSettings = decor.getImplicitlySetBits();
        if (record.customizerClassName != null && !decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_CustomizerClass())) {
            decor.setCustomizerClass(BeanInfoDecoratorUtility.createJavaClassProxy(record.customizerClassName));
            implicitSettings |= 1L;
        }
        if (!decor.isSetMergeSuperProperties()) {
            if (decor.isMergeSuperProperties() != record.mergeInheritedProperties) {
                decor.setMergeSuperProperties(record.mergeInheritedProperties);
            }
            implicitSettings |= 2L;
        }
        if (!decor.isSetMergeSuperMethods()) {
            if (decor.isMergeSuperMethods() != record.mergeInheritedOperations) {
                decor.setMergeSuperMethods(record.mergeInheritedOperations);
            }
            implicitSettings |= 4L;
        }
        if (!decor.isSetMergeSuperEvents()) {
            if (decor.isMergeSuperEvents() != record.mergeInheritedEvents) {
                decor.setMergeSuperEvents(record.mergeInheritedEvents);
            }
            implicitSettings |= 8L;
        }
        if (record.notInheritedPropertyNames != null) {
            decor.getNotInheritedPropertyNames().addAll((Collection)Arrays.asList(record.notInheritedPropertyNames));
        }
        if (record.notInheritedOperationNames != null) {
            decor.getNotInheritedMethodNames().addAll((Collection)Arrays.asList(record.notInheritedOperationNames));
        }
        if (record.notInheritedEventNames != null) {
            decor.getNotInheritedEventNames().addAll((Collection)Arrays.asList(record.notInheritedEventNames));
        }
        decor.setImplicitlySetBits(implicitSettings);
    }

    public static void applyRecord(PropertyDecorator decor, PropertyRecord record) {
        BeanInfoDecoratorUtility.applyRecord((FeatureDecorator)decor, (FeatureRecord)record);
        BeanInfoDecoratorUtility.applyOnly(decor, record);
    }

    private static void applyOnly(PropertyDecorator decor, PropertyRecord record) {
        long implicitSettings = decor.getImplicitlySetBits();
        if (record.propertyEditorClassName != null && !decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_PropertyEditorClass())) {
            decor.setPropertyEditorClass(BeanInfoDecoratorUtility.createJavaClassProxy(record.propertyEditorClassName));
            implicitSettings |= 1L;
        }
        if (record.readMethod != null && !decor.isSetReadMethod()) {
            decor.setReadMethod(BeanInfoDecoratorUtility.createJavaMethodProxy(record.readMethod));
            implicitSettings |= 4L;
        }
        if (record.writeMethod != null && !decor.isSetWriteMethod()) {
            decor.setWriteMethod(BeanInfoDecoratorUtility.createJavaMethodProxy(record.writeMethod));
            implicitSettings |= 8L;
        }
        if (record.field != null && !decor.isSetField()) {
            decor.setField(BeanInfoDecoratorUtility.createJavaFieldProxy(record.field));
            if (decor.isFieldReadOnly() != record.field.readOnly) {
                decor.setFieldReadOnly(record.field.readOnly);
            }
            implicitSettings |= 0x80L;
        }
        if (!decor.isSetBound()) {
            if (decor.isBound() != record.bound) {
                decor.setBound(record.bound);
            }
            implicitSettings |= 0x10L;
        }
        if (!decor.isSetConstrained()) {
            if (decor.isConstrained() != record.constrained) {
                decor.setConstrained(record.constrained);
            }
            implicitSettings |= 0x20L;
        }
        if (record.designTime != null && !decor.isSetDesignTime()) {
            decor.setDesignTime(record.designTime);
            implicitSettings |= 0x40L;
        }
        decor.setImplicitlySetBits(implicitSettings);
    }

    public static void applyRecord(IndexedPropertyDecorator decor, IndexedPropertyRecord record) {
        BeanInfoDecoratorUtility.applyRecord((FeatureDecorator)decor, (FeatureRecord)record);
        BeanInfoDecoratorUtility.applyOnly(decor, (PropertyRecord)record);
        long implicitSettings = decor.getImplicitlySetBits();
        if (record.indexedReadMethod != null && !decor.isSetIndexedReadMethod()) {
            decor.setIndexedReadMethod(BeanInfoDecoratorUtility.createJavaMethodProxy(record.indexedReadMethod));
            implicitSettings |= 0x100000L;
        }
        if (record.indexedWriteMethod != null && !decor.isSetIndexedWriteMethod()) {
            decor.setIndexedWriteMethod(BeanInfoDecoratorUtility.createJavaMethodProxy(record.indexedWriteMethod));
            implicitSettings |= 0x200000L;
        }
        decor.setImplicitlySetBits(implicitSettings);
    }

    public static void applyRecord(MethodDecorator decor, MethodRecord record) {
        BeanInfoDecoratorUtility.applyRecord((FeatureDecorator)decor, (FeatureRecord)record);
        long implicitSettings = decor.getImplicitlySetBits();
        if (record.parameters != null && !decor.isParmsExplicitEmpty() && !decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getMethodDecorator_ParameterDescriptors())) {
            EList parms = decor.getSerParmDesc();
            int i = 0;
            while (i < record.parameters.length) {
                ParameterDecorator parm = BeaninfoFactory.eINSTANCE.createParameterDecorator();
                BeanInfoDecoratorUtility.applyRecord(parm, record.parameters[i]);
                parms.add(parm);
                ++i;
            }
            implicitSettings |= 1L;
            implicitSettings &= 0xFFFFFFFFFFFFFFFDL;
        }
        decor.setImplicitlySetBits(implicitSettings);
    }

    public static void applyRecord(ParameterDecorator decor, ParameterRecord record) {
        BeanInfoDecoratorUtility.applyRecord((FeatureDecorator)decor, (FeatureRecord)record);
        long implicitSettings = decor.getImplicitlySetBits();
        if (record.name != null && !decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getParameterDecorator_Name())) {
            decor.setName(record.name);
            implicitSettings |= 1L;
        }
        decor.setImplicitlySetBits(implicitSettings);
    }

    public static void applyRecord(EventSetDecorator decor, EventSetRecord record) {
        BeanInfoDecoratorUtility.applyRecord((FeatureDecorator)decor, (FeatureRecord)record);
        long implicitSettings = decor.getImplicitlySetBits();
        if (record.addListenerMethod != null && !decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_AddListenerMethod())) {
            decor.setAddListenerMethod(BeanInfoDecoratorUtility.createJavaMethodProxy(record.addListenerMethod));
            implicitSettings |= 1L;
        }
        if (record.eventAdapterClassName != null && !decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_EventAdapterClass())) {
            decor.setEventAdapterClass(BeanInfoDecoratorUtility.createJavaClassProxy(record.eventAdapterClassName));
            implicitSettings |= 2L;
        }
        if (record.listenerMethodDescriptors != null && !decor.isListenerMethodsExplicitEmpty() && !decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_ListenerMethods())) {
            EList methods = decor.getSerListMthd();
            int i = 0;
            while (i < record.listenerMethodDescriptors.length) {
                BeaninfoFactory bfact = BeaninfoFactory.eINSTANCE;
                MethodRecord mr = record.listenerMethodDescriptors[i];
                Method method = BeanInfoDecoratorUtility.createJavaMethodProxy(mr.methodForDescriptor);
                MethodProxy mproxy = bfact.createMethodProxy();
                mproxy.setMethod(method);
                mproxy.setName(mr.name);
                MethodDecorator md = bfact.createMethodDecorator();
                BeanInfoDecoratorUtility.applyRecord(md, mr);
                mproxy.getEAnnotations().add((Object)md);
                methods.add(mproxy);
                ++i;
            }
            implicitSettings |= 4L;
            implicitSettings &= 0xFFFFFFFFFFFFFF7FL;
        }
        if (record.listenerTypeName != null && !decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_ListenerType())) {
            decor.setListenerType(BeanInfoDecoratorUtility.createJavaClassProxy(record.listenerTypeName));
            implicitSettings |= 8L;
        }
        if (record.removeListenerMethod != null && !decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_RemoveListenerMethod())) {
            decor.setRemoveListenerMethod(BeanInfoDecoratorUtility.createJavaMethodProxy(record.removeListenerMethod));
            implicitSettings |= 0x10L;
        }
        if (!decor.isSetInDefaultEventSet()) {
            if (record.inDefaultEventSet != decor.isInDefaultEventSet()) {
                decor.setInDefaultEventSet(record.inDefaultEventSet);
            }
            implicitSettings |= 0x20L;
        }
        if (!decor.isSetUnicast()) {
            if (record.unicast != decor.isUnicast()) {
                decor.setUnicast(record.unicast);
            }
            implicitSettings |= 0x40L;
        }
        decor.setImplicitlySetBits(implicitSettings);
    }

    public static JavaClass createJavaClassProxy(String jniName) {
        JavaHelpers jh = BeanInfoDecoratorUtility.createJavaTypeProxy(jniName);
        return jh instanceof JavaClass ? (JavaClass)jh : null;
    }

    public static JavaHelpers createJavaTypeProxy(String jniName) {
        String formalName = MapJNITypes.getFormalTypeName((String)jniName);
        URI uri = Utilities.getJavaClassURI(formalName);
        Object jh = null;
        jh = MapJNITypes.isFormalTypePrimitive((String)formalName) ? JavaRefFactory.eINSTANCE.createJavaDataType() : JavaRefFactory.eINSTANCE.createJavaClass();
        ((InternalEObject)jh).eSetProxyURI(uri);
        return jh;
    }

    public static Method createJavaMethodProxy(ReflectMethodRecord method) {
        String[] parmTypes;
        String[] stringArray = parmTypes = method.parameterTypeNames != null ? new String[method.parameterTypeNames.length] : null;
        if (parmTypes != null) {
            int i = 0;
            while (i < method.parameterTypeNames.length) {
                parmTypes[i] = MapJNITypes.getFormalTypeName((String)method.parameterTypeNames[i]);
                ++i;
            }
        }
        URI uri = Utilities.getMethodURI(MapJNITypes.getFormalTypeName((String)method.className), method.methodName, parmTypes);
        Method methodEMF = JavaRefFactory.eINSTANCE.createMethod();
        ((InternalEObject)methodEMF).eSetProxyURI(uri);
        return methodEMF;
    }

    public static Field createJavaFieldProxy(ReflectFieldRecord field) {
        URI uri = Utilities.getFieldURI(MapJNITypes.getFormalTypeName((String)field.className), field.fieldName);
        Field fieldEMF = JavaRefFactory.eINSTANCE.createField();
        ((InternalEObject)fieldEMF).eSetProxyURI(uri);
        return fieldEMF;
    }

    public static void setProperties(PropertyDecorator prop, boolean bound, boolean constrained, Method getter, Method setter) {
        long implicitSettings = prop.getImplicitlySetBits();
        if (getter != null && !prop.isSetReadMethod()) {
            prop.setReadMethod(getter);
            implicitSettings |= 4L;
        }
        if (setter != null && !prop.isSetWriteMethod()) {
            prop.setWriteMethod(setter);
            implicitSettings |= 8L;
        }
        if (!prop.isSetBound()) {
            if (prop.isBound() != bound) {
                prop.setBound(bound);
            }
            implicitSettings |= 0x10L;
        }
        if (!prop.isSetConstrained()) {
            if (prop.isConstrained() != constrained) {
                prop.setConstrained(constrained);
            }
            implicitSettings |= 0x20L;
        }
        prop.setImplicitlySetBits(implicitSettings);
    }

    public static void setProperties(IndexedPropertyDecorator prop, Method indexedGetter, Method indexedSetter) {
        long implicitSettings = prop.getImplicitlySetBits();
        if (indexedGetter != null && !prop.isSetIndexedReadMethod()) {
            prop.setIndexedReadMethod(indexedGetter);
            implicitSettings |= 0x100000L;
        }
        if (indexedSetter != null && !prop.isSetIndexedWriteMethod()) {
            prop.setIndexedWriteMethod(indexedSetter);
            implicitSettings |= 0x200000L;
        }
        prop.setImplicitlySetBits(implicitSettings);
    }

    public static void setProperties(EventSetDecorator event, Method addListenerMethod, Method removeListenerMethod, boolean unicast, JavaClass listenerType) {
        long implicitSettings = event.getImplicitlySetBits();
        if (addListenerMethod != null && !event.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_AddListenerMethod())) {
            event.setAddListenerMethod(addListenerMethod);
            implicitSettings |= 1L;
        }
        if (removeListenerMethod != null && !event.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_RemoveListenerMethod())) {
            event.setRemoveListenerMethod(removeListenerMethod);
            implicitSettings |= 0x10L;
        }
        if (!event.isSetUnicast()) {
            if (event.isUnicast() != unicast) {
                event.setUnicast(unicast);
            }
            implicitSettings |= 0x10L;
        }
        if (listenerType != null && !event.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_ListenerType())) {
            event.setListenerType(listenerType);
            implicitSettings |= 8L;
        }
        event.setImplicitlySetBits(implicitSettings);
    }

    public static void buildChange(ChangeDescription cd, BeanDecorator bd) {
        if (bd.isMergeIntrospection()) {
            if (bd.getImplicitDecoratorFlag() != ImplicitItem.NOT_IMPLICIT_LITERAL) {
                BeanInfoDecoratorUtility.doAddToEnd(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)bd.getEModelElement()), (EStructuralFeature)EcorePackage.eINSTANCE.getEModelElement_EAnnotations(), bd, true);
            } else {
                BeanInfoDecoratorUtility.buildNonImplicitChange(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)bd), bd);
            }
        }
    }

    public static void buildChange(ChangeDescription cd, PropertyDecorator pd) {
        if (pd.isMergeIntrospection()) {
            boolean indexed = pd.eClass().getClassifierID() == 6;
            EStructuralFeature feature = (EStructuralFeature)pd.getEModelElement();
            switch (pd.getImplicitDecoratorFlag().getValue()) {
                case 1: {
                    List fcs = BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)feature);
                    BeanInfoDecoratorUtility.doAddToEnd(cd, fcs, pd.eContainingFeature(), pd, true);
                    BeanInfoDecoratorUtility.buildNonImplicitChange(cd, fcs, feature, indexed);
                    break;
                }
                case 2: {
                    BeanInfoDecoratorUtility.doAddToEnd(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, feature.eContainer()), feature.eContainingFeature(), feature, true);
                    break;
                }
                case 0: {
                    BeanInfoDecoratorUtility.buildNonImplicitChange(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)pd), pd, indexed);
                    BeanInfoDecoratorUtility.buildNonImplicitChange(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)feature), feature, indexed);
                }
            }
        }
    }

    public static void buildChange(ChangeDescription cd, EventSetDecorator ed) {
        if (ed.isMergeIntrospection()) {
            JavaEvent event = (JavaEvent)ed.getEModelElement();
            switch (ed.getImplicitDecoratorFlag().getValue()) {
                case 1: {
                    List fcs = BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)event);
                    BeanInfoDecoratorUtility.doAddToEnd(cd, fcs, ed.eContainingFeature(), ed, true);
                    BeanInfoDecoratorUtility.buildNonImplicitChange(cd, fcs, event);
                    break;
                }
                case 2: {
                    BeanInfoDecoratorUtility.doAddToEnd(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, event.eContainer()), event.eContainingFeature(), event, true);
                    break;
                }
                case 0: {
                    BeanInfoDecoratorUtility.buildNonImplicitChange(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)ed), ed);
                    BeanInfoDecoratorUtility.buildNonImplicitChange(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)event), event);
                }
            }
        }
    }

    public static void buildChange(ChangeDescription cd, MethodDecorator md) {
        if (md.isMergeIntrospection()) {
            EOperation oper = (EOperation)md.getEModelElement();
            switch (md.getImplicitDecoratorFlag().getValue()) {
                case 1: {
                    List fcs = BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)oper);
                    BeanInfoDecoratorUtility.doAddToEnd(cd, fcs, md.eContainingFeature(), md, true);
                    BeanInfoDecoratorUtility.buildNonImplicitChange(cd, fcs, oper);
                    break;
                }
                case 2: {
                    BeanInfoDecoratorUtility.doAddToEnd(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, oper.eContainer()), oper.eContainingFeature(), oper, true);
                    break;
                }
                case 0: {
                    BeanInfoDecoratorUtility.buildNonImplicitChange(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)md), md);
                    BeanInfoDecoratorUtility.buildNonImplicitChange(cd, BeanInfoDecoratorUtility.getFeatureChangeList(cd, (EObject)oper), oper);
                }
            }
        }
    }

    protected static void buildNonImplicitChange(ChangeDescription cd, List fcs, EStructuralFeature feature, boolean indexed) {
        BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), feature.getName(), false);
        BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Transient(), Boolean.FALSE, false);
        BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Volatile(), Boolean.FALSE, false);
        BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Changeable(), feature.isChangeable(), false);
        BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_EType(), feature.getEType(), false);
        if (!indexed) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_LowerBound(), ZERO, false);
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_UpperBound(), ONE, false);
        } else {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_LowerBound(), ZERO, false);
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_UpperBound(), MINUS_ONE, false);
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_Unique(), Boolean.TRUE, false);
        }
    }

    protected static void buildNonImplicitChange(ChangeDescription cd, List fcs, JavaEvent event) {
        BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), event.getName(), false);
    }

    protected static void buildNonImplicitChange(ChangeDescription cd, List fcs, EOperation oper) {
        BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), oper.getName(), false);
        try {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getMethodProxy_Method(), ((MethodProxy)oper).getMethod(), false);
        }
        catch (ClassCastException classCastException) {}
    }

    protected static void buildNonImplicitChange(ChangeDescription cd, List fcs, FeatureDecorator decor) {
        long implicitSettings = decor.getImplicitlySetBits();
        if (implicitSettings != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getFeatureDecorator_ImplicitlySetBits(), new Long(implicitSettings), false);
        }
        if ((implicitSettings & Long.MIN_VALUE) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getFeatureDecorator_DisplayName(), decor.getDisplayName(), false);
        }
        if ((implicitSettings & 0x4000000000000000L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getFeatureDecorator_ShortDescription(), decor.getShortDescription(), false);
        }
        if ((implicitSettings & 0x2000000000000000L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getFeatureDecorator_Category(), decor.getCategory(), false);
        }
        if ((implicitSettings & 0x1000000000000000L) != 0L && decor.isSetExpert()) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getFeatureDecorator_Expert(), decor.isExpert(), false);
        }
        if ((implicitSettings & 0x800000000000000L) != 0L && decor.isSetHidden()) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getFeatureDecorator_Hidden(), decor.isHidden(), false);
        }
        if ((implicitSettings & 0x400000000000000L) != 0L && decor.isSetPreferred()) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getFeatureDecorator_Preferred(), decor.isPreferred(), false);
        }
        if ((implicitSettings & 0x200000000000000L) != 0L) {
            Iterator itr = decor.getAttributes().listIterator();
            while (itr.hasNext()) {
                FeatureAttributeMapEntryImpl entry = (FeatureAttributeMapEntryImpl)((Object)itr.next());
                if (!entry.getTypedValue().isImplicitValue()) continue;
                BeanInfoDecoratorUtility.doAddToEnd(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getFeatureDecorator_Attributes(), (Object)entry, true);
            }
        }
    }

    protected static void buildNonImplicitChange(ChangeDescription cd, List fcs, BeanDecorator decor) {
        BeanInfoDecoratorUtility.buildNonImplicitChange(cd, fcs, (FeatureDecorator)decor);
        long implicitSettings = decor.getImplicitlySetBits();
        if ((implicitSettings & 1L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_CustomizerClass(), decor.getCustomizerClass(), false);
        }
        if ((implicitSettings & 2L) != 0L && decor.isSetMergeSuperProperties()) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_MergeSuperProperties(), decor.isMergeSuperProperties(), false);
        }
        if ((implicitSettings & 4L) != 0L && decor.isSetMergeSuperMethods()) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_MergeSuperMethods(), decor.isMergeSuperMethods(), false);
        }
        if ((implicitSettings & 8L) != 0L && decor.isSetMergeSuperEvents()) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_MergeSuperEvents(), decor.isMergeSuperEvents(), false);
        }
        if (!decor.getNotInheritedPropertyNames().isEmpty()) {
            BeanInfoDecoratorUtility.doAddAllToEnd(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedPropertyNames(), (Collection)decor.getNotInheritedPropertyNames(), false);
        }
        if (!decor.getNotInheritedMethodNames().isEmpty()) {
            BeanInfoDecoratorUtility.doAddAllToEnd(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedMethodNames(), (Collection)decor.getNotInheritedMethodNames(), false);
        }
        if (!decor.getNotInheritedEventNames().isEmpty()) {
            BeanInfoDecoratorUtility.doAddAllToEnd(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedEventNames(), (Collection)decor.getNotInheritedEventNames(), false);
        }
    }

    protected static void buildNonImplicitChange(ChangeDescription cd, List fcs, PropertyDecorator decor, boolean indexed) {
        BeanInfoDecoratorUtility.buildNonImplicitChange(cd, fcs, decor);
        long implicitSettings = decor.getImplicitlySetBits();
        if ((implicitSettings & 1L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_PropertyEditorClass(), decor.getPropertyEditorClass(), false);
        }
        if ((implicitSettings & 4L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_ReadMethod(), decor.getReadMethod(), false);
        }
        if ((implicitSettings & 8L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_WriteMethod(), decor.getWriteMethod(), false);
        }
        if ((implicitSettings & 0x80L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_Field(), decor.getField(), false);
            if (decor.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_FieldReadOnly())) {
                BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_FieldReadOnly(), decor.isFieldReadOnly(), false);
            }
        }
        if ((implicitSettings & 0x10L) != 0L && decor.isSetBound()) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_Bound(), decor.isBound(), false);
        }
        if ((implicitSettings & 0x20L) != 0L && decor.isSetConstrained()) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_Constrained(), decor.isConstrained(), false);
        }
        if ((implicitSettings & 0x40L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_DesignTime(), decor.isDesignTime(), false);
        }
        if (indexed) {
            IndexedPropertyDecorator ipd = (IndexedPropertyDecorator)decor;
            if ((implicitSettings & 0x100000L) != 0L) {
                BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getIndexedPropertyDecorator_IndexedReadMethod(), ipd.getIndexedReadMethod(), false);
            }
            if ((implicitSettings & 0x200000L) != 0L) {
                BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getIndexedPropertyDecorator_IndexedWriteMethod(), ipd.getIndexedWriteMethod(), false);
            }
        }
    }

    protected static void buildNonImplicitChange(ChangeDescription cd, List fcs, EventSetDecorator decor) {
        BeanInfoDecoratorUtility.buildNonImplicitChange(cd, fcs, (FeatureDecorator)decor);
        long implicitSettings = decor.getImplicitlySetBits();
        if ((implicitSettings & 1L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_AddListenerMethod(), decor.getAddListenerMethod(), false);
        }
        if ((implicitSettings & 2L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_EventAdapterClass(), decor.getEventAdapterClass(), false);
        }
        if ((implicitSettings & 4L) != 0L) {
            BeanInfoDecoratorUtility.doAddAllToEnd(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_SerListMthd(), (Collection)decor.getSerListMthd(), true);
        }
        if ((implicitSettings & 8L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_ListenerType(), decor.getListenerType(), false);
        }
        if ((implicitSettings & 0x10L) != 0L) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_RemoveListenerMethod(), decor.getRemoveListenerMethod(), false);
        }
        if ((implicitSettings & 0x20L) != 0L && decor.isSetInDefaultEventSet()) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_InDefaultEventSet(), decor.isInDefaultEventSet(), false);
        }
        if ((implicitSettings & 0x40L) != 0L && decor.isSetUnicast()) {
            BeanInfoDecoratorUtility.doSet(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getEventSetDecorator_Unicast(), decor.isUnicast(), false);
        }
    }

    protected static void buildNonImplicitChange(ChangeDescription cd, List fcs, MethodDecorator decor) {
        BeanInfoDecoratorUtility.buildNonImplicitChange(cd, fcs, (FeatureDecorator)decor);
        long implicitSettings = decor.getImplicitlySetBits();
        if ((implicitSettings & 1L) != 0L) {
            BeanInfoDecoratorUtility.doAddAllToEnd(cd, fcs, (EStructuralFeature)BeaninfoPackage.eINSTANCE.getMethodDecorator_SerParmDesc(), (Collection)decor.getSerParmDesc(), true);
        }
    }

    protected static List getFeatureChangeList(ChangeDescription cd, EObject object) {
        List fcs = (List)cd.getObjectChanges().get((Object)object);
        if (fcs == null) {
            Map.Entry entry = ChangeFactory.eINSTANCE.createEObjectToChangesMapEntry(object);
            cd.getObjectChanges().add((Object)entry);
            fcs = (List)entry.getValue();
        }
        return fcs;
    }

    protected static FeatureChange getFeatureChange(List fcs, EStructuralFeature feature) {
        if (!fcs.isEmpty()) {
            int i = 0;
            while (i < fcs.size()) {
                FeatureChange fc = (FeatureChange)fcs.get(i);
                if (fc.getFeature() == feature) {
                    return fc;
                }
                ++i;
            }
        }
        FeatureChange fc = ChangeFactory.eINSTANCE.createFeatureChange(feature, null, true);
        fcs.add(fc);
        return fc;
    }

    protected static Object doAddToEnd(ChangeDescription cd, List fcs, EStructuralFeature feature, Object addedValue, boolean newValue) {
        FeatureChange fc = BeanInfoDecoratorUtility.getFeatureChange(fcs, feature);
        if (newValue) {
            try {
                addedValue = EcoreUtil.copy((EObject)((EObject)addedValue));
                cd.getObjectsToAttach().add((Object)((EObject)addedValue));
            }
            catch (ClassCastException classCastException) {}
        }
        EList lcs = fc.getListChanges();
        ListChange lc = null;
        int i = 0;
        while (i < lcs.size()) {
            ListChange lca = (ListChange)lcs.get(i);
            if (lca.getKind() == ChangeKind.ADD_LITERAL && lca.getIndex() == -1) {
                lc = lca;
                break;
            }
            ++i;
        }
        if (lc == null) {
            lc = ChangeFactory.eINSTANCE.createListChange();
            lcs.add(lc);
        }
        lc.getValues().add(addedValue);
        return addedValue;
    }

    protected static Object doAddAllToEnd(ChangeDescription cd, List fcs, EStructuralFeature feature, Collection addedValues, boolean newValue) {
        FeatureChange fc = BeanInfoDecoratorUtility.getFeatureChange(fcs, feature);
        if (newValue) {
            try {
                addedValues = EcoreUtil.copyAll((Collection)addedValues);
                cd.getObjectsToAttach().addAll(addedValues);
            }
            catch (ClassCastException classCastException) {}
        }
        EList lcs = fc.getListChanges();
        ListChange lc = null;
        int i = 0;
        while (i < lcs.size()) {
            ListChange lca = (ListChange)lcs.get(i);
            if (lca.getKind() == ChangeKind.ADD_LITERAL && lca.getIndex() == -1) {
                lc = lca;
                break;
            }
            ++i;
        }
        if (lc == null) {
            lc = ChangeFactory.eINSTANCE.createListChange();
            lcs.add(lc);
        }
        lc.getValues().addAll(addedValues);
        return addedValues;
    }

    protected static Object doSet(ChangeDescription cd, List fcs, EStructuralFeature feature, Object setValue, boolean newValue) {
        FeatureChange fc = BeanInfoDecoratorUtility.getFeatureChange(fcs, feature);
        if (newValue) {
            try {
                setValue = EcoreUtil.copy((EObject)((EObject)setValue));
                cd.getObjectsToAttach().add((Object)((EObject)setValue));
            }
            catch (ClassCastException classCastException) {}
        }
        if (setValue instanceof EObject) {
            fc.setReferenceValue((EObject)setValue);
        } else {
            fc.setDataValue(EcoreUtil.convertToString((EDataType)((EDataType)feature.getEType()), (Object)setValue));
        }
        return setValue;
    }

    public static interface IntrospectCallBack {
        public BeanDecorator process(BeanRecord var1);

        public PropertyDecorator process(PropertyRecord var1);

        public PropertyDecorator process(IndexedPropertyRecord var1);

        public MethodDecorator process(MethodRecord var1);

        public EventSetDecorator process(EventSetRecord var1);
    }

    private static class ProxyIntrospectCallBack
    implements ICallback {
        private IntrospectCallBack introspectCallback;

        public ProxyIntrospectCallBack(IntrospectCallBack introspectCallback) {
            this.introspectCallback = introspectCallback;
        }

        public Object calledBack(int msgID, IBeanProxy parm) {
            return null;
        }

        public Object calledBack(int msgID, Object parm) {
            return null;
        }

        public Object calledBack(int msgID, Object[] parms) {
            return null;
        }

        public void calledBackStream(int msgID, InputStream is) {
            try {
                ObjectInputStream ois = new ObjectInputStream(is);
                block25: while (true) {
                    int cmdId = ois.readInt();
                    switch (cmdId) {
                        case 1: {
                            try {
                                BeanRecord br = (BeanRecord)ois.readObject();
                                BeanDecorator bd = this.introspectCallback.process(br);
                                if (bd == null) continue block25;
                                BeanInfoDecoratorUtility.clear(bd);
                                BeanInfoDecoratorUtility.applyRecord(bd, br);
                            }
                            catch (IOException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            catch (ClassCastException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            catch (ClassNotFoundException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            continue block25;
                        }
                        case 2: {
                            try {
                                int propCount = ois.readInt();
                                int i = 0;
                                while (true) {
                                    if (i >= propCount) continue block25;
                                    PropertyRecord pr = (PropertyRecord)ois.readObject();
                                    if (pr.getClass() == IndexedPropertyRecord.class) {
                                        IndexedPropertyRecord ipr = (IndexedPropertyRecord)pr;
                                        PropertyDecorator ip = this.introspectCallback.process(ipr);
                                        if (ip != null) {
                                            if (ip.eClass().getClassifierID() == 6) {
                                                BeanInfoDecoratorUtility.applyRecord((IndexedPropertyDecorator)ip, ipr);
                                            } else {
                                                BeanInfoDecoratorUtility.applyRecord(ip, pr);
                                            }
                                        }
                                    } else {
                                        PropertyDecorator p = this.introspectCallback.process(pr);
                                        if (p != null) {
                                            BeanInfoDecoratorUtility.applyRecord(p, pr);
                                        }
                                    }
                                    ++i;
                                }
                            }
                            catch (IOException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            catch (ClassNotFoundException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            catch (ClassCastException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            continue block25;
                        }
                        case 3: {
                            try {
                                int opCount = ois.readInt();
                                int i = 0;
                                while (true) {
                                    if (i >= opCount) continue block25;
                                    MethodRecord mr = (MethodRecord)ois.readObject();
                                    MethodDecorator m = this.introspectCallback.process(mr);
                                    if (m != null) {
                                        BeanInfoDecoratorUtility.applyRecord(m, mr);
                                    }
                                    ++i;
                                }
                            }
                            catch (IOException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            catch (ClassNotFoundException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            catch (ClassCastException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            continue block25;
                        }
                        case 4: {
                            try {
                                int opCount = ois.readInt();
                                int i = 0;
                                while (true) {
                                    if (i >= opCount) continue block25;
                                    EventSetRecord evr = (EventSetRecord)ois.readObject();
                                    EventSetDecorator e = this.introspectCallback.process(evr);
                                    if (e != null) {
                                        BeanInfoDecoratorUtility.applyRecord(e, evr);
                                    }
                                    ++i;
                                }
                            }
                            catch (IOException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            catch (ClassNotFoundException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            catch (ClassCastException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                            }
                            continue block25;
                        }
                        case 5: {
                            return;
                        }
                    }
                    break;
                }
                return;
            }
            catch (IOException e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                return;
            }
        }
    }
}

