/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsp.core.internal.pagevar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.pagedesigner.jsp.core.ListenerList;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.IChangeListener;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.IVariableInfo;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.adapter.IDocumentPageVariableAdapter;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.adapter.IPageVariableAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentPageVariableAdapter
implements IDocumentPageVariableAdapter {
    private IDOMDocument _document;
    private ListenerList _changeListeners = new ListenerList(2);
    private List _variableInfos = new ArrayList();
    private boolean _readingInfo = false;

    public DocumentPageVariableAdapter(IDOMDocument doc) {
        this._document = doc;
    }

    public IVariableInfo[] getBeanInfos() {
        IVariableInfo[] ret = new IVariableInfo[this._variableInfos.size()];
        return this._variableInfos.toArray(ret);
    }

    public void addChangeListener(IChangeListener listener) {
        this.reReadInfo();
        this._changeListeners.add(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this._changeListeners.remove(listener);
    }

    protected void fireChanged() {
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IChangeListener l = (IChangeListener)listeners[i];
            l.changed();
            ++i;
        }
    }

    public boolean isAdapterForType(Object type) {
        return IDocumentPageVariableAdapter.class.equals(type);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        switch (eventType) {
            case 1: 
            case 4: 
            case 5: {
                this.refresh();
            }
        }
    }

    public void refresh() {
        this.reReadInfo();
    }

    protected void reReadInfo() {
        if (this._readingInfo) {
            return;
        }
        try {
            List oldInfo = this._variableInfos;
            this._variableInfos = new ArrayList();
            this.readNode((Node)this._document);
            if (!this.isSame(oldInfo, this._variableInfos)) {
                this.fireChanged();
            }
        }
        finally {
            this._readingInfo = false;
        }
    }

    private boolean isSame(List oldInfo, List list) {
        if (oldInfo.size() != list.size()) {
            return false;
        }
        int i = 0;
        int size = oldInfo.size();
        while (i < size) {
            IVariableInfo info1 = (IVariableInfo)oldInfo.get(i);
            IVariableInfo info2 = (IVariableInfo)list.get(i);
            if (info1 == null) {
                return false;
            }
            if (!info1.equals(info2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void readNode(Node node) {
        NodeList childNodes;
        Element element;
        INodeAdapter obj;
        if (node instanceof INodeNotifier && node instanceof Element && (obj = ((INodeNotifier)(element = (Element)node)).getAdapterFor(IPageVariableAdapter.class)) instanceof IPageVariableAdapter) {
            IPageVariableAdapter adapter = (IPageVariableAdapter)obj;
            if (adapter.supportMultipleVariable(element)) {
                List infos = ((IPageVariableAdapter)obj).getVariableInfos(element);
                if (infos != null) {
                    this._variableInfos.addAll(infos);
                }
            } else {
                IVariableInfo info = adapter.getVariableInfo(element);
                if (info != null) {
                    this._variableInfos.add(info);
                }
            }
        }
        if ((childNodes = node.getChildNodes()) != null) {
            int i = 0;
            int length = childNodes.getLength();
            while (i < length) {
                Node childNode = childNodes.item(i);
                this.readNode(childNode);
                ++i;
            }
        }
    }
}

