/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.css.core.internal.document.CSSSelectorItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;

class CSSSimpleSelector
extends CSSSelectorItem
implements ICSSSimpleSelector {
    private String fName = null;
    private String fCachedString = null;
    private StringBuffer fStringBuf = null;
    private List fPseudoName = null;
    private List fAttribute = null;
    private List fClass = null;
    private List fID = null;

    void addAttribute(String attribute) {
        if (this.fAttribute == null) {
            this.fAttribute = new ArrayList();
        }
        this.fAttribute.add(attribute);
        this.addToBuf("[");
        this.addToBuf(attribute);
        this.addToBuf("]");
        this.fCachedString = null;
    }

    void addClass(String cls) {
        if (this.fClass == null) {
            this.fClass = new ArrayList();
        }
        this.fClass.add(cls);
        this.addToBuf(".");
        this.addToBuf(cls);
        this.fCachedString = null;
    }

    void addID(String id) {
        if (this.fID == null) {
            this.fID = new ArrayList();
        }
        this.fID.add(id);
        this.addToBuf("#");
        this.addToBuf(id);
        this.fCachedString = null;
    }

    void addPseudoName(String cls) {
        if (this.fPseudoName == null) {
            this.fPseudoName = new ArrayList();
        }
        this.fPseudoName.add(cls);
        this.addToBuf(":");
        this.addToBuf(cls);
        this.fCachedString = null;
    }

    private void addToBuf(String str) {
        if (this.fStringBuf == null) {
            this.fStringBuf = new StringBuffer();
        }
        this.fStringBuf.append(str);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CSSSimpleSelector foreign = (CSSSimpleSelector)obj;
        if (this.getName().compareToIgnoreCase(foreign.getName()) != 0) {
            return false;
        }
        if (this.getNumOfPseudoNames() != foreign.getNumOfPseudoNames()) {
            return false;
        }
        int i = 0;
        while (i < this.getNumOfPseudoNames()) {
            if (this.getPseudoName(i).compareToIgnoreCase(foreign.getPseudoName(i)) != 0) {
                return false;
            }
            ++i;
        }
        if (this.getNumOfClasses() != foreign.getNumOfClasses()) {
            return false;
        }
        i = 0;
        while (i < this.getNumOfClasses()) {
            if (this.getClass(i).compareToIgnoreCase(foreign.getClass(i)) != 0) {
                return false;
            }
            ++i;
        }
        if (this.getNumOfIDs() != foreign.getNumOfIDs()) {
            return false;
        }
        i = 0;
        while (i < this.getNumOfIDs()) {
            if (this.getID(i).compareToIgnoreCase(foreign.getID(i)) != 0) {
                return false;
            }
            ++i;
        }
        if (this.getNumOfAttributes() != foreign.getNumOfAttributes()) {
            return false;
        }
        i = 0;
        while (i < this.getNumOfAttributes()) {
            if (this.getAttribute(i).compareToIgnoreCase(foreign.getAttribute(i)) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getAttribute(int index) {
        if (this.fAttribute != null && index >= 0 && index < this.fAttribute.size()) {
            return (String)this.fAttribute.get(index);
        }
        return "";
    }

    public String getClass(int index) {
        if (this.fClass != null && index >= 0 && index < this.fClass.size()) {
            return (String)this.fClass.get(index);
        }
        return "";
    }

    public String getID(int index) {
        if (this.fID != null && index >= 0 && index < this.fID.size()) {
            return (String)this.fID.get(index);
        }
        return "";
    }

    public int getItemType() {
        return 1;
    }

    public String getName() {
        return this.fName != null ? this.fName : "";
    }

    public int getNumOfAttributes() {
        return this.fAttribute != null ? this.fAttribute.size() : 0;
    }

    public int getNumOfClasses() {
        return this.fClass != null ? this.fClass.size() : 0;
    }

    public int getNumOfIDs() {
        return this.fID != null ? this.fID.size() : 0;
    }

    public int getNumOfPseudoNames() {
        return this.fPseudoName != null ? this.fPseudoName.size() : 0;
    }

    public String getPseudoName(int index) {
        if (this.fPseudoName != null && index >= 0 && index < this.fPseudoName.size()) {
            return (String)this.fPseudoName.get(index);
        }
        return "";
    }

    public String getString() {
        if (this.fCachedString == null) {
            StringBuffer buf = new StringBuffer(this.getName());
            if (this.fStringBuf != null) {
                buf.append(this.fStringBuf.toString());
            }
            this.fCachedString = buf.toString();
        }
        return this.fCachedString;
    }

    public boolean isUniversal() {
        return this.fName == null || this.fName.equals("*");
    }

    void setName(String name) {
        this.fName = name;
        this.fCachedString = null;
    }
}

