/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import org.eclipse.wst.ws.internal.explorer.platform.actions.SelectNodeToolAction;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Tool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ViewTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.transformer.WSILViewSelectionTransformer;

public class SelectWSILToolAction
extends SelectNodeToolAction {
    public SelectWSILToolAction(Controller controller) {
        super(controller, controller.getWSILPerspective().getNodeManager());
    }

    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new WSILViewSelectionTransformer(this.controller_);
        return transformers;
    }

    public static String getActionLink(int nodeID, int toolID, int viewID, int viewToolID, boolean keepHistory) {
        StringBuffer actionLink = new StringBuffer("wsil/actions/SelectWSILToolActionJSP.jsp?");
        actionLink.append("nodeId");
        actionLink.append('=');
        actionLink.append(nodeID);
        actionLink.append('&');
        actionLink.append("toolId");
        actionLink.append('=');
        actionLink.append(toolID);
        if (viewID != -1) {
            actionLink.append('&');
            actionLink.append("viewId");
            actionLink.append('=');
            actionLink.append(viewID);
            actionLink.append('&');
            actionLink.append("viewToolId");
            actionLink.append('=');
            actionLink.append(viewToolID);
        }
        if (keepHistory) {
            actionLink.append('&');
            actionLink.append("isHistory");
            actionLink.append("=1");
        }
        return actionLink.toString();
    }

    protected String getActionLinkForHistory() {
        boolean keepHistory = false;
        Node selectedNode = this.getSelectedNode();
        Tool selectedTool = this.getSelectedTool();
        byte toolType = this.getSelectedTool().getToolType();
        if (toolType == 0) {
            keepHistory = true;
        } else if (toolType == 2) {
            int viewID = selectedNode.getViewId();
            if (viewID == -1) {
                keepHistory = true;
            } else if (((ViewTool)selectedTool).getToolManager(viewID).getTool(selectedNode.getViewToolId()).getToolType() != 1) {
                keepHistory = true;
            }
        }
        if (keepHistory) {
            return SelectWSILToolAction.getActionLink(selectedNode.getNodeId(), selectedTool.getToolId(), selectedNode.getViewId(), selectedNode.getViewToolId(), true);
        }
        return null;
    }

    public final String getTreeContentVar() {
        return "wsilNavigatorContent";
    }

    public final String getTreeContentPage() {
        return "wsil/wsil_navigator_content.jsp";
    }

    public final String getPropertiesContainerVar() {
        return "wsilPropertiesContainer";
    }

    public final String getPropertiesContainerPage() {
        return "wsil/wsil_properties_container.jsp";
    }

    public final String getPropertiesContentVar() {
        return "wsilPropertiesContent";
    }

    public final String getPropertiesContentPage() {
        return "wsil/wsil_properties_content.jsp";
    }

    public final int getPerspectiveId() {
        return 1;
    }
}

