/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.codeassist;

import java.util.Stack;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TryStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;

public class ThrownExceptionFinder
extends ASTVisitor {
    private SimpleSet thrownExceptions;
    private Stack exceptionsStack;

    public ReferenceBinding[] find(TryStatement tryStatement, BlockScope scope) {
        this.thrownExceptions = new SimpleSet();
        this.exceptionsStack = new Stack();
        tryStatement.traverse(this, scope);
        this.removeCaughtExceptions(tryStatement);
        Object[] result = new ReferenceBinding[this.thrownExceptions.elementSize];
        this.thrownExceptions.asArray(result);
        return result;
    }

    private void acceptException(ReferenceBinding binding) {
        if (binding != null && binding.isValidBinding()) {
            this.thrownExceptions.add(binding);
        }
    }

    public void endVisit(MessageSend messageSend, BlockScope scope) {
        if (messageSend.binding != null) {
            this.endVisitMethodInvocation(messageSend.binding);
        }
        super.endVisit(messageSend, scope);
    }

    public void endVisit(AllocationExpression allocationExpression, BlockScope scope) {
        if (allocationExpression.binding != null) {
            this.endVisitMethodInvocation(allocationExpression.binding);
        }
        super.endVisit(allocationExpression, scope);
    }

    public void endVisit(ThrowStatement throwStatement, BlockScope scope) {
        this.acceptException((ReferenceBinding)throwStatement.exception.resolvedType);
        super.endVisit(throwStatement, scope);
    }

    private void endVisitMethodInvocation(MethodBinding methodBinding) {
        ReferenceBinding[] thrownExceptionBindings = methodBinding.thrownExceptions;
        int length = thrownExceptionBindings == null ? 0 : thrownExceptionBindings.length;
        int i = 0;
        while (i < length) {
            this.acceptException(thrownExceptionBindings[i]);
            ++i;
        }
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        return this.visitType(typeDeclaration);
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        return this.visitType(memberTypeDeclaration);
    }

    public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        return this.visitType(localTypeDeclaration);
    }

    private boolean visitType(TypeDeclaration typeDeclaration) {
        return false;
    }

    public boolean visit(TryStatement tryStatement, BlockScope scope) {
        SimpleSet exceptionSet;
        this.exceptionsStack.push(this.thrownExceptions);
        this.thrownExceptions = exceptionSet = new SimpleSet();
        tryStatement.tryBlock.traverse(this, scope);
        this.removeCaughtExceptions(tryStatement);
        this.thrownExceptions = (SimpleSet)this.exceptionsStack.pop();
        Object[] values = exceptionSet.values;
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                this.thrownExceptions.add(values[i]);
            }
            ++i;
        }
        Block[] catchBlocks = tryStatement.catchBlocks;
        int length = catchBlocks == null ? 0 : catchBlocks.length;
        int i2 = 0;
        while (i2 < length) {
            catchBlocks[i2].traverse(this, scope);
            ++i2;
        }
        return false;
    }

    private void removeCaughtExceptions(TryStatement tryStatement) {
        Argument[] catchArguments = tryStatement.catchArguments;
        int length = catchArguments == null ? 0 : catchArguments.length;
        int i = 0;
        while (i < length) {
            TypeBinding exception = catchArguments[i].type.resolvedType;
            if (exception != null && exception.isValidBinding()) {
                this.removeCaughtException((ReferenceBinding)exception);
            }
            ++i;
        }
    }

    private void removeCaughtException(ReferenceBinding caughtException) {
        Object[] exceptions = this.thrownExceptions.values;
        int i = 0;
        while (i < exceptions.length) {
            ReferenceBinding exception = (ReferenceBinding)exceptions[i];
            if (exception != null && (exception == caughtException || caughtException.isSuperclassOf(exception))) {
                this.thrownExceptions.remove(exception);
            }
            ++i;
        }
    }
}

