/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.perspective;

import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;

public class J2EEPerspective
implements IPerspectiveFactory {
    protected static String ID_SERVERS_VIEW = "org.eclipse.wst.server.ui.ServersView";
    protected static String ID_J2EE_HIERARCHY_VIEW = "org.eclipse.ui.navigator.ProjectExplorer";
    private static String ID_WST_SNIPPETS_VIEW = "org.eclipse.wst.common.snippets.internal.ui.SnippetsView";
    private static final String ID_SEARCH_VIEW = "org.eclipse.search.ui.views.SearchView";
    private static final String ID_DATA_VIEW = "org.eclipse.datatools.connectivity.DataSourceExplorerNavigator";
    public static final String ID_CONSOLE_VIEW = "org.eclipse.ui.console.ConsoleView";

    public J2EEPerspective() {
        String viewerID = J2EEPlugin.getDefault().getJ2EEPreferences().getString("perspective_hierarchy_view_id");
        if (viewerID != null) {
            ID_J2EE_HIERARCHY_VIEW = viewerID;
        }
    }

    public void createInitialLayout(IPageLayout layout) {
        this.defineLayout(layout);
        this.defineActions(layout);
    }

    public void defineActions(IPageLayout layout) {
        layout.addActionSet("org.eclipse.jst.j2ee.J2eeMainActionSet");
        layout.addActionSet("org.eclipse.jdt.ui.JavaActionSet");
        layout.addActionSet("org.eclipse.debug.ui.launchActionSet");
        layout.addActionSet("org.eclipse.debug.ui.debugActionSet");
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
        layout.addShowViewShortcut(ID_J2EE_HIERARCHY_VIEW);
        layout.addShowViewShortcut(ID_SERVERS_VIEW);
        layout.addShowViewShortcut(ID_DATA_VIEW);
        layout.addShowViewShortcut("org.eclipse.ui.views.BookmarkView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        layout.addShowViewShortcut("org.eclipse.ui.views.PropertySheet");
        layout.addShowViewShortcut("org.eclipse.ui.views.ResourceNavigator");
        layout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        layout.addShowViewShortcut(ID_WST_SNIPPETS_VIEW);
        layout.addShowViewShortcut(ID_SEARCH_VIEW);
        layout.addShowViewShortcut(ID_CONSOLE_VIEW);
        layout.addShowInPart(ID_J2EE_HIERARCHY_VIEW);
    }

    public void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout topLeft = layout.createFolder("topLeft", 1, 0.25f, editorArea);
        topLeft.addView(ID_J2EE_HIERARCHY_VIEW);
        topLeft.addPlaceholder("org.eclipse.ui.views.ResourceNavigator");
        topLeft.addPlaceholder("org.eclipse.jdt.ui.TypeHierarchy");
        topLeft.addPlaceholder(JavaUI.ID_PACKAGES_VIEW);
        IFolderLayout bottomRight = layout.createFolder("bottomRight", 4, 0.7f, editorArea);
        bottomRight.addView("org.eclipse.ui.views.ProblemView");
        bottomRight.addView("org.eclipse.ui.views.TaskList");
        bottomRight.addView("org.eclipse.ui.views.PropertySheet");
        bottomRight.addView(ID_SERVERS_VIEW);
        this.addDBViewIfPresent(layout, bottomRight);
        bottomRight.addView(ID_WST_SNIPPETS_VIEW);
        bottomRight.addPlaceholder(ID_CONSOLE_VIEW);
        bottomRight.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        bottomRight.addPlaceholder("org.eclipse.ui.views.ProgressView");
        bottomRight.addPlaceholder(ID_SEARCH_VIEW);
        IFolderLayout topRight = layout.createFolder("topRight", 2, 0.7f, editorArea);
        topRight.addView("org.eclipse.ui.views.ContentOutline");
    }

    private void addDBViewIfPresent(IPageLayout page, IFolderLayout bottomRight) {
        IViewDescriptor dbView = PlatformUI.getWorkbench().getViewRegistry().find(ID_DATA_VIEW);
        if (dbView != null) {
            bottomRight.addView(ID_DATA_VIEW);
        }
    }
}

