/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.emf2xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRenderer;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.ResourceSetWorkbenchEditSynchronizer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.emf2xml.EMF2DOMSSEAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class EMF2DOMSSERenderer
extends EMF2DOMRenderer
implements IModelStateListener,
IModelLifecycleListener {
    protected Object aboutToChangeNode = null;
    protected boolean isBatchChanges = false;
    private boolean isSaving = false;
    private IModelManager modelManager;
    private Class resourceClass;
    protected IDOMModel xmlModel;
    protected String xmlModelId;
    protected boolean xmlModelReverted = false;

    public void accessForRead() {
        if (!this.resource.isNew()) {
            String id = this.getModelManagerId();
            this.getModelManager().getExistingModelForRead((Object)id);
        }
    }

    public void accessForWrite() {
        this.modelAccessForWrite();
    }

    public void batchModeEnd() {
        this.getXMLModel().changedModel();
        this.setRootNodeAdapterNotificationEnabled(true);
        this.isBatchChanges = false;
    }

    public void batchModeStart() {
        this.isBatchChanges = true;
        this.getXMLModel().aboutToChangeModel();
        this.setRootNodeAdapterNotificationEnabled(false);
    }

    private void cacheSynchronizationStamp() {
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        if (file != null && this.xmlModel != null) {
            this.xmlModel.resetSynchronizationStamp((IResource)file);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createDocument() {
        TranslatorResource res = this.getResource();
        res.setDefaults();
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        InputStream is = null;
        try {
            block11: {
                try {
                    try {
                        if (!file.getProject().isOpen()) {
                            file.getProject().open(null);
                        }
                        Stack<IContainer> containers = new Stack<IContainer>();
                        IContainer parent = file.getParent();
                        while (parent != null && parent.getType() == 2) {
                            containers.push(parent);
                            parent = parent.getParent();
                        }
                        while (true) {
                            block12: {
                                if (!containers.isEmpty()) break block12;
                                if (!file.exists()) {
                                    is = DOMUtilities.createHeaderInputStream((String)res.getDoctype(), (String)res.getPublicId(), (String)res.getSystemId());
                                    file.create(is, true, null);
                                }
                                break;
                            }
                            IFolder folder = (IFolder)containers.pop();
                            if (folder.isAccessible()) continue;
                            folder.create(true, true, null);
                        }
                    }
                    catch (CoreException e1) {
                        Logger.logException(e1);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                {
                    Object var7_10 = null;
                    if (is == null) break block11;
                }
                is.close();
            }
            this.initializeXMLModel(file, this.resource.getWriteCount() != 0);
            return;
        }
        catch (IOException iOException) {
            Logger.log(4, "IWAE0017E Unexpected IO exception occurred creating xml document");
        }
    }

    protected void createDOMTreeIfNecessary() {
        if (this.needsToCreateDOM) {
            this.createDOMTree();
        }
    }

    protected EMF2DOMAdapter createRootDOMAdapter() {
        return new EMF2DOMSSEAdapter(this.getResource(), this.document, (EMF2DOMRenderer)this, this.getResource().getRootTranslator());
    }

    public void deRegisterAsModelLifecycleListener() {
        if (this.xmlModel != null) {
            this.xmlModel.removeModelLifecycleListener(this);
        }
    }

    public void deRegisterAsModelStateListener() {
        if (this.xmlModel != null) {
            this.xmlModel.removeModelStateListener(this);
        }
    }

    private void deregisterFromXMLModel() {
        EMF2DOMAdapter adapter;
        this.deRegisterAsModelStateListener();
        this.deRegisterAsModelLifecycleListener();
        try {
            this.getModelManager();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (this.xmlModel != null) {
            int writeCount = this.resource.getWriteCount();
            int readCount = this.resource.getReadCount();
            int i = 0;
            while (i < writeCount) {
                this.xmlModel.releaseFromEdit();
                ++i;
            }
            int ii = 0;
            while (ii < readCount) {
                this.xmlModel.releaseFromRead();
                ++ii;
            }
        }
        if ((adapter = (EMF2DOMAdapter)EcoreUtil.getAdapter((List)this.resource.eAdapters(), (Object)EMF2DOMAdapter.ADAPTER_CLASS)) != null) {
            adapter.removeAdapters(adapter.getNode());
        }
        this.xmlModel = null;
        this.xmlModelId = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(OutputStream outputStream, Map options) throws IOException {
        try {
            this.isSaving = true;
            if (outputStream != null) {
                throw new RuntimeException(String.valueOf(((Object)((Object)this)).getClass().getName()) + " should not use an OutputStream for saving");
            }
            this.createDOMTreeIfNecessary();
            ResourceSetWorkbenchEditSynchronizer synchronizer = (ResourceSetWorkbenchEditSynchronizer)((ProjectResourceSet)this.resource.getResourceSet()).getSynchronizer();
            IFile aFile = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
            try {
                synchronizer.preSave(aFile, (Resource)this.resource);
                this.xmlModel.save(aFile);
            }
            catch (CoreException ex) {
                synchronizer.removeFromRecentlySavedList(aFile);
                Logger.logException(ex);
            }
            this.cacheSynchronizationStamp();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.isSaving = false;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.isSaving = false;
            return;
        }
    }

    public EMF2DOMAdapter getExistingDOMAdapter(Node node) {
        INodeNotifier sseNode = (INodeNotifier)node;
        Collection adapters = sseNode.getAdapters();
        Iterator iterator = adapters.iterator();
        while (iterator.hasNext()) {
            INodeAdapter adapter = (INodeAdapter)iterator.next();
            if (adapter == null || !adapter.isAdapterForType((Object)EMF2DOMAdapter.ADAPTER_CLASS)) continue;
            EMF2DOMSSEAdapter e2DAdapter = (EMF2DOMSSEAdapter)adapter;
            if (this.getResource() == null || e2DAdapter.getTarget() == null) {
                if (!this.resourceClass.equals(e2DAdapter.getResourceClass())) continue;
                return e2DAdapter;
            }
            if (e2DAdapter.getTarget() instanceof Resource) {
                if (e2DAdapter.getTarget() != this.getResource()) continue;
                return e2DAdapter;
            }
            TranslatorResource myTarget = this.getResource();
            EObject adapterTarget = (EObject)e2DAdapter.getTarget();
            if (adapterTarget.eResource() != myTarget && adapterTarget.eResource() != null) continue;
            return e2DAdapter;
        }
        return null;
    }

    protected IModelManager getModelManager() {
        if (this.modelManager == null) {
            this.modelManager = StructuredModelManager.getModelManager();
        }
        return this.modelManager;
    }

    protected String getModelManagerId() {
        if (this.xmlModelId == null) {
            IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.getResource());
            this.xmlModelId = file != null ? this.getModelManager().calculateId(file) : this.resource.getURI() + Long.toString(System.currentTimeMillis());
        }
        return this.xmlModelId;
    }

    protected ResourceSet getResourceSet() {
        return this.resource == null ? null : this.resource.getResourceSet();
    }

    public IDOMModel getXMLModel() {
        return this.xmlModel;
    }

    public String getXMLModelId() {
        return this.xmlModelId;
    }

    private IDOMModel initializeXMLModel(IFile file, boolean forWrite) throws UnsupportedEncodingException, IOException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException(file == null ? "null" : file.getFullPath().toString());
        }
        try {
            IModelManager manager = this.getModelManager();
            IDOMModel mod = null;
            mod = forWrite ? (IDOMModel)manager.getModelForEdit(file) : (IDOMModel)manager.getModelForRead(file);
            this.setXMLModel(mod);
            this.setXMLModelId(this.getXMLModel().getId());
            this.needsToCreateDOM = false;
        }
        catch (CoreException e) {
            Logger.logException(e);
            return null;
        }
        String id = this.getXMLModel().getId();
        this.syncReferenceCounts(id, forWrite);
        if (this.xmlModel != null) {
            this.document = this.xmlModel.getDocument();
        }
        return this.xmlModel;
    }

    public boolean isBatchMode() {
        return this.isBatchChanges;
    }

    public boolean isModified() {
        return this.getXMLModel() != null && this.getXMLModel().isDirty();
    }

    public boolean isShared() {
        if (this.xmlModel == null) {
            String id = this.getModelManagerId();
            return this.getModelManager().isShared((Object)id);
        }
        if (this.getResourceSet() == null) {
            return false;
        }
        return this.xmlModel.isShared();
    }

    public boolean isSharedForWrite() {
        if (this.getResourceSet() == null || this.xmlModel == null) {
            return false;
        }
        return this.xmlModel.isSharedForEdit();
    }

    protected void loadDocument(InputStream in, Map options) throws IOException {
        if (in != null) {
            throw new RuntimeException(String.valueOf(((Object)((Object)this)).getClass().getName()) + " should not use an InputStream for loading");
        }
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        this.initializeXMLModel(file, this.resource.getWriteCount() != 0);
        this.cacheSynchronizationStamp();
    }

    protected boolean managesDOMAdapters() {
        return false;
    }

    public void modelAboutToBeChanged(IStructuredModel model) {
        if (model.getStructuredDocument() != null) {
            this.aboutToChangeNode = model.getStructuredDocument().getFirstStructuredDocumentRegion();
        }
    }

    public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
    }

    private void modelAccessForWrite() {
        String id = this.getModelManagerId();
        this.getModelManager().getExistingModelForEdit((Object)id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modelChanged(IStructuredModel model) {
        if (this.isBatchChanges) {
            return;
        }
        try {
            block9: {
                if (this.aboutToChangeNode != null && model.getStructuredDocument() != null && model.getStructuredDocument().getFirstStructuredDocumentRegion() != this.aboutToChangeNode) {
                    String id = this.getModelManagerId();
                    IStructuredModel tempModel = null;
                    try {
                        tempModel = this.getModelManager().getExistingModelForEdit((Object)id);
                        this.xmlModelReverted = true;
                        this.resource.unload();
                        Object var4_6 = null;
                        if (tempModel == null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (tempModel == null) throw throwable;
                        if (tempModel.getReferenceCountForEdit() <= 0) throw throwable;
                        tempModel.releaseFromEdit();
                        throw throwable;
                    }
                    if (tempModel.getReferenceCountForEdit() > 0) {
                        tempModel.releaseFromEdit();
                    }
                }
            }
            Object var6_9 = null;
            this.aboutToChangeNode = null;
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.aboutToChangeNode = null;
            throw throwable;
        }
    }

    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        if (!isDirty && this.resource.isModified()) {
            this.resource.setModified(false);
            long stamp = WorkbenchResourceHelper.computeModificationStamp((ReferencedResource)this.resource);
            WorkbenchResourceHelper.setSynhronizationStamp((ReferencedResource)this.resource, (long)stamp);
            IProject proj = WorkbenchResourceHelper.getProject((Resource)this.resource);
            ResourceSetWorkbenchEditSynchronizer synchronizer = (ResourceSetWorkbenchEditSynchronizer)((ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)proj)).getSynchronizer();
            IFile aFile = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
            synchronizer.preSave(aFile, (Resource)this.resource);
        }
        if (isDirty) {
            this.resource.setModified(true);
        }
    }

    public void modelReinitialized(IStructuredModel structuredModel) {
    }

    public void modelResourceDeleted(IStructuredModel model) {
    }

    public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
    }

    public void preDelete() {
        if (this.resource.isLoaded()) {
            this.deregisterFromXMLModel();
        }
    }

    public void preUnload() {
        this.deregisterFromXMLModel();
    }

    public void processPostModelEvent(ModelLifecycleEvent event) {
    }

    public void processPreModelEvent(ModelLifecycleEvent event) {
        if (!this.isSaving && event.getType() == 1) {
            ResourceSetWorkbenchEditSynchronizer synchronizer = (ResourceSetWorkbenchEditSynchronizer)((ProjectResourceSet)this.resource.getResourceSet()).getSynchronizer();
            IFile aFile = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
            synchronizer.preSave(aFile, (Resource)this.resource);
        }
    }

    public void registerAsModelLifecycleListener() {
        this.xmlModel.addModelLifecycleListener(this);
    }

    public void registerAsModelStateListener() {
        this.xmlModel.addModelStateListener(this);
    }

    public void releaseFromRead() {
        if (this.xmlModel != null) {
            this.xmlModel.releaseFromRead();
        }
    }

    public void releaseFromWrite() {
        if (this.xmlModel != null) {
            this.xmlModel.releaseFromEdit();
        }
    }

    public void removeDOMAdapter(Node aNode, EMF2DOMAdapter anAdapter) {
        ((IDOMNode)aNode).removeAdapter((EMF2DOMSSEAdapter)anAdapter);
    }

    public void replaceDocumentType(String docTypeName, String publicId, String systemId) {
        if (this.document == null) {
            return;
        }
        DocumentTypeImpl docType = (DocumentTypeImpl)this.document.getDoctype();
        if (docType == null) {
            return;
        }
        if (publicId == null && systemId == null) {
            this.document.removeChild(docType);
        } else {
            docType.setPublicId(publicId);
            docType.setSystemId(systemId);
        }
    }

    public void setBatchMode(boolean isBatch) {
        if (isBatch && this.isBatchChanges) {
            Logger.log(201, "setBatch was set to true when it was already true. This can be an indication of invalid calling order");
        }
        if (isBatch) {
            this.batchModeStart();
        } else {
            this.batchModeEnd();
        }
    }

    private void setRootNodeAdapterNotificationEnabled(boolean b) {
        EMF2DOMAdapter adapter;
        EObject root = this.resource.getRootObject();
        if (root != null && (adapter = (EMF2DOMAdapter)EcoreUtil.getExistingAdapter((Notifier)root, (Object)EMF2DOMAdapter.ADAPTER_CLASS)) != null) {
            adapter.setNotificationEnabled(b);
            if (b) {
                adapter.updateDOM();
            }
        }
    }

    public void setXMLModel(IDOMModel xmlModel) {
        this.deRegisterAsModelStateListener();
        this.deRegisterAsModelLifecycleListener();
        this.xmlModel = xmlModel;
        this.registerAsModelStateListener();
        this.registerAsModelLifecycleListener();
    }

    public void setXMLModelId(String id) {
        this.xmlModelId = id;
    }

    private void syncReferenceCounts(String id, boolean forWrite) {
        int editIndex = 0;
        int readIndex = 0;
        if (forWrite) {
            ++editIndex;
        } else {
            ++readIndex;
        }
        int writeCount = this.resource.getWriteCount();
        int readCount = this.resource.getReadCount();
        int i = writeCount;
        while (i > editIndex) {
            this.modelManager.getExistingModelForEdit((Object)id);
            --i;
        }
        i = readCount;
        while (i > readIndex) {
            this.modelManager.getExistingModelForRead((Object)id);
            --i;
        }
    }

    public boolean useStreamsForIO() {
        return false;
    }

    public boolean wasReverted() {
        return this.xmlModelReverted;
    }

    public void setResource(TranslatorResource resource) {
        super.setResource(resource);
        if (resource != null) {
            this.resourceClass = resource.getClass();
        }
    }
}

