/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.EntityGroup;
import org.eclipse.jst.jsf.common.metadata.IncludeEntityGroup;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelMergeAssistant;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModel;
import org.eclipse.jst.jsf.common.metadata.internal.StandardModelFactory;
import org.eclipse.jst.jsf.common.metadata.internal.TaglibDomainMetaDataModelContextImpl;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.HierarchicalSearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleEntityQueryVisitorImpl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleResultSet;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleTraitQueryVisitorImpl;

public class MetaDataModelMergeAssistantImpl
implements IMetaDataModelMergeAssistant {
    private MetaDataModel mergedModel;
    private EcoreUtil.Copier copier;
    private SimpleEntityQueryVisitorImpl entityVisitor;
    private SimpleTraitQueryVisitorImpl traitVisitor;
    private IMetaDataSourceModelProvider provider;

    public MetaDataModelMergeAssistantImpl(MetaDataModel model) {
        this.mergedModel = model;
        this.copier = new EcoreUtil.Copier();
        this.entityVisitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        this.traitVisitor = new SimpleTraitQueryVisitorImpl(new SearchControl(1));
    }

    public MetaDataModel getMergedModel() {
        return this.mergedModel;
    }

    public IMetaDataSourceModelProvider getSourceModelProvider() {
        return this.provider;
    }

    public void setSourceModelProvider(IMetaDataSourceModelProvider provider) {
        this.provider = provider;
    }

    public void addEntityGroup(EntityGroup entityGroup) {
        Model model = (Model)this.getMergedModel().getRoot();
        if (!this.isExistingEntityGroup(model, entityGroup)) {
            model.getEntityGroups().add((Object)entityGroup);
        }
    }

    public boolean addEntity(Entity entity) {
        Entity mmEntity = this.getMergedEntity(entity);
        if (mmEntity == null) {
            this.addEntityAsNecessary((Entity)entity.eContainer(), entity);
            return true;
        }
        this.addIncludeGroupsAsNecessary(mmEntity, entity);
        return false;
    }

    public Entity getMergedEntity(Entity queryRoot, String entityKey) {
        Entity ret = null;
        SimpleResultSet rs = (SimpleResultSet)this.entityVisitor.findEntities(queryRoot, entityKey);
        try {
            if (!rs.getResults().isEmpty()) {
                ret = (Entity)rs.getResults().get(0);
            }
            rs.close();
        }
        catch (MetaDataException e) {
            JSFCommonPlugin.log(4, "Error in getMergedEntity()", e);
        }
        return ret;
    }

    private void addIncludeGroupsAsNecessary(Entity mmEntity, Entity entity) {
        for (IncludeEntityGroup grp : entity.getIncludeGroups()) {
            boolean found = false;
            for (IncludeEntityGroup grp2 : mmEntity.getIncludeGroups()) {
                if (!grp2.equals(grp)) continue;
                found = true;
                break;
            }
            if (found) continue;
            mmEntity.getIncludeGroups().add((Object)grp);
        }
    }

    private Entity addEntityAsNecessary(Entity parent, Entity entity) {
        Entity mmParent = null;
        Entity mmEntity = null;
        if (parent != null && (mmParent = this.getMergedEntity(parent)) == null) {
            mmParent = this.addEntityAsNecessary((Entity)entity.eContainer(), entity);
        }
        if (mmParent != null) {
            mmEntity = this.addEntityInternal(mmParent, entity);
            return mmEntity;
        }
        return mmEntity;
    }

    private boolean isExistingEntityGroup(Model model, EntityGroup entityGroup) {
        boolean found = false;
        Iterator it = model.getEntityGroups().iterator();
        while (it.hasNext()) {
            if (!entityGroup.getId().equals(((EntityGroup)it.next()).getId())) continue;
            return true;
        }
        return found;
    }

    private Entity getExistingChildEntity(Entity parent, Entity entity) {
        for (Entity foundEntity : parent.getChildEntities()) {
            if (!entity.getId().equals(foundEntity.getId())) continue;
            return foundEntity;
        }
        return null;
    }

    private Entity addEntityInternal(Entity parent, Entity entity) {
        Entity mmEntity = (Entity)this.copier.copy((EObject)entity);
        this.copier.copyReferences();
        parent.getChildEntities().add((Object)mmEntity);
        return mmEntity;
    }

    public boolean addTrait(Entity entity, Trait trait) {
        Entity returnedEntity = this.getMergedEntity(entity);
        if (returnedEntity != null) {
            return this.addTraitAsNecessary(returnedEntity, trait);
        }
        return false;
    }

    private boolean addTraitAsNecessary(Entity mergedEntity, Trait trait) {
        Trait mmTrait = this.getMergedTrait(mergedEntity, trait);
        if (mmTrait == null) {
            this.addTraitInternal(mergedEntity, trait);
            return true;
        }
        return false;
    }

    public void setMergeComplete() {
        Model model = (Model)this.getMergedModel().getRoot();
        if (model != null) {
            StandardModelFactory.debug(">> Begin processIncludeGroups for: " + this.getMergedModel().getModelKey(), StandardModelFactory.DEBUG_MD_LOAD);
            this.processIncludeGroups(model);
            StandardModelFactory.debug(">> End processIncludeGroups for: " + this.getMergedModel().getModelKey(), StandardModelFactory.DEBUG_MD_LOAD);
        }
    }

    private Trait addTraitInternal(Entity parent, Trait trait) {
        Trait mmTrait = (Trait)this.copier.copy((EObject)trait);
        this.copier.copyReferences();
        parent.getTraits().add((Object)mmTrait);
        mmTrait.setSourceModelProvider(trait.getSourceModelProvider());
        return mmTrait;
    }

    private Entity getMergedEntity(Entity entity) {
        if (entity instanceof Model) {
            return (Entity)this.mergedModel.getRoot();
        }
        Entity ret = null;
        String entityKey = this.getIdRelativeToRoot(entity);
        SimpleResultSet rs = (SimpleResultSet)this.entityVisitor.findEntities((Entity)this.mergedModel.getRoot(), entityKey);
        try {
            if (!rs.getResults().isEmpty()) {
                ret = (Entity)rs.getResults().get(0);
            }
            rs.close();
        }
        catch (MetaDataException e) {
            JSFCommonPlugin.log(4, "Error in getMergedEntity()", e);
        }
        return ret;
    }

    private String getIdRelativeToRoot(Entity entity) {
        Entity e = entity;
        StringBuffer buf = new StringBuffer();
        while (e.eContainer() != null) {
            buf.insert(0, e.getId());
            if (e.eContainer() != null && e.eContainer().eContainer() != null) {
                buf.insert(0, "/");
            }
            e = (Entity)e.eContainer();
        }
        return buf.toString();
    }

    public Trait getMergedTrait(Entity entity, Trait trait) {
        SimpleResultSet rs = (SimpleResultSet)this.traitVisitor.findTraits(entity, trait.getId());
        Trait ret = null;
        try {
            if (!rs.getResults().isEmpty()) {
                ret = (Trait)rs.getResults().get(0);
            }
            rs.close();
        }
        catch (MetaDataException e) {
            JSFCommonPlugin.log(4, "Error in getMergedTrait()", e);
        }
        return ret;
    }

    private void processIncludeGroups(Model root) {
        this.addEntityGroupReferencesRecursively(root);
    }

    private void addEntityGroupReferencesRecursively(Entity entity) {
        this.doIncludes(entity);
        int i = 0;
        int size = entity.getChildEntities().size();
        while (i < size) {
            this.addEntityGroupReferencesRecursively((Entity)entity.getChildEntities().get(i));
            ++i;
        }
    }

    private void doIncludes(Entity entity) {
        int j = 0;
        int groupsSize = entity.getIncludeGroups().size();
        while (j < groupsSize) {
            IncludeEntityGroup include = (IncludeEntityGroup)entity.getIncludeGroups().get(j);
            if (include.getId() != null) {
                if (include.getModelUri() == null || include.getModelUri().equals(this.getMergedModel().getModelKey().getUri())) {
                    EntityGroup eg = ((Model)this.getMergedModel().getRoot()).findIncludeGroup(include.getId());
                    this.addIncludeRefs(entity, eg);
                } else {
                    this.addIncludeRefs(entity, include);
                }
            }
            ++j;
        }
    }

    private void addIncludeRefs(Entity entity, IncludeEntityGroup include) {
        TaglibDomainMetaDataModelContextImpl modelContext = new TaglibDomainMetaDataModelContextImpl(this.getMergedModel().getModelKey().getDomain(), this.getMergedModel().getModelKey().getProject(), include.getModelUri());
        Model externalModel = TaglibDomainMetaDataQueryHelper.getModel(modelContext);
        if (externalModel != null) {
            EntityGroup entityGroup = externalModel.findIncludeGroup(include.getId());
            this.addIncludeRefs(entity, entityGroup);
        } else {
            JSFCommonPlugin.log(4, "Unable to load external metadata model refs for " + modelContext.getURI() + " into " + entity.getModel().getCurrentModelContext().getUri());
        }
    }

    private void addIncludeRefs(Entity entity, EntityGroup entityGroup) {
        if (entityGroup == null) {
            return;
        }
        int i = 0;
        int size = entityGroup.getTraits().size();
        while (i < size) {
            this.addTrait(entity, (Trait)entityGroup.getTraits().get(i));
            ++i;
        }
        i = 0;
        size = entityGroup.getChildEntities().size();
        while (i < size) {
            this.traverseAndAddIncludes(entity, (Entity)entityGroup.getChildEntities().get(i));
            ++i;
        }
    }

    private void traverseAndAddIncludes(Entity parent, Entity entity) {
        Entity mergedEntity = this.addIncludedEntityAsNecessary(parent, entity);
        for (Trait trait : entity.getTraits()) {
            this.addTraitAsNecessary(mergedEntity, trait);
        }
        for (Entity e : entity.getChildEntities()) {
            this.traverseAndAddIncludes(mergedEntity, e);
        }
    }

    private Entity addIncludedEntityAsNecessary(Entity parent, Entity entity) {
        Entity mergedEntity = this.getExistingChildEntity(parent, entity);
        if (mergedEntity == null) {
            mergedEntity = this.addEntityInternal(parent, entity);
        }
        return mergedEntity;
    }
}

