/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.model;

import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.tests.model.AbstractModelTest;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public class CSSStyleSheetTest
extends AbstractModelTest {
    private static final String RULE_H1 = "H1 { color : red; }";
    private static final String RULE_H2 = "H2 { color : red; }";
    private static final String RULE_H3 = "H3 { color : red; }";

    public void testInsertRule() {
        ICSSStyleSheet sheet = this.getStyleSheet();
        CSSStyleSheetTest.assertEquals((int)0, (int)sheet.insertRule(RULE_H3, 0));
        CSSStyleSheetTest.assertEquals((int)0, (int)sheet.insertRule(RULE_H1, 0));
        CSSStyleSheetTest.assertEquals((int)1, (int)sheet.insertRule(RULE_H2, 1));
        CSSRuleList ruleList = sheet.getCssRules();
        CSSRule rule = ruleList.item(0);
        CSSStyleSheetTest.assertEquals((String)RULE_H1, (String)rule.getCssText());
        rule = ruleList.item(1);
        CSSStyleSheetTest.assertEquals((String)RULE_H2, (String)rule.getCssText());
        rule = ruleList.item(2);
        CSSStyleSheetTest.assertEquals((String)RULE_H3, (String)rule.getCssText());
    }

    public void testDeleteRule() {
        ICSSStyleSheet sheet = this.getStyleSheet();
        CSSStyleSheetTest.assertEquals((int)0, (int)sheet.insertRule(RULE_H3, 0));
        CSSStyleSheetTest.assertEquals((int)0, (int)sheet.insertRule(RULE_H1, 0));
        CSSStyleSheetTest.assertEquals((int)1, (int)sheet.insertRule(RULE_H2, 1));
        sheet.deleteRule(1);
        CSSRuleList ruleList = sheet.getCssRules();
        CSSRule rule = ruleList.item(0);
        CSSStyleSheetTest.assertEquals((String)RULE_H1, (String)rule.getCssText());
        rule = ruleList.item(1);
        CSSStyleSheetTest.assertEquals((String)RULE_H3, (String)rule.getCssText());
        sheet.deleteRule(1);
        ruleList = sheet.getCssRules();
        rule = ruleList.item(0);
        CSSStyleSheetTest.assertEquals((String)RULE_H1, (String)rule.getCssText());
        sheet.deleteRule(0);
        try {
            sheet.deleteRule(0);
        }
        catch (DOMException e) {
            CSSStyleSheetTest.assertEquals((short)1, (short)e.code);
        }
    }
}

