/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.ui.manager;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.DataModelImpl;
import org.eclipse.wst.common.frameworks.internal.datamodel.DataModelPausibleOperationImpl;
import org.eclipse.wst.common.frameworks.internal.datamodel.IDataModelPausibleOperation;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageGroup;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageGroupHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.SimplePageGroup;
import org.eclipse.wst.common.frameworks.internal.ui.PageGroupManager;
import org.eclipse.wst.common.tests.ui.manager.BaseOperation;
import org.eclipse.wst.common.tests.ui.manager.D;
import org.eclipse.wst.common.tests.ui.manager.TestExtendedProvider;
import org.eclipse.wst.common.tests.ui.manager.TestProvider1;
import org.eclipse.wst.common.tests.ui.manager.TestProvider2;

public class TestGroupManager
extends TestCase {
    private IDataModelPausibleOperation rootOperation;
    private PageGroupManager pageGroupManager;
    private SimplePageGroup pgA;
    private SimplePageGroup pgB;
    private SimplePageGroup pgC;
    private SimplePageGroup pgD;
    private SimplePageGroup pgE;
    private SimplePageGroup pgF;
    private SimplePageGroup pgG;
    private SimplePageGroup pgH;
    private SimplePageGroup pgRoot;
    private WizardPage r1;
    private WizardPage b1;
    private WizardPage b2;
    private WizardPage c1;
    private WizardPage d1;
    private WizardPage d2;
    private WizardPage d3;
    private WizardPage f1;
    private WizardPage f2;
    private WizardPage f3;
    private WizardPage f4;
    private WizardPage f5;
    private WizardPage f6;
    private WizardPage g1;
    private AGroupHandler aGroupHandler;
    private FGroupHandler fGroupHandler;
    private Vector expectedOps;
    private Vector expectedUndoOps;
    private IDataModel dataModel;
    public static final String a;
    public static final String b;
    public static final String c;
    public static final String d;
    public static final String e;
    public static final String f;
    public static final String g;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.tests.ui.manager.A");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        a = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.common.tests.ui.manager.B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        b = clazz2.getName();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.wst.common.tests.ui.manager.C");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        c = clazz3.getName();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.wst.common.tests.ui.manager.D");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        d = clazz4.getName();
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.wst.common.tests.ui.manager.E");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        e = clazz5.getName();
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.wst.common.tests.ui.manager.F");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        f = clazz6.getName();
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.wst.common.tests.ui.manager.G");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        g = clazz7.getName();
    }

    protected void setUp() throws Exception {
        super.setUp();
        BaseOperation.resultList = new Vector();
        BaseOperation.undoList = new Vector();
        this.expectedOps = new Vector();
        this.expectedUndoOps = new Vector();
        this.dataModel = new DataModelImpl((IDataModelProvider)new EmptyProvider());
        this.dataModel.addNestedModel("testprovider1", DataModelFactory.createDataModel((IDataModelProvider)new TestProvider1()));
        this.dataModel.addNestedModel("testprovider2", DataModelFactory.createDataModel((IDataModelProvider)new TestProvider2()));
        this.dataModel.addNestedModel("testextendedprovider", DataModelFactory.createDataModel((IDataModelProvider)new TestExtendedProvider()));
        this.rootOperation = new DataModelPausibleOperationImpl((IDataModelOperation)new D());
        this.rootOperation.setDataModel(this.dataModel);
        this.rootOperation.setEnvironment(EnvironmentService.getEclipseConsoleEnvironment());
        this.r1 = new WizardPage("r1");
        this.b1 = new WizardPage("b1");
        this.b2 = new WizardPage("b2");
        this.c1 = new WizardPage("c1");
        this.d1 = new WizardPage("d1");
        this.d2 = new WizardPage("d2");
        this.d3 = new WizardPage("d3");
        this.f1 = new WizardPage("f1");
        this.f2 = new WizardPage("f2");
        this.f3 = new WizardPage("f3");
        this.f4 = new WizardPage("f4");
        this.f5 = new WizardPage("f5");
        this.f6 = new WizardPage("f6");
        this.g1 = new WizardPage("g1");
        String wizardID = "testWizard";
        this.pgRoot = new SimplePageGroup("Root", wizardID);
        this.pgA = new SimplePageGroup("A", wizardID);
        this.pgB = new SimplePageGroup("B", wizardID, true, c);
        this.pgC = new SimplePageGroup("C", wizardID);
        this.pgD = new SimplePageGroup("D", wizardID, true, c);
        this.pgE = new SimplePageGroup("E", wizardID, true, e);
        this.pgF = new SimplePageGroup("F", wizardID, true, c);
        this.pgG = new SimplePageGroup("G", wizardID);
        this.pgH = new SimplePageGroup("H", wizardID);
        this.pgRoot.addPages((IWizardPage[])new WizardPage[]{this.r1});
        this.pgB.addPages((IWizardPage[])new WizardPage[]{this.b1, this.b2});
        this.pgC.addPages((IWizardPage[])new WizardPage[]{this.c1});
        this.pgD.addPages((IWizardPage[])new WizardPage[]{this.d1, this.d2, this.d3});
        this.pgF.addPages((IWizardPage[])new WizardPage[]{this.f1, this.f2, this.f3, this.f4, this.f5, this.f6});
        this.pgG.addPages((IWizardPage[])new WizardPage[]{this.g1});
        this.pgF.setPageHandler((IDMPageHandler)new FPageHandler());
        this.aGroupHandler = new AGroupHandler();
        this.fGroupHandler = new FGroupHandler();
        this.pgA.setPageGroupHandler((IDMPageGroupHandler)this.aGroupHandler);
        this.pgF.setPageGroupHandler((IDMPageGroupHandler)this.fGroupHandler);
        this.pageGroupManager = new PageGroupManager(this.rootOperation, (IDMPageGroup)this.pgRoot);
        this.pageGroupManager.addGroupAfter("Root", (IDMPageGroup)this.pgA);
        this.pageGroupManager.addGroupAfter("A", (IDMPageGroup)this.pgB);
        this.pageGroupManager.addGroupAfter("A", (IDMPageGroup)this.pgD);
        this.pageGroupManager.addGroupAfter("A", (IDMPageGroup)this.pgE);
        this.pageGroupManager.addGroupAfter("B", (IDMPageGroup)this.pgC);
        this.pageGroupManager.addGroupAfter("E", (IDMPageGroup)this.pgF);
        this.pageGroupManager.addGroupAfter("F", (IDMPageGroup)this.pgG);
        this.pageGroupManager.addGroupAfter("F", (IDMPageGroup)this.pgH);
    }

    public void testSimpleRun() throws Exception {
        HashSet<String> ids = new HashSet<String>();
        ids.add("testprovider1");
        ids.add("testprovider2");
        this.pgA.setDataModelIDs(ids);
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The root page should be null", (this.pageGroupManager.getCurrentPage() == null ? 1 : 0) != 0);
        this.pageGroupManager.moveBackOnePage();
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        this.aGroupHandler.setGroupIDToSelect("B");
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be r1", (this.pageGroupManager.getCurrentPage() == this.r1 ? 1 : 0) != 0);
        this.checkResults();
        TestGroupManager.assertTrue((String)"Data models not Ok for page group A", (boolean)this.checkDataModels());
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be b1", (this.pageGroupManager.getCurrentPage() == this.b1 ? 1 : 0) != 0);
        this.expectedOps.add(a);
        this.expectedOps.add(b);
        this.expectedOps.add(c);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be b2", (this.pageGroupManager.getCurrentPage() == this.b2 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be c1", (this.pageGroupManager.getCurrentPage() == this.c1 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f1", (this.pageGroupManager.getCurrentPage() == this.f1 ? 1 : 0) != 0);
        this.expectedOps.add(d);
        this.expectedOps.add(e);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f3", (this.pageGroupManager.getCurrentPage() == this.f3 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f5", (this.pageGroupManager.getCurrentPage() == this.f5 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f6", (this.pageGroupManager.getCurrentPage() == this.f6 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        this.fGroupHandler.setGroupIDToSelect("G");
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f4", (this.pageGroupManager.getCurrentPage() == this.f4 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertFalse((String)"There should not be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be g1", (this.pageGroupManager.getCurrentPage() == this.g1 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveBackOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f4", (this.pageGroupManager.getCurrentPage() == this.f4 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveBackOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f4", (this.pageGroupManager.getCurrentPage() == this.f6 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveBackOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f4", (this.pageGroupManager.getCurrentPage() == this.f5 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveBackOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f4", (this.pageGroupManager.getCurrentPage() == this.f3 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveBackOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f4", (this.pageGroupManager.getCurrentPage() == this.f1 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveBackOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f4", (this.pageGroupManager.getCurrentPage() == this.c1 ? 1 : 0) != 0);
        this.expectedOps.setSize(3);
        this.expectedUndoOps.add(e);
        this.expectedUndoOps.add(d);
        this.checkResults();
        this.pageGroupManager.moveBackOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be b2", (this.pageGroupManager.getCurrentPage() == this.b2 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveBackOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be b1", (this.pageGroupManager.getCurrentPage() == this.b1 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveBackOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The root page should be r1", (this.pageGroupManager.getCurrentPage() == this.r1 ? 1 : 0) != 0);
        this.expectedOps = new Vector();
        this.expectedUndoOps.add(c);
        this.expectedUndoOps.add(b);
        this.expectedUndoOps.add(a);
        this.checkResults();
        this.reset();
        this.aGroupHandler.setGroupIDToSelect("D");
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be d1", (this.pageGroupManager.getCurrentPage() == this.d1 ? 1 : 0) != 0);
        this.expectedOps.add(a);
        this.expectedOps.add(b);
        this.expectedOps.add(c);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be d2", (this.pageGroupManager.getCurrentPage() == this.d2 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be d3", (this.pageGroupManager.getCurrentPage() == this.d3 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f1", (this.pageGroupManager.getCurrentPage() == this.f1 ? 1 : 0) != 0);
        this.expectedOps.add(d);
        this.expectedOps.add(e);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f3", (this.pageGroupManager.getCurrentPage() == this.f3 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f5", (this.pageGroupManager.getCurrentPage() == this.f5 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        TestGroupManager.assertTrue((String)"There should be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f6", (this.pageGroupManager.getCurrentPage() == this.f6 ? 1 : 0) != 0);
        this.checkResults();
        this.pageGroupManager.moveForwardOnePage();
        this.fGroupHandler.setGroupIDToSelect(null);
        TestGroupManager.assertFalse((String)"There should not be a next page", (boolean)this.pageGroupManager.hasNextPage());
        TestGroupManager.assertTrue((String)"The page should be f4", (this.pageGroupManager.getCurrentPage() == this.f4 ? 1 : 0) != 0);
        this.checkResults();
    }

    private void checkResults() {
        TestGroupManager.assertTrue((String)("Expected=" + this.expectedOps.size() + " executed=" + BaseOperation.resultList.size()), (BaseOperation.resultList.size() == this.expectedOps.size() ? 1 : 0) != 0);
        int index = 0;
        while (index < BaseOperation.resultList.size()) {
            TestGroupManager.assertEquals(this.expectedOps.elementAt(index), BaseOperation.resultList.elementAt(index));
            ++index;
        }
        TestGroupManager.assertTrue((String)("Expected undo=" + this.expectedUndoOps.size() + " executed=" + BaseOperation.undoList.size()), (BaseOperation.undoList.size() == this.expectedUndoOps.size() ? 1 : 0) != 0);
        index = 0;
        while (index < BaseOperation.undoList.size()) {
            TestGroupManager.assertEquals(this.expectedUndoOps.elementAt(index), BaseOperation.undoList.elementAt(index));
            ++index;
        }
    }

    private void reset() {
        BaseOperation.resultList.removeAllElements();
        this.expectedOps.removeAllElements();
        BaseOperation.undoList.removeAllElements();
        this.expectedUndoOps.removeAllElements();
    }

    private boolean checkDataModels() {
        IDataModel model = this.dataModel;
        boolean containsModel1 = model.isNestedModel("testprovider1");
        boolean containsModel2 = model.isNestedModel("testprovider2");
        boolean prop1 = model.isPropertySet("provider1Prop1");
        boolean prop2 = model.isPropertySet("provider1Prop2");
        boolean prop3 = model.isPropertySet("provider1Prop3");
        boolean prop4 = model.isPropertySet("provider1Prop4");
        boolean prop5 = model.isPropertySet("provider2Prop1");
        boolean prop6 = model.isPropertySet("provider2Prop2");
        boolean prop7 = model.isPropertySet("provider2Prop3");
        boolean prop8 = model.isPropertySet("provider2Prop4");
        boolean value1 = model.getProperty("provider1Prop1").equals("11");
        boolean value2 = model.getProperty("provider1Prop2").equals("22");
        boolean value3 = model.getProperty("provider1Prop3").equals("33");
        boolean value4 = model.getProperty("provider1Prop4").equals("44");
        boolean value5 = model.getProperty("provider2Prop1").equals("1111");
        boolean value6 = model.getProperty("provider2Prop2").equals("2222");
        boolean value7 = model.getProperty("provider2Prop3").equals("3333");
        boolean value8 = model.getProperty("provider2Prop4").equals("4444");
        return containsModel1 && containsModel2 && prop1 && prop2 && prop3 && prop4 && prop5 && prop6 && prop7 && prop8 && value1 && value2 && value3 && value4 && value5 && value6 && value7 && value8;
    }

    private class AGroupHandler
    implements IDMPageGroupHandler {
        private String groupID_;

        private AGroupHandler() {
        }

        public String getNextPageGroup(String currentPageGroupID, String[] pageGroupIDs) {
            Object result = null;
            result = currentPageGroupID == null ? this.groupID_ : (currentPageGroupID.equals("E") ? null : "E");
            return result;
        }

        public void setGroupIDToSelect(String id) {
            this.groupID_ = id;
        }
    }

    private class EmptyProvider
    extends AbstractDataModelProvider {
        private EmptyProvider() {
        }

        public Set getPropertyNames() {
            return new HashSet();
        }
    }

    private class FGroupHandler
    implements IDMPageGroupHandler {
        private String groupID_;

        private FGroupHandler() {
        }

        public String getNextPageGroup(String currentPageGroupID, String[] pageGroupIDs) {
            if (currentPageGroupID == null) {
                return this.groupID_;
            }
            return null;
        }

        public void setGroupIDToSelect(String id) {
            this.groupID_ = id;
        }
    }

    private class FPageHandler
    implements IDMPageHandler {
        private FPageHandler() {
        }

        public String getNextPage(String currentPageName, String expectedNextPageName) {
            String result = null;
            if (currentPageName == null) {
                result = "f1";
            } else if (currentPageName.equals("f1")) {
                result = "IDMExtendedPageHandler.SKIP_PAGE";
            } else if (currentPageName.equals("f3")) {
                result = "IDMExtendedPageHandler.PAGE_BEFOREf6";
            } else if (currentPageName.equals("f4")) {
                result = null;
            } else if (currentPageName.equals("f5")) {
                result = "IDMExtendedPageHandler.PAGE_AFTERf5";
            } else if (currentPageName.equals("f6")) {
                result = "f4";
            }
            return result;
        }

        public String getPreviousPage(String currentPageName, String expectedPreviousPageName) {
            return expectedPreviousPageName;
        }
    }

    private class WizardPage
    extends DataModelWizardPage {
        private boolean canFinish_ = true;

        public WizardPage(String id) {
            super(TestGroupManager.this.dataModel, id);
        }

        protected Composite createTopLevelComposite(Composite parent) {
            return null;
        }

        protected String[] getValidationPropertyNames() {
            return new String[0];
        }

        public void setCanFinish(boolean canFinish) {
            this.canFinish_ = canFinish;
        }

        public boolean canPageFinish() {
            return this.canFinish_;
        }

        public IDataModelOperation createOperation() {
            return null;
        }
    }
}

