/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.tests.performance;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.tests.performance.TestsPlugin;
import org.osgi.framework.Bundle;

public class MementoTestCase
extends PerformanceTestCase {
    protected static IPath getLocalPath(IPath path2) {
        try {
            URL url = FileLocator.find((Bundle)TestsPlugin.instance.getBundle(), (IPath)path2, null);
            url = FileLocator.toFileURL((URL)url);
            return new Path(url.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void testMementoLoad() throws Exception {
        IPath path = MementoTestCase.getLocalPath(new Path("data").append("publish.xml"));
        int i = 0;
        while (i < 5) {
            this.startMeasuring();
            XMLMemento.loadMemento((String)path.toOSString());
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testMementoSave() throws Exception {
        IPath path = MementoTestCase.getLocalPath(new Path("data").append("publish.xml"));
        File f = File.createTempFile("perftest", null);
        XMLMemento memento = (XMLMemento)XMLMemento.loadMemento((String)path.toOSString());
        int i = 0;
        while (i < 5) {
            this.startMeasuring();
            memento.saveToFile(f.getAbsolutePath());
            this.stopMeasuring();
            f.delete();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testMementoCreateSave() throws Exception {
        IPath path = MementoTestCase.getLocalPath(new Path("data").append("publish.xml"));
        File f = File.createTempFile("perftest", null);
        XMLMemento memento = (XMLMemento)XMLMemento.loadMemento((String)path.toOSString());
        int i = 0;
        while (i < 5) {
            this.startMeasuring();
            XMLMemento memento2 = XMLMemento.createWriteRoot((String)"server");
            this.copy((IMemento)memento, (IMemento)memento2);
            memento2.saveToFile(f.getAbsolutePath());
            this.stopMeasuring();
            f.delete();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    protected void copy(IMemento a, IMemento b) {
        IMemento child;
        IMemento ch;
        int n;
        int n2;
        IMemento[] iMementoArray;
        IMemento[] children;
        String s = a.getString("name");
        if (s != null) {
            b.putString("name", s);
        }
        if ((s = a.getString("module-ids")) != null) {
            b.putString("module-ids", s);
        }
        if ((s = a.getString("module-type-id")) != null) {
            b.putString("module-type-id", s);
        }
        if ((s = a.getString("module-type-version")) != null) {
            b.putString("module-type-version", s);
        }
        if ((s = a.getString("stamp")) != null) {
            b.putString("stamp", s);
        }
        if ((children = a.getChildren("module")) != null) {
            iMementoArray = children;
            n2 = children.length;
            n = 0;
            while (n < n2) {
                ch = iMementoArray[n];
                child = b.createChild("module");
                this.copy(ch, child);
                ++n;
            }
        }
        if ((children = a.getChildren("folder")) != null) {
            iMementoArray = children;
            n2 = children.length;
            n = 0;
            while (n < n2) {
                ch = iMementoArray[n];
                child = b.createChild("folder");
                this.copy(ch, child);
                ++n;
            }
        }
        if ((children = a.getChildren("file")) != null) {
            iMementoArray = children;
            n2 = children.length;
            n = 0;
            while (n < n2) {
                ch = iMementoArray[n];
                child = b.createChild("file");
                this.copy(ch, child);
                ++n;
            }
        }
    }
}

