/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetConfigurationDialog;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;

public class ConfigureWorkingSetAction
extends Action {
    private final IWorkbenchPartSite fSite;
    private WorkingSetModel fWorkingSetModel;

    public ConfigureWorkingSetAction(IWorkbenchPartSite site) {
        super(WorkingSetMessages.ConfigureWorkingSetAction_label);
        this.fSite = site;
    }

    public void setWorkingSetModel(WorkingSetModel model) {
        this.fWorkingSetModel = model;
    }

    public void run() {
        ArrayList<IWorkingSet> workingSets = new ArrayList<IWorkingSet>(Arrays.asList(this.fWorkingSetModel.getAllWorkingSets()));
        IWorkingSet[] activeWorkingSets = this.fWorkingSetModel.getActiveWorkingSets();
        WorkingSetConfigurationDialog dialog = new WorkingSetConfigurationDialog(this.fSite.getShell(), workingSets.toArray(new IWorkingSet[workingSets.size()]), activeWorkingSets);
        dialog.setSelection(activeWorkingSets);
        if (dialog.open() == 0) {
            IWorkingSet[] selection = dialog.getSelection();
            this.fWorkingSetModel.setActiveWorkingSets(selection);
        }
    }
}

