/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.CSSPathService;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class CSSTextPropertyDescriptor
extends TextPropertyDescriptor {
    private final ICSSNode fNode;

    public CSSTextPropertyDescriptor(String id, String displayName, ICSSNode node) {
        super((Object)id, displayName);
        this.fNode = node;
    }

    public CSSTextPropertyDescriptor(String id, String displayName, ICSSNode node, String category) {
        super((Object)id, displayName);
        this.fNode = node;
        this.setCategory(category);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ICSSModel model = this.fNode.getOwnerDocument().getModel();
        if (model == null) {
            return null;
        }
        if (model.getStyleSheetType() == "externalCSS" && CSSTextPropertyDescriptor.findEditor(model) == null) {
            return null;
        }
        ICSSModel structuredModel = model;
        if (model.getStyleSheetType() != "externalCSS" && (structuredModel = ((IDOMNode)model.getOwnerDOMNode()).getModel()) == null) {
            return null;
        }
        IFile file = CSSPathService.location2File((String)structuredModel.getBaseLocation());
        if (file == null || file.isReadOnly()) {
            return null;
        }
        return super.createPropertyEditor(parent);
    }

    private static IEditorPart findEditor(ICSSModel model) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IEditorReference[] editors = pages[j].getEditorReferences();
                int k = 0;
                while (k < editors.length) {
                    IFile file;
                    IEditorInput editorInput;
                    IEditorPart editPart = editors[k].getEditor(false);
                    if (editPart != null && (editorInput = editPart.getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)editorInput).getFile()) != null && StructuredModelManager.getModelManager().calculateId(file).equals(model.getId())) {
                        return editPart;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

