/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticListValueModel<E>
extends AbstractModel
implements ListValueModel<E> {
    protected final List<? extends E> list;
    private static final long serialVersionUID = 1L;

    public StaticListValueModel(E[] array) {
        this(CollectionTools.list(array));
    }

    public StaticListValueModel(List<? extends E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.list = list;
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyIterator<E>(this.list.iterator());
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator<E>(this.list.listIterator());
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public String toString() {
        return StringTools.buildToStringFor(this, this.list);
    }
}

