/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class AssociationOverrideTests
extends JavaResourceModelTestCase {
    private static final String ASSOCIATION_OVERRIDE_NAME = "MY_ASSOCIATION_OVERRIDE";

    public AssociationOverrideTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAssociationOverrideOnField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\")");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideWithJoinColumns() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.JoinColumn"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn})");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        AssociationOverrideTests.assertNotNull((Object)associationOverride);
        AssociationOverrideTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        AssociationOverrideTests.assertNotNull((Object)associationOverride);
        AssociationOverrideTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
        associationOverride.setName("Foo");
        AssociationOverrideTests.assertEquals((String)"Foo", (String)associationOverride.getName());
        this.assertSourceContains("@AssociationOverride(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        AssociationOverrideTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
        associationOverride.setName(null);
        AssociationOverrideTests.assertNull((Object)associationOverride.getName());
        this.assertSourceDoesNotContain("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\")", cu);
        this.assertSourceContains("@AssociationOverride", cu);
    }

    public void testJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        AssociationOverrideTests.assertEquals((int)0, (int)associationOverride.joinColumnsSize());
    }

    public void testJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        associationOverride.addJoinColumn(0);
        associationOverride.addJoinColumn(1);
        AssociationOverrideTests.assertEquals((int)2, (int)associationOverride.joinColumnsSize());
    }

    public void testJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        AssociationOverrideTests.assertEquals((int)2, (int)associationOverride.joinColumnsSize());
    }

    public void testAddJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        associationOverride.addJoinColumn(0).setName("FOO");
        associationOverride.addJoinColumn(1);
        associationOverride.addJoinColumn(0).setName("BAR");
        AssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(0).getName());
        AssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(1).getName());
        AssociationOverrideTests.assertNull((Object)associationOverride.joinColumnAt(2).getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn})", cu);
    }

    public void testRemoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        associationOverride.addJoinColumn(0).setName("FOO");
        ListIterator joinColumns = associationOverride.joinColumns();
        AssociationOverrideTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrideTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrideTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrideTests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\"), @JoinColumn})", cu);
        associationOverride.removeJoinColumn(1);
        joinColumns = associationOverride.joinColumns();
        AssociationOverrideTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrideTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrideTests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn})", cu);
        associationOverride.removeJoinColumn(0);
        joinColumns = associationOverride.joinColumns();
        AssociationOverrideTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrideTests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = @JoinColumn)", cu);
        associationOverride.setName(null);
        associationOverride.removeJoinColumn(0);
        this.assertSourceDoesNotContain("@AssociationOverride", cu);
    }

    public void testMoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        associationOverride.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn})", cu);
        associationOverride.moveJoinColumn(2, 0);
        AssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(0).getName());
        AssociationOverrideTests.assertNull((Object)associationOverride.joinColumnAt(1).getName());
        AssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(2).getName());
        AssociationOverrideTests.assertEquals((int)3, (int)associationOverride.joinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn, @JoinColumn(name = \"FOO\")})", cu);
    }

    public void testMoveJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        associationOverride.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn})", cu);
        associationOverride.moveJoinColumn(0, 2);
        AssociationOverrideTests.assertNull((Object)associationOverride.joinColumnAt(0).getName());
        AssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(1).getName());
        AssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(2).getName());
        AssociationOverrideTests.assertEquals((int)3, (int)associationOverride.joinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn, @JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")})", cu);
    }

    public void testSetJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        AssociationOverrideTests.assertEquals((int)2, (int)associationOverride.joinColumnsSize());
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)associationOverride.joinColumns().next();
        AssociationOverrideTests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        AssociationOverrideTests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn})", cu);
    }
}

