/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;

public class AWTStateChangeListenerWrapper
implements StateChangeListener {
    private final StateChangeListener listener;

    public AWTStateChangeListenerWrapper(StateChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void stateChanged(StateChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            this.stateChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildRunnable(event));
        }
    }

    private Runnable buildRunnable(final StateChangeEvent event) {
        return new Runnable(){

            public void run() {
                AWTStateChangeListenerWrapper.this.stateChanged_(event);
            }
        };
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void stateChanged_(StateChangeEvent event) {
        this.listener.stateChanged(event);
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ")";
    }
}

