/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.strategy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.policy.IIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.strategy.IIdentifiableStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.StrategyComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IteratorPolicyBasedStrategyComposite<INPUT, OUTPUT, IDTYPE, STRATEGYTYPE extends IIdentifiableStrategy<INPUT, OUTPUT, IDTYPE>>
extends StrategyComposite<INPUT, OUTPUT, IDTYPE, STRATEGYTYPE> {
    private final Map<IDTYPE, STRATEGYTYPE> _strategies;
    private IIteratorPolicy<IDTYPE> _policy;
    private final Object _changeLock = new Object();

    protected IteratorPolicyBasedStrategyComposite(IIteratorPolicy<IDTYPE> policy) {
        this._policy = policy;
        this._strategies = new HashMap<IDTYPE, STRATEGYTYPE>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addStrategy(STRATEGYTYPE strategy) {
        Object object = this._changeLock;
        synchronized (object) {
            this._strategies.put(strategy.getId(), strategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeStrategy(STRATEGYTYPE strategy) {
        Object object = this._changeLock;
        synchronized (object) {
            this._strategies.remove(strategy.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPolicy(IIteratorPolicy<IDTYPE> policy) {
        if (policy == null) {
            JSFCommonPlugin.log(new Exception("stack trace only"), "Policy can't be null");
            return;
        }
        Object object = this._changeLock;
        synchronized (object) {
            this._policy = policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<STRATEGYTYPE> getIterator() {
        IIteratorPolicy<IDTYPE> policy = null;
        Map<Object, Object> strategies = Collections.emptyMap();
        Object object = this._changeLock;
        synchronized (object) {
            policy = this._policy;
            strategies = Collections.unmodifiableMap(new HashMap<IDTYPE, STRATEGYTYPE>(this._strategies));
        }
        Iterator<Object> iterator = policy.getIterator(strategies.keySet());
        return new StrategyIterator(strategies, iterator);
    }

    @Override
    public abstract OUTPUT getNoResult();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrategyIterator<IDTYPE, STRATEGYTYPE>
    implements Iterator<STRATEGYTYPE> {
        private final Map<IDTYPE, STRATEGYTYPE> _map;
        private final Iterator<IDTYPE> _policyIterator;

        private StrategyIterator(Map<IDTYPE, STRATEGYTYPE> map, Iterator<IDTYPE> policyIterator) {
            this._map = map;
            this._policyIterator = policyIterator;
        }

        @Override
        public boolean hasNext() {
            return this._policyIterator.hasNext();
        }

        @Override
        public STRATEGYTYPE next() {
            IDTYPE id = this._policyIterator.next();
            return this._map.get(id);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

