/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IMemberValuePair;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class MemberValuePair
extends ASTNode
implements IMemberValuePair {
    public char[] name;
    public Expression value;
    public MethodBinding binding;
    public ElementValuePair compilerElementPair = null;

    public MemberValuePair(char[] token, int sourceStart, int sourceEnd, Expression value) {
        this.name = token;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.value = value;
        if (value instanceof ArrayInitializer) {
            value.bits |= 1;
        }
    }

    public StringBuffer print(int indent, StringBuffer output) {
        output.append(this.name).append(" = ");
        this.value.print(0, output);
        return output;
    }

    public void resolveTypeExpecting(BlockScope scope, TypeBinding requiredType) {
        TypeBinding valueType;
        if (this.value == null) {
            this.compilerElementPair = new ElementValuePair(this.name, this.value, this.binding);
            return;
        }
        if (requiredType == null) {
            if (this.value instanceof ArrayInitializer) {
                this.value.resolveTypeExpecting(scope, (TypeBinding)null);
            } else {
                this.value.resolveType(scope);
            }
            this.compilerElementPair = new ElementValuePair(this.name, this.value, this.binding);
            return;
        }
        this.value.setExpectedType(requiredType);
        if (this.value instanceof ArrayInitializer) {
            ArrayInitializer initializer = (ArrayInitializer)this.value;
            valueType = initializer.resolveTypeExpecting(scope, this.binding.returnType);
        } else if (this.value instanceof ArrayAllocationExpression) {
            this.value.resolveType(scope);
            valueType = null;
        } else {
            valueType = this.value.resolveType(scope);
        }
        this.compilerElementPair = new ElementValuePair(this.name, this.value, this.binding);
        if (valueType == null) {
            return;
        }
        TypeBinding leafType = requiredType.leafComponentType();
        if (!(this.value.isConstantValueOfTypeAssignableToType(valueType, requiredType) || requiredType.isBaseType() && BaseTypeBinding.isWidening(requiredType.id, valueType.id) || valueType.isCompatibleWith(requiredType))) {
            if (!(requiredType.isArrayType() && requiredType.dimensions() == 1 && (this.value.isConstantValueOfTypeAssignableToType(valueType, leafType) || leafType.isBaseType() && BaseTypeBinding.isWidening(leafType.id, valueType.id)) || valueType.isCompatibleWith(leafType))) {
                if (!leafType.isAnnotationType() || valueType.isAnnotationType()) {
                    scope.problemReporter().typeMismatchError(valueType, requiredType, this.value);
                }
                return;
            }
        } else {
            scope.compilationUnitScope().recordTypeConversion(requiredType.leafComponentType(), valueType.leafComponentType());
            this.value.computeConversion(scope, requiredType, valueType);
        }
        switch (leafType.erasure().id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 16: {
                break;
            }
            default: {
                if (!leafType.isEnum() && !leafType.isAnnotationType()) break;
            }
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.value != null) {
            this.value.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 71;
    }
}

