/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class ShowInConsoleAction
extends AbstractServerAction {
    public ShowInConsoleAction(ISelectionProvider sp) {
        super(sp, "Console");
        IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor desc = reg.find("org.eclipse.ui.console.ConsoleView");
        this.setText(desc.getLabel());
        this.setImageDescriptor(desc.getImageDescriptor());
    }

    public boolean accept(IServer server) {
        return server.getServerType() != null && server.getServerState() != 4;
    }

    public void perform(IServer server) {
        try {
            ILaunch launch = server.getLaunch();
            this.selectProcess(launch.getProcesses()[0]);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error opening console", e);
        }
    }

    protected void selectProcess(IProcess process) {
        IWorkbenchPage page;
        IConsole.class.toString();
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        org.eclipse.ui.console.IConsole[] consoles = consoleManager.getConsoles();
        int size = consoles.length;
        org.eclipse.ui.console.IConsole console = null;
        int i = 0;
        while (i < size) {
            IConsole con;
            if (consoles[i] instanceof IConsole && process.equals((con = (IConsole)consoles[i]).getProcess())) {
                console = consoles[i];
            }
            ++i;
        }
        if (console == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart part = page.findView("org.eclipse.ui.console.ConsoleView");
            if (part == null) {
                try {
                    part = page.showView("org.eclipse.ui.console.ConsoleView");
                }
                catch (PartInitException partInitException) {
                    Trace.trace((byte)3, "Could not open console view");
                }
            }
            if (part != null) {
                page.activate((IWorkbenchPart)part);
                IConsoleView view = (IConsoleView)part.getAdapter(IConsoleView.class);
                if (view != null) {
                    view.setFocus();
                    view.display(console);
                }
            }
        }
    }
}

