/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.IMutableValidator;
import org.eclipse.wst.validation.MessageSeveritySetting;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.model.FilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorMutable
implements IAdaptable,
IMutableValidator {
    private boolean _build;
    private boolean _manual;
    private String _delegatingId;
    private int _changeCountGroups;
    private int _changeCountMessages;
    private final String _name;
    private final String _sourceId;
    private final boolean _isV1;
    private final boolean _isV2;
    private final ValidatorMetaData _vmd;
    private final String _id;
    private final int _version;
    private FilterGroup[] _groups;
    private final Map<String, MessageSeveritySetting> _messageSettings;
    private final String _validatorClassname;
    private final boolean _origBuild;
    private final boolean _origManual;
    private final String _origDelegating;

    public ValidatorMutable(Validator validator) {
        this._name = validator.getName();
        this._sourceId = validator.getSourceId();
        this._manual = validator.isManualValidation();
        this._build = validator.isBuildValidation();
        Validator.V2 v2 = validator.asV2Validator();
        this._isV2 = v2 != null;
        this._delegatingId = validator.getDelegatingId();
        Validator.V1 v1 = validator.asV1Validator();
        this._isV1 = v1 != null;
        this._vmd = this._isV1 ? v1.getVmd() : null;
        this._id = validator.getId();
        this._origBuild = this._build;
        this._origDelegating = this._delegatingId;
        this._origManual = this._manual;
        this._version = validator.getVersion();
        this._validatorClassname = validator.getValidatorClassname();
        this._messageSettings = new HashMap<String, MessageSeveritySetting>(10);
        for (Map.Entry<String, MessageSeveritySetting> me : validator.getMessageSettings().entrySet()) {
            this._messageSettings.put(me.getKey(), me.getValue().copy());
        }
        if (v2 != null) {
            FilterGroup[] groups = v2.getGroups();
            this._groups = new FilterGroup[groups.length];
            System.arraycopy(groups, 0, this._groups, 0, groups.length);
        }
    }

    public ValidatorMutable(ValidatorMutable val) {
        this._build = val._build;
        this._delegatingId = val._delegatingId;
        FilterGroup[] groups = val.getGroups();
        this._groups = new FilterGroup[groups.length];
        System.arraycopy(groups, 0, this._groups, 0, groups.length);
        this._id = val._id;
        this._isV1 = val._isV1;
        this._isV2 = val._isV2;
        this._manual = val._manual;
        this._messageSettings = new HashMap<String, MessageSeveritySetting>(10);
        for (Map.Entry<String, MessageSeveritySetting> me : val.getMessageSettings().entrySet()) {
            this._messageSettings.put(me.getKey(), me.getValue().copy());
        }
        this._name = val._name;
        this._origBuild = val._origBuild;
        this._origDelegating = val._origDelegating;
        this._origManual = val._origManual;
        this._sourceId = val._sourceId;
        this._validatorClassname = val._validatorClassname;
        this._version = val._version;
        this._vmd = val._vmd;
    }

    @Override
    public void setBuildValidation(boolean build) {
        this._build = build;
    }

    @Override
    public void setManualValidation(boolean manual) {
        this._manual = manual;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isManualValidation() {
        return this._manual;
    }

    @Override
    public boolean isBuildValidation() {
        return this._build;
    }

    public boolean isV2Validator() {
        return this._isV2;
    }

    public String getDelegatingId() {
        return this._delegatingId;
    }

    public ValidatorMetaData getVmd() {
        return this._vmd;
    }

    public boolean isV1Validator() {
        return this._isV1;
    }

    @Override
    public String getId() {
        return this._id;
    }

    public boolean isChanged() {
        if (this.hasGlobalChanges()) {
            return true;
        }
        return this._changeCountGroups > 0 || this._changeCountMessages > 0;
    }

    public boolean hasGlobalChanges() {
        if (this._origBuild != this._build) {
            return true;
        }
        if (this._origManual != this._manual) {
            return true;
        }
        return !Misc.same(this._origDelegating, this._delegatingId);
    }

    public int getVersion() {
        return this._version;
    }

    public void replaceFilterGroup(FilterGroup existing, FilterGroup merged) {
        int i = this.find(existing);
        if (i == -1) {
            this.add(merged);
        } else {
            this._groups[i] = merged;
            this.bumpChangeCountGroups();
        }
    }

    public void remove(FilterGroup group) {
        int i = this.find(group);
        if (i == -1) {
            return;
        }
        FilterGroup[] groups = new FilterGroup[this._groups.length - 1];
        if (i > 0) {
            System.arraycopy(this._groups, 0, groups, 0, i);
        }
        if (i < groups.length) {
            System.arraycopy(this._groups, i + 1, groups, i, groups.length - i);
        }
        this._groups = groups;
        this.bumpChangeCountGroups();
    }

    private int find(FilterGroup group) {
        int i = 0;
        while (i < this._groups.length) {
            if (group == this._groups[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void add(FilterGroup fg) {
        assert (fg != null);
        FilterGroup[] groups = new FilterGroup[this._groups.length + 1];
        System.arraycopy(this._groups, 0, groups, 0, this._groups.length);
        groups[this._groups.length] = fg;
        this._groups = groups;
        this.bumpChangeCountGroups();
    }

    private void bumpChangeCountGroups() {
        ++this._changeCountGroups;
    }

    public int getChangeCountGroups() {
        return this._changeCountGroups;
    }

    public FilterGroup[] getGroups() {
        return this._groups;
    }

    public void setDelegatingId(String id) {
        this._delegatingId = id;
    }

    public Map<String, MessageSeveritySetting> getMessageSettings() {
        return this._messageSettings;
    }

    public void bumpChangeCountMessages() {
        ++this._changeCountMessages;
    }

    @Override
    public String getValidatorClassname() {
        return this._validatorClassname;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean sameConfig(Validator validator) {
        if (validator == null) {
            return false;
        }
        return this.hashCodeForConfig() == validator.hashCodeForConfig();
    }

    private int hashCodeForConfig() {
        int h = 0;
        if (this._build) {
            h += 101;
        }
        if (this._delegatingId != null) {
            h += this._delegatingId.hashCode();
        }
        if (this._manual) {
            h += 201;
        }
        if (this._messageSettings != null) {
            for (MessageSeveritySetting ms : this._messageSettings.values()) {
                h += ms.hashCode();
            }
        }
        if (this._sourceId != null) {
            h += this._sourceId.hashCode();
        }
        h += this._version;
        if (this._id != null) {
            h += this._id.hashCode();
        }
        FilterGroup[] filterGroupArray = this._groups;
        int n = this._groups.length;
        int n2 = 0;
        while (n2 < n) {
            FilterGroup fg = filterGroupArray[n2];
            h += fg.hashCodeForConfig();
            ++n2;
        }
        return h;
    }

    public String toString() {
        return this._name;
    }
}

