/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.dialogs;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jst.j2ee.internal.dialogs.J2EERenameUIConstants;
import org.eclipse.jst.j2ee.internal.dialogs.RenameModuleReferencesComposite;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

@Deprecated
public class RenameModuleComposite
extends Composite
implements J2EERenameUIConstants,
Listener {
    protected RenameModuleReferencesComposite moduleRefsComposite;
    protected Text newNameText = null;
    protected Text newContextRootText = null;
    protected Label newContextRootLabel = null;
    protected String oldName = null;
    protected Button OKButton = null;
    protected Label statusMessageLabel = null;

    public RenameModuleComposite(Composite parent, int style) {
        super(parent, style);
        this.addChildren();
    }

    protected void addChildren() {
        this.addRenameProjectsGroup();
        this.addSeparator();
        this.addRenameModuleRefsComposite();
        this.statusMessageLabel = new Label((Composite)this, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.statusMessageLabel.setLayoutData((Object)data);
        this.statusMessageLabel.setFont(this.getFont());
    }

    protected void addRenameProjectsGroup() {
        GridLayout lay = new GridLayout();
        lay.numColumns = 2;
        this.setLayout((Layout)lay);
        GridData data = new GridData(1808);
        this.setLayoutData(data);
        this.newNameText = new Text((Composite)this, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.newNameText.setLayoutData((Object)data);
        this.newContextRootLabel = new Label((Composite)this, 0);
        this.newContextRootLabel.setText(RENAME_CONTEXT_ROOT);
        data = new GridData(768);
        this.newContextRootLabel.setLayoutData((Object)data);
        this.newContextRootText = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.newContextRootText.setLayoutData((Object)data);
    }

    protected void addRenameModuleRefsComposite() {
        this.moduleRefsComposite = new RenameModuleReferencesComposite(this, 0, false);
    }

    protected void addSeparator() {
        Label sep = new Label((Composite)this, 258);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        sep.setLayoutData((Object)data);
    }

    public boolean shouldRenameProjects() {
        return true;
    }

    public boolean shouldRenameModuleDependencies() {
        return this.moduleRefsComposite.shouldRenameModuleDependencies();
    }

    public boolean shouldRenameModules() {
        return this.moduleRefsComposite.shouldRenameModules();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.newNameText && this.OKButton != null) {
            String newName = this.newNameText.getText();
            if (newName.trim().length() == 0) {
                this.statusMessageLabel.setText("");
                this.OKButton.setEnabled(false);
                return;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject newProject = root.getProject(newName);
            if (newProject.exists()) {
                this.statusMessageLabel.setForeground(JFaceColors.getErrorText((Display)this.statusMessageLabel.getDisplay()));
                Object[] names = new String[]{newName};
                this.statusMessageLabel.setText(MessageFormat.format(J2EEUIMessages.getResourceString("Project_already_exists."), names));
                this.OKButton.setEnabled(false);
            } else {
                this.statusMessageLabel.setText("");
                this.OKButton.setEnabled(true);
            }
        }
    }

    public String getNewName() {
        return this.newNameText.getText();
    }

    public void setNewName(String newName) {
        this.oldName = newName;
        this.newNameText.setText(newName);
        this.newNameText.selectAll();
        this.newNameText.addListener(24, (Listener)this);
    }

    public String getNewContextRoot() {
        return this.newContextRootText.getText();
    }

    public void setNewContextRoot(String newContextRoot) {
        if (newContextRoot != null && newContextRoot.length() > 1) {
            this.newContextRootText.setText(newContextRoot);
        } else {
            this.newContextRootLabel.setVisible(false);
            this.newContextRootText.setVisible(false);
        }
    }

    public void setOKButton(Button oKButton) {
        this.OKButton = oKButton;
        this.OKButton.setEnabled(false);
    }
}

