/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.taglib;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class BuildPathClassLoader
extends ClassLoader {
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/taglibclassloader"));
    private IJavaProject fProject;

    public BuildPathClassLoader(ClassLoader parent, IJavaProject project) {
        super(parent);
        this.fProject = project;
    }

    public void closeJarFile(ZipFile file) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (IOException ioe) {
            Logger.logException("JarUtilities: Could not close file " + file.getName(), ioe);
        }
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        if (DEBUG) {
            System.out.println("finding: [" + className + "]");
        }
        try {
            IType type = this.fProject.findType(className.replace('$', '.'));
            if (type != null) {
                IPath path = null;
                IResource resource = type.getResource();
                if (resource != null) {
                    path = resource.getLocation();
                }
                if (path == null) {
                    path = type.getPath();
                }
                if ("class".equalsIgnoreCase(path.getFileExtension())) {
                    IFile file = null;
                    file = resource != null && resource.getType() == 1 ? (IFile)resource : ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    if (file != null && file.isAccessible()) {
                        byte[] bytes = this.loadBytes(file);
                        return this.defineClass(className, bytes, 0, bytes.length);
                    }
                } else if ("java".equalsIgnoreCase(path.getFileExtension()) && resource != null) {
                    if (resource.getProject() != null) {
                        IJavaProject jProject = JavaCore.create((IProject)resource.getProject());
                        String outputClass = StringUtils.replace((String)type.getFullyQualifiedName(), (String)".", (String)"/").concat(".class");
                        IPath classPath = jProject.getOutputLocation().append(outputClass);
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(classPath);
                        if (file != null && file.isAccessible()) {
                            byte[] bytes = this.loadBytes(file);
                            return this.defineClass(className, bytes, 0, bytes.length);
                        }
                    }
                } else if ("jar".equalsIgnoreCase(path.getFileExtension())) {
                    String expectedFileName = StringUtils.replace((String)className, (String)".", (String)"/").concat(".class");
                    byte[] bytes = this.getCachedInputStream(path.toOSString(), expectedFileName);
                    return this.defineClass(className, bytes, 0, bytes.length);
                }
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
        return super.findClass(className);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getCachedInputStream(String jarFilename, String entryName) {
        ByteArrayOutputStream buffer = null;
        File testFile = new File(jarFilename);
        if (!testFile.exists()) {
            return null;
        }
        ZipFile jarfile = null;
        try {
            block17: {
                try {
                    ZipEntry zentry;
                    jarfile = new ZipFile(jarFilename);
                    if (jarfile == null || (zentry = jarfile.getEntry(entryName)) == null) break block17;
                    InputStream entryInputStream = null;
                    try {
                        entryInputStream = jarfile.getInputStream(zentry);
                    }
                    catch (IOException ioExc) {
                        Logger.logException("JarUtilities: " + jarFilename, ioExc);
                    }
                    if (entryInputStream == null) break block17;
                    buffer = zentry.getSize() > 0L ? new ByteArrayOutputStream((int)zentry.getSize()) : new ByteArrayOutputStream();
                    byte[] bytes = new byte[2048];
                    try {
                        try {
                            int c;
                            while ((c = entryInputStream.read(bytes)) >= 0) {
                                buffer.write(bytes, 0, c);
                            }
                        }
                        catch (IOException iOException) {}
                        Object var10_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        try {
                            entryInputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {
                    }
                    entryInputStream.close();
                }
                catch (IOException ioExc) {
                    Logger.logException("JarUtilities: " + jarFilename, ioExc);
                }
            }
            Object var12_17 = null;
            this.closeJarFile(jarfile);
            if (buffer == null) return new byte[0];
            return buffer.toByteArray();
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.closeJarFile(jarfile);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadBytes(IFile file) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = null;
        try {
            try {
                in = file.getContents();
                byte[] buffer = new byte[4096];
                int read = 0;
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        try {}
        catch (IOException iOException) {
            return out.toByteArray();
        }
        if (in == null) return out.toByteArray();
        in.close();
        return out.toByteArray();
    }
}

