/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.MappedSuperclassAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EntityTests
extends JavaResourceModelTestCase {
    private static final String ENTITY_NAME = "Foo";

    public EntityTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithName() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity(name = \"Foo\")");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassAndEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
                sb.append("@Entity");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EntityAnnotation entity = (EntityAnnotation)typeResource.getMappingAnnotation("javax.persistence.Entity");
        EntityTests.assertTrue((entity != null ? 1 : 0) != 0);
        EntityTests.assertEquals((String)ENTITY_NAME, (String)entity.getName());
    }

    public void testGetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EntityAnnotation entity = (EntityAnnotation)typeResource.getMappingAnnotation("javax.persistence.Entity");
        EntityTests.assertTrue((entity != null ? 1 : 0) != 0);
        EntityTests.assertNull((Object)entity.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EntityAnnotation entity = (EntityAnnotation)typeResource.getMappingAnnotation("javax.persistence.Entity");
        EntityTests.assertNull((Object)entity.getName());
        entity.setName(ENTITY_NAME);
        EntityTests.assertEquals((String)ENTITY_NAME, (String)entity.getName());
        this.assertSourceContains("@Entity(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EntityAnnotation entity = (EntityAnnotation)typeResource.getMappingAnnotation("javax.persistence.Entity");
        EntityTests.assertEquals((String)ENTITY_NAME, (String)entity.getName());
        entity.setName(null);
        EntityTests.assertNull((Object)entity.getName());
        this.assertSourceContains("@Entity", cu);
        this.assertSourceDoesNotContain("@Entity(name = \"Foo\")", cu);
    }

    public void testMappedSuperclassAndEntity() throws Exception {
        ICompilationUnit cu = this.createTestMappedSuperclassAndEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        Annotation mappingAnnotation = typeResource.getMappingAnnotation();
        EntityTests.assertTrue((boolean)(mappingAnnotation instanceof EntityAnnotation));
        MappedSuperclassAnnotation mappedSuperclass = (MappedSuperclassAnnotation)typeResource.getMappingAnnotation("javax.persistence.MappedSuperclass");
        EntityTests.assertNotNull((Object)mappedSuperclass);
    }
}

